/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Redundancy;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_ComputerSystem_NodeToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_ComputerSystem";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        String mDedicated = "0";
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.2";
        mDedicated = "12";
        DBAttributeMapper.RegistrationData mR4 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.0.3";
        mDedicated = "12";
        DBAttributeMapper.RegistrationData mR5 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        mSMIS = "1.1.0";
        mDedicated = "12";
        DBAttributeMapper.RegistrationData mR6 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion, mDedicated);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3, mR4, mR5, mR6};
    }

    public SMISCIM_ComputerSystem_NodeToDBMapper() {
        this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(Redundancy.getColumnInfo("CREATION_CLASS_NAME_ID")));
        ColumnInfo ssID = Redundancy.getColumnInfo("SUBSYSTEM_ID");
        ssID.setIsPrimaryKey();
        MapperInfo ssIDMapperInfo = new MapperInfo(ssID);
        ColumnInfo redIdInfo = Redundancy.getColumnInfo("REDUNDANCY_ID");
        redIdInfo.setAutoGenerated();
        ssIDMapperInfo.setDerivedColumn(redIdInfo);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", ssIDMapperInfo);
        ColumnInfo compID = Redundancy.getColumnInfo("COMPONENT_ID");
        compID.setIsPrimaryKey();
        MapperInfo compIDMapperInfo = new MapperInfo(compID);
        compIDMapperInfo.setDerivedColumn(redIdInfo);
        this.m_htAttribToMapperInfo.put("componentid", new MapperInfo(compID));
        this.m_htAttribToMapperInfo.put("name", new MapperInfo(Redundancy.getColumnInfo("NAME")));
        this.m_dataConverter.addSimpleDataConversion("nameformat", "SMISName_Format");
        this.m_htAttribToMapperInfo.put("nameformat", new MapperInfo(Redundancy.getColumnInfo("NAME_FORMAT")));
        this.m_htAttribToMapperInfo.put("elementname", new MapperInfo(Redundancy.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("ipaddress", new MapperInfo(Redundancy.getColumnInfo("IP_ADDRESS")));
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(Redundancy.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("wwn", new MapperInfo(Redundancy.getColumnInfo("WWN")));
        this.m_htAttribToMapperInfo.put("nodeid", new MapperInfo(Redundancy.getColumnInfo("NODE_ID")));
        this.m_htAttribToMapperInfo.put("iogroupid", new MapperInfo(Redundancy.getColumnInfo("IO_GROUP_ID")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String name;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String opstatus = (String)pParams.get("operationalstatus");
        if (opstatus != null) {
            Vector opArray = SMISCIM_ComputerSystem_NodeToDBMapper.processArrayvalues(opstatus);
            if ((opstatus = DBConstants.convertOperationalstatusArrayToBitValue(opArray)) != null) {
                pParams.put("operationalstatus", opstatus);
            } else {
                pParams.remove("operationalstatus");
            }
        }
        if (pParams.get("componentid") == null && (name = (String)pParams.get("name")) != null) {
            pParams.put("componentid", name);
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

