/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.TapeCartridge;
import org.eclipse.aperi.infrastructure.database.objects.TapeIoport;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaLocation;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCIM_StorageMediaLocationToDBMapper
extends DBAttributeMapper {
    public static final String sMEDIACAPACITY = "mediacapacity";
    public static final String sLOCATIONTYPE = "locationtype";
    public static final String sLOCATIONCOORDINATES = "locationcoordinates";
    public static final String sLIBRARYID = "ref_toplevelsystem_id";
    public static final String sCREATIONCLASSNAME = "creationclassname";
    public static final String sTAG = "tag";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CIM_StorageMediaLocation";
        String mSMIS = "1.1.0";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISCIM_StorageMediaLocationToDBMapper() {
        this.m_htAttribToMapperInfo.put(sMEDIACAPACITY, new MapperInfo(TapeMediaLocation.getColumnInfo("MEDIA_CAPACITY")));
        this.m_htAttribToMapperInfo.put(sLOCATIONTYPE, new MapperInfo(TapeMediaLocation.getColumnInfo("LOCATION_TYPE")));
        this.m_htAttribToMapperInfo.put(sLOCATIONCOORDINATES, new MapperInfo(TapeMediaLocation.getColumnInfo("LOCATION_COORDINATES")));
        this.m_htAttribToMapperInfo.put(sLIBRARYID, new MapperInfo(TapeMediaLocation.getColumnInfo("TAPE_LIBRARY_ID")));
        this.m_htAttribToMapperInfo.put(sCREATIONCLASSNAME, new MapperInfo(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")));
        ColumnInfo mTagCol = TapeMediaLocation.getColumnInfo("TAG");
        mTagCol.setIsPrimaryKey();
        MapperInfo mTagMapperInfo = new MapperInfo(mTagCol);
        ColumnInfo mLocIDInfo = TapeMediaLocation.getColumnInfo("LOCATION_ID");
        mLocIDInfo.setAutoGenerated();
        mTagMapperInfo.setDerivedColumn(mLocIDInfo);
        this.m_htAttribToMapperInfo.put(sTAG, mTagMapperInfo);
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String mCartridgeTag;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        MapperResult mSMLResult = super.persist(pConn, pParams, pScanID);
        String mLocationType = (String)pParams.get(sLOCATIONTYPE);
        String mTapeLibraryID = (String)pParams.get(sLIBRARYID);
        String mTapeLibraryName = (String)pParams.get("ref_toplevelsystem_name");
        String mTapeLibraryNameFormat = (String)pParams.get("ref_toplevelsystem_nameformat");
        String mIOPortDeviceID = (String)pParams.get("ref_device_id");
        mSMLResult.addKeyReference("ref_tape_location_id", TapeMediaLocation.getColumnInfo("LOCATION_ID"));
        mSMLResult.addKeyReference(sLIBRARYID, TapeMediaLocation.getColumnInfo("TAPE_LIBRARY_ID"));
        String mLocationTypeIsIOPort = "6";
        String mLocationTypeIsIOPort2 = "5";
        if ((mLocationType.equals(mLocationTypeIsIOPort) || mLocationType.equals(mLocationTypeIsIOPort2)) && mIOPortDeviceID != null && mTapeLibraryID != null) {
            pParams.putAll(mSMLResult.getKeyReferences());
            SMISIOPortLocationToDBMapper internalIOPortMapper = new SMISIOPortLocationToDBMapper();
            mSMLResult.addMapperResult(internalIOPortMapper.persist(pConn, pParams, pScanID));
        }
        if ((mCartridgeTag = (String)pParams.get("ref_cartridge_tag")) != null) {
            pParams.putAll(mSMLResult.getKeyReferences());
            SMISCartridgeLocationToDBMapper internalCartridgeMapper = new SMISCartridgeLocationToDBMapper();
            mSMLResult.addMapperResult(internalCartridgeMapper.persist(pConn, pParams, pScanID));
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mSMLResult);
        return mSMLResult;
    }

    private class SMISCartridgeLocationToDBMapper
    extends DBAttributeMapper {
        public SMISCartridgeLocationToDBMapper() {
            ColumnInfo mTag = TapeCartridge.getColumnInfo("TAG");
            mTag.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_cartridge_tag", new MapperInfo(mTag));
            this.m_htAttribToMapperInfo.put("ref_tape_location_id", new MapperInfo(TapeCartridge.getColumnInfo("LOCATION_ID")));
        }
    }

    private class SMISIOPortLocationToDBMapper
    extends DBAttributeMapper {
        public SMISIOPortLocationToDBMapper() {
            ColumnInfo mDevID = TapeIoport.getColumnInfo("DEVICE_ID");
            mDevID.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put("ref_device_id", new MapperInfo(mDevID));
            ColumnInfo mTapeLibID = TapeIoport.getColumnInfo("TAPE_LIBRARY_ID");
            mTapeLibID.setIsPrimaryKey();
            this.m_htAttribToMapperInfo.put(SMISCIM_StorageMediaLocationToDBMapper.sLIBRARYID, new MapperInfo(mTapeLibID));
            this.m_htAttribToMapperInfo.put("ref_tape_location_id", new MapperInfo(TapeIoport.getColumnInfo("LOCATION_ID")));
        }
    }
}

