/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISCapabilityDataToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "CapabilityData";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISCapabilityDataToDBMapper() {
        Vector<String> columns = new Vector<String>();
        columns.add("ACCESS_ASSIGNMENT");
        columns.add("ACCESS_POINT");
        columns.add("ACCESS_UNASSIGNMENT");
        columns.add("ATTACH_DEVICE");
        columns.add("CONTROLLER_REQ_IDENTITY");
        columns.add("CONTROLLER_SUPP_COLL");
        columns.add("DISK_DATA");
        columns.add("EXPOSE_PATH");
        columns.add("EXTENT_DATA");
        columns.add("NUM_VOLUMES");
        columns.add("ONE_HW_ID_PER_VIEW");
        columns.add("PORTS_PER_VIEW");
        columns.add("RAID_LEVELS");
        columns.add("SMIS_PROFILE");
        columns.add("SMIS_SUB_PROFILES");
        columns.add("SMIS_VERSION");
        columns.add("SPC_ALLOWS_DEFAULT_VIEWS");
        columns.add("SPC_ALLOWS_NO_INITIATORS");
        columns.add("SPC_ALLOWS_NO_LUS");
        columns.add("SPC_ALLOWS_NO_TGTS");
        columns.add("TARGET_PORT_RESTRICTION");
        columns.add("UNIQUE_NUM_PER_PORT");
        columns.add("VOLUME_CREATION");
        columns.add("VOLUME_DELETION");
        columns.add("VOLUME_EXPANSION");
        columns.add("VOLUME_SHRINKING");
        columns.add("CLNT_SELCTBL_DEVNO");
        ColumnInfo capId = CapabilityData.getColumnInfo("CAPABILITY_DATA_ID");
        capId.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("CAPABILITY_DATA_ID".toLowerCase(), new MapperInfo(capId));
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo aInfo = CapabilityData.getColumnInfo((String)columns.elementAt(i));
            if (aInfo.getDataType() == 5) {
                this.m_dataConverter.addSimpleDataConversion(((String)columns.elementAt(i)).toLowerCase(), "Boolean");
            }
            MapperInfo a = new MapperInfo(aInfo);
            this.m_htAttribToMapperInfo.put(((String)columns.elementAt(i)).toLowerCase(), a);
        }
        ColumnInfo subIDColumn = CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID");
        subIDColumn.setIsPrimaryKey();
        MapperInfo subIDMapperInfo = new MapperInfo(subIDColumn);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", subIDMapperInfo);
        ColumnInfo nsIDColumn = CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID");
        nsIDColumn.setIsPrimaryKey();
        MapperInfo nsIDMapperInfo = new MapperInfo(nsIDColumn);
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_cimom2namespaceid", nsIDMapperInfo);
        this.m_htAttribToMapperInfo.put("CAPABILITY_DATA_ID2".toLowerCase(), new MapperInfo(CimkeySubsystem.getColumnInfo("CAPABILITY_DATA_ID")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mSubSystemId = (String)pParams.get("ref_toplevelsystem_id");
        String mCimom2NamespaceId = (String)pParams.get("ref_toplevelsystem_cimom2namespaceid");
        if (mSubSystemId == null || mCimom2NamespaceId == null) throw new SQLException("Missing SubsystemID or Cimom2NamespaceId");
        CimkeySubsystem mSubsystem = new CimkeySubsystem();
        mSubsystem.setSubsystemId(Integer.parseInt(mSubSystemId));
        mSubsystem.setCimNamespaceId(Integer.parseInt(mCimom2NamespaceId));
        if (!mSubsystem.retrieve(pConn)) throw new SQLException("No CimKeySubsystem entry found");
        int mCapId = mSubsystem.getCapabilityDataId();
        if (mCapId == Integer.MIN_VALUE || mCapId == 0) {
            mCapId = AutoIdentifier.getIdentifier(1, 1);
            pParams.put("CAPABILITY_DATA_ID2".toLowerCase(), String.valueOf(mCapId));
        } else {
            pParams.remove("ref_toplevelsystem_cimom2namespaceid");
            pParams.remove("ref_toplevelsystem_id");
        }
        pParams.put("CAPABILITY_DATA_ID".toLowerCase(), String.valueOf(mCapId));
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

