/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.sql.SqlDataPath;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SMISDataPathToDBMapper
extends DBAttributeMapper {
    private static final String sqlUpdateBeginning = "update T_RES_DATA_PATH set ";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "DataPath";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public SMISDataPathToDBMapper() {
        Vector<String> columns = new Vector<String>();
        columns.add("DEVICE_LUN_ID");
        columns.add("HOST_LUN_ID");
        columns.add("UNKNOWN_HOST_NAME");
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo aInfo = DataPath.getColumnInfo((String)columns.elementAt(i));
            MapperInfo a = new MapperInfo(aInfo);
            this.m_htAttribToMapperInfo.put(((String)columns.elementAt(i)).toLowerCase(), a);
        }
        ColumnInfo autoIDInfo = DataPath.getColumnInfo("DATA_PATH_ID");
        autoIDInfo.setAutoGenerated();
        Vector<String> columnsPK = new Vector<String>();
        columnsPK.add("INITIATOR_PORT_ID");
        columnsPK.add("TARGET_PORT_ID");
        columnsPK.add("VOLUME_ID");
        for (int i = 0; i < columnsPK.size(); ++i) {
            ColumnInfo aInfo = DataPath.getColumnInfo((String)columnsPK.elementAt(i));
            aInfo.setIsPrimaryKey();
            MapperInfo a = new MapperInfo(aInfo);
            a.setDerivedColumn(autoIDInfo);
            this.m_htAttribToMapperInfo.put(((String)columnsPK.elementAt(i)).toLowerCase(), a);
        }
        this.m_htAttribToMapperInfo.put("ref_masking_info_id", new MapperInfo(DataPath.getColumnInfo("MASKING_INFO_ID")));
        this.m_htAttribToMapperInfo.put("ref_toplevelsystem_id", new MapperInfo(DataPath.getColumnInfo("SUBSYSTEM_ID")));
        ColumnInfo volInfo = DataPath.getColumnInfo("VOLUME_ID");
        volInfo.setIsPrimaryKey();
        this.m_htAttribToMapperInfo.put("ref_storagevolume_id", new MapperInfo(volInfo));
    }

    private Hashtable generateMappings(DBConnection conn, Hashtable htValues) {
        Hashtable mappings = this.generateValuesHashtable(htValues);
        try {
            mappings.put(DataPath.getColumnInfo("UPDATE_TIMESTAMP"), CurrentTime.getTimestamp(conn));
        }
        catch (Exception e) {
            // empty catch block
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int attemptInsert(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
        String sql = SqlDataPath.getQueryString(SqlDataPath.mapperInsert);
        int autoId = AutoIdentifier.getIdentifier(1, 1);
        valueMappings.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(autoId));
        PreparedStatement dbPS = null;
        int value = -1;
        try {
            dbPS = conn.getConnection().prepareStatement(sql);
            int paramCounter = 1;
            dbPS.setInt(paramCounter++, autoId);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("HOST_LUN_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("DEVICE_LUN_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("INITIATOR_PORT_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("TARGET_PORT_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("UNKNOWN_HOST_NAME"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("UPDATE_TIMESTAMP"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("MASKING_INFO_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("SUBSYSTEM_ID"), paramCounter++, valueMappings);
            value = dbPS.executeUpdate();
            conn.commit();
            try {
                Hashtable<ColumnInfo, String> autoIDHash = new Hashtable<ColumnInfo, String>();
                autoIDHash.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(autoId));
                DetectabilityService.tableUpdated(scanID, DataPath.getTablename(), autoIDHash);
            }
            catch (Exception e) {
                this.logException(this.myClassname, "attemptInsert", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
            }
        }
        finally {
            if (dbPS != null) {
                try {
                    dbPS.close();
                }
                catch (Exception ignore) {}
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int attemptUpdate(DBConnection conn, Hashtable valueMappings) throws SQLException {
        StringBuffer sql = new StringBuffer(sqlUpdateBeginning);
        Vector<ColumnInfo> orderedColumns = new Vector<ColumnInfo>();
        for (ColumnInfo col : valueMappings.keySet()) {
            sql.append(col.getName() + " = ?,");
            orderedColumns.add(col);
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where INITIATOR_PORT_ID = ? and TARGET_PORT_ID = ? and VOLUME_ID = ?");
        PreparedStatement dbPS = null;
        int value = -1;
        try {
            dbPS = conn.getConnection().prepareStatement(sql.toString());
            int paramCounter = 1;
            for (int i = 0; i < orderedColumns.size(); ++i) {
                SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, (ColumnInfo)orderedColumns.get(i), paramCounter++, valueMappings);
            }
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("INITIATOR_PORT_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("TARGET_PORT_ID"), paramCounter++, valueMappings);
            SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
            value = dbPS.executeUpdate();
        }
        finally {
            if (dbPS != null) {
                try {
                    dbPS.close();
                }
                catch (Exception ignore) {}
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAutoId(DBConnection conn, Hashtable valueMappings, String scanID) throws SQLException {
        int autoID;
        block16: {
            PreparedStatement dbPS = null;
            ResultSet rs = null;
            autoID = -1;
            try {
                dbPS = conn.getConnection().prepareStatement(SqlDataPath.getQueryString(SqlDataPath.mapperRetrieveAutoId));
                int paramCounter = 1;
                SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("INITIATOR_PORT_ID"), paramCounter++, valueMappings);
                SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("TARGET_PORT_ID"), paramCounter++, valueMappings);
                SMISDataPathToDBMapper.setPreparedStatementParameter(dbPS, DataPath.getColumnInfo("VOLUME_ID"), paramCounter++, valueMappings);
                rs = dbPS.executeQuery();
                if (rs.next()) {
                    autoID = rs.getInt(1);
                    valueMappings.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(autoID));
                    conn.commit();
                    try {
                        Hashtable<ColumnInfo, String> autoIDHash = new Hashtable<ColumnInfo, String>();
                        autoIDHash.put(DataPath.getColumnInfo("DATA_PATH_ID"), String.valueOf(autoID));
                        DetectabilityService.tableUpdated(scanID, DataPath.getTablename(), autoIDHash);
                    }
                    catch (Exception e) {
                        this.logException(this.myClassname, "getAutoId", e, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
                    }
                    break block16;
                }
                throw new SQLException("No row was found matching INITIATOR_PORT_ID = " + valueMappings.get("INITIATOR_PORT_ID") + "and TARGET_PORT_ID = " + valueMappings.get("TARGET_PORT_ID") + "and VOLUME_ID = " + valueMappings.get("VOLUME_ID"));
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ignore) {}
                }
                if (dbPS != null) {
                    try {
                        dbPS.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        return autoID;
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        Object[] params = new Object[]{conn, htValues, scanID};
        this.logEntry(this.myClassname, methodName, params);
        Hashtable valueMappings = this.generateMappings(conn, htValues);
        if (valueMappings == null) {
            throw new SQLException("None of the discovered data provided to the mapper mapped to a database column, so nothing was done.");
        }
        MapperResult mr = new MapperResult();
        try {
            this.attemptInsert(conn, valueMappings, scanID);
            mr.addInsertedRow("T_RES_DATA_PATH", valueMappings);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                valueMappings.remove(DataPath.getColumnInfo("DATA_PATH_ID"));
                this.attemptUpdate(conn, valueMappings);
                this.getAutoId(conn, valueMappings, scanID);
                mr.addUpdatedRow("T_RES_DATA_PATH", valueMappings);
            }
            System.out.println("Got an exception in insert! ");
            e.printStackTrace();
        }
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

