/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_PhysicalPackageToDBMapper;

public class SMISIBMTSESS_PhysicalPackageToDBMapper
extends SMISCIM_PhysicalPackageToDBMapper {
    public static final String sDAPAIR = "dapair";
    public static final String sLOCATION = "location";
    public static final String sDISKGROUPNUMBER = "diskgroupnumber";
    public static final String sRANKID = "rankid";
    public static final String sLOOP = "loop";
    public static final String sTag = "tag";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSESS_PhysicalPackage";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSESS_PhysicalPackageToDBMapper() {
        this.m_htAttribToMapperInfo.put("otheridentifyinginfo", new MapperInfo(DiskGroup.getColumnInfo("RAID_LEVEL")));
        this.m_htAttribToMapperInfo.put("name_array", new MapperInfo(DiskGroup.getColumnInfo("ARRAY")));
        this.m_htAttribToMapperInfo.put("ddmcap", new MapperInfo(DiskGroup.getColumnInfo("DDM_CAP")));
        this.m_htAttribToMapperInfo.put("ddmspeed", new MapperInfo(DiskGroup.getColumnInfo("DDM_SPEED")));
        this.m_htAttribToMapperInfo.put(sDAPAIR, new MapperInfo(DiskGroup.getColumnInfo("DA_PAIR_ID")));
        this.m_htAttribToMapperInfo.put(sDISKGROUPNUMBER, new MapperInfo(DiskGroup.getColumnInfo("DISK_GROUP_NUMBER")));
        this.m_htAttribToMapperInfo.put("ref_storageextent_id", new MapperInfo(DiskGroup.getColumnInfo("STORAGE_EXTENT_ID")));
        this.m_htAttribToMapperInfo.put("ref_numofdatadisks", new MapperInfo(DiskGroup.getColumnInfo("WIDTH")));
        this.m_htAttribToMapperInfo.put("numofdatadisks", new MapperInfo(DiskGroup.getColumnInfo("WIDTH")));
        this.m_htAttribToMapperInfo.put("DEVICE_ADAPTER1".toLowerCase(), new MapperInfo(DiskGroup.getColumnInfo("DEVICE_ADAPTER1")));
        this.m_htAttribToMapperInfo.put("DEVICE_ADAPTER2".toLowerCase(), new MapperInfo(DiskGroup.getColumnInfo("DEVICE_ADAPTER2")));
        this.m_htAttribToMapperInfo.put(sLOOP, new MapperInfo(DiskGroup.getColumnInfo("LOOP")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String name;
        Vector mDeviceAdaptersVec;
        String mDeviceAdapters;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mLocation = (String)pParams.get(sLOCATION);
        if (mLocation != null) {
            try {
                String bDAPair = mLocation.substring(mLocation.indexOf("Adapter Pair") + 13, mLocation.indexOf(",")).trim();
                String bLoopToEnd = mLocation.substring(mLocation.indexOf("(loop)") + 6).trim();
                String bLoop = bLoopToEnd.substring(0, bLoopToEnd.indexOf(",")).trim();
                if (bDAPair != null && bDAPair.length() > 0) {
                    pParams.put(sDAPAIR, bDAPair);
                }
                if (bLoop != null && bLoop.length() > 0) {
                    pParams.put(sLOOP, bLoop);
                }
            }
            catch (Exception e) {
                this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not extract disk group name or dapair from location");
            }
        }
        String mDiskGroupNumber = (String)pParams.get(sDISKGROUPNUMBER);
        String mSystemName = (String)pParams.get("ref_toplevelsystem_name");
        if (mDiskGroupNumber == null && mSystemName != null) {
            String bDiskGroupNumber;
            String bTag;
            if (mSystemName.startsWith("2107") || mSystemName.startsWith("1750")) {
                bTag = (String)pParams.get(sTag);
                if (bTag != null) {
                    bDiskGroupNumber = bTag.substring(bTag.indexOf("-") + 1, bTag.length());
                    pParams.put(sDISKGROUPNUMBER, bDiskGroupNumber);
                } else {
                    this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not set DISKGROUPNUMBER - tag is empty!");
                }
            } else if (mSystemName.startsWith("2105")) {
                bTag = (String)pParams.get(sTag);
                if (bTag != null) {
                    bDiskGroupNumber = bTag.substring(bTag.indexOf("dg") + 2, bTag.length());
                    pParams.put(sDISKGROUPNUMBER, bDiskGroupNumber);
                } else {
                    this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not set DISKGROUPNUMBER - tag is empty!");
                }
            } else {
                this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not set DISKGROUPNUMBER - unknown ESS/DS Model");
            }
        }
        if ((mDeviceAdapters = (String)pParams.get("deviceadapters")) != null && (mDeviceAdaptersVec = SMISIBMTSESS_PhysicalPackageToDBMapper.processArrayvalues(mDeviceAdapters)) != null && mDeviceAdaptersVec.size() > 0) {
            String mDA2;
            String mDA1 = (String)mDeviceAdaptersVec.elementAt(0);
            if (mDA1 != null && mDA1.length() > 0) {
                pParams.put("DEVICE_ADAPTER1".toLowerCase(), mDA1);
            }
            if (mDeviceAdaptersVec.size() > 1 && (mDA2 = (String)mDeviceAdaptersVec.elementAt(1)) != null && mDA2.length() > 0) {
                pParams.put("DEVICE_ADAPTER2".toLowerCase(), mDA2);
            }
        }
        if ((name = (String)pParams.get("name")) != null) {
            pParams.put("name_array", name);
        }
        String mRankID = (String)pParams.get(sRANKID);
        String mExtentID = (String)pParams.get("ref_storageextent_id");
        String mSubsystemID = (String)pParams.get("ref_toplevelsystem_id");
        if (mRankID != null && mRankID.startsWith("rank") && mExtentID != null && mSubsystemID != null) {
            Hashtable<ColumnInfo, String> mWhereExtentID = new Hashtable<ColumnInfo, String>();
            Vector<String> bColumns = new Vector<String>();
            bColumns.add("DEVICE_ID");
            mWhereExtentID.put(TResStorageExtentTable.getColumnInfo("STORAGE_EXTENT_ID"), mExtentID);
            DBResultSet resultSet = DBQueryAssistant.performRetrieve(TResStorageExtentTable.getTablename(), pConn, mWhereExtentID, bColumns);
            if (resultSet.next()) {
                StorageExtent mExtent = new StorageExtent();
                mExtent.setDeviceId(resultSet.getString("DEVICE_ID"));
                mExtent.setSubsystemId(Integer.parseInt(mSubsystemID));
                mExtent.setRankId(mRankID);
                mExtent.update(pConn);
                resultSet.closeAll();
            }
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }

    public static void main(String[] args) {
        String mLocation = "Adapter Pair 1, Port (loop) X, and Disk Group 2";
        String bLoopToEnd = mLocation.substring(mLocation.indexOf("(loop)") + 6, mLocation.length()).trim();
        String bLoop = bLoopToEnd.substring(0, bLoopToEnd.indexOf(",")).trim();
        System.out.println(bLoop);
        String bTag = "2105.3434545-dg76";
        String bDiskGroupNumber = bTag.substring(bTag.indexOf("dg") + 2, bTag.length());
        System.out.println(bDiskGroupNumber);
    }
}

