/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_StoragePoolToDBMapper;

public class SMISIBMTSESS_VolumeSpaceToDBMapper
extends SMISCIM_StoragePoolToDBMapper {
    private static final String sLSS = "lss";
    private static final String sELEMENTNAME = "elementname";
    private static final String sINSTANCEID = "instanceid";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSESS_VolumeSpace";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    public SMISIBMTSESS_VolumeSpaceToDBMapper() {
        this.m_htAttribToMapperInfo.put("numofvols", new MapperInfo(StoragePool.getColumnInfo("NUMBER_OF_STORAGE_VOLUMES")));
        this.m_htAttribToMapperInfo.put("numranks", new MapperInfo(StoragePool.getColumnInfo("NUMBER_OF_BACKEND_VOLUMES")));
        this.m_htAttribToMapperInfo.put("redundancy", new MapperInfo(StoragePool.getColumnInfo("RAID_LEVEL")));
        this.m_htAttribToMapperInfo.put(sLSS, new MapperInfo(StoragePool.getColumnInfo("LSS")));
        this.m_dataConverter.addSimpleDataConversion("format", "ESS_Format");
        this.m_htAttribToMapperInfo.put("format", new MapperInfo(StoragePool.getColumnInfo("FORMAT")));
    }

    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        String rV;
        String mLSS;
        String mLogicalFree;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        String mInstanceID = (String)pParams.get(sINSTANCEID);
        if (mInstanceID != null && mInstanceID.startsWith("2105")) {
            pParams.put(sELEMENTNAME, mInstanceID);
        } else if (pParams.get(sELEMENTNAME) == null) {
            pParams.put(sELEMENTNAME, mInstanceID);
        }
        String mLogicalCap = (String)pParams.get("logicalcap");
        if (mLogicalCap != null) {
            pParams.put("totalmanagedspace_capacity", mLogicalCap);
        }
        if ((mLogicalFree = (String)pParams.get("logicalfree")) != null) {
            pParams.put("remainingmanagedspace_availablespace", mLogicalFree);
        }
        if ((mLSS = (String)pParams.get(sLSS)) != null) {
            try {
                pParams.put(sLSS, Integer.parseInt(mLSS.trim(), 16) + "");
            }
            catch (Exception e) {
                this.logWarning(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Could not convert lss hex to dec");
            }
        }
        if ((rV = (String)pParams.get("redundancy")) != null) {
            Vector raid = SMISIBMTSESS_VolumeSpaceToDBMapper.processArrayvalues(rV);
            String rS = "";
            for (int i = 0; i < raid.size(); ++i) {
                rS = rS + raid.elementAt(i) + " ";
            }
            pParams.put("redundancy", rS);
        }
        MapperResult mReturnResult = super.persist(pConn, pParams, pScanID);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
        return mReturnResult;
    }
}

