/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISIBMTSSVC_StorageVolumeToDBMapper;

public class SMISIBMTSSVC_StorageVolumeBackendVolumeViewToDBMapper
extends SMISIBMTSSVC_StorageVolumeToDBMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "IBMTSSVC_StorageVolumeBackendVolumeView";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapperResult persist(DBConnection pConn, Hashtable pParams, String pScanID) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{pConn, pParams, pScanID});
        MapperResult mReturnResult = null;
        try {
            String mCount;
            String mSubsystemID = (String)pParams.get("ref_toplevelsystem_id");
            if (pParams.get("ref_storageextent_id") == null) {
                String mDeviceID = (String)pParams.get("backendvolumeid");
                StorageExtent mExtent = new StorageExtent();
                mExtent.setSubsystemId(Integer.parseInt(mSubsystemID));
                mExtent.setDeviceId(mDeviceID);
                if (mExtent.retrieve(pConn)) {
                    String mExtentID = String.valueOf(mExtent.getStorageExtentId());
                    pParams.put("ref_storageextent_id", mExtentID);
                } else {
                    MapperResult mExtentID = new MapperResult();
                    return mExtentID;
                }
            }
            boolean bVolumeExists = false;
            String mDeviceID = (String)pParams.get("storagevolumeid");
            if (mDeviceID != null) {
                pParams.put("deviceid", mDeviceID);
            }
            if ((mCount = (String)pParams.get("count")) != null) {
                pParams.put("extentcount", mCount);
            }
            this.updateNameAndNameFormat(pConn, pParams);
            boolean bl = bVolumeExists = (String)pParams.get("name") != null && (String)pParams.get("nameformat") != null;
            if (bVolumeExists) {
                mReturnResult = super.persist(pConn, pParams, pScanID);
            }
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            MapperResult mapperResult = mReturnResult;
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            if (mReturnResult == null) {
                return new MapperResult();
            }
            return mReturnResult;
        }
        catch (Exception e) {
            this.logException(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "Persisting the storage volume failed.");
        }
        finally {
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mReturnResult);
            if (mReturnResult == null) {
                return new MapperResult();
            }
            return mReturnResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNameAndNameFormat(DBConnection conn, Hashtable htValues) throws SQLException {
        this.logEntry(this.myClassname, "updateNameAndNameFormat(DBConnection conn, Hashtable htValues)", new Object[]{conn, htValues});
        Object subsystemID = htValues.get("ref_toplevelsystem_id");
        if (subsystemID != null) {
            Statement ps = null;
            ResultSet rs = null;
            try {
                String sql = SqlStorageVolume.getQueryString(1);
                String sysNameID = (String)htValues.get("ref_system_names_id");
                if (sysNameID != null) {
                    sql = sql + " and SYSTEM_NAMES_ID = ?";
                }
                ps = conn.getConnection().prepareStatement(sql);
                SMISIBMTSSVC_StorageVolumeBackendVolumeViewToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, CimkeyVolume.getColumnInfo("DEVICE_ID"), 1, htValues.get("deviceid"));
                SMISIBMTSSVC_StorageVolumeBackendVolumeViewToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, StorageVolume.getColumnInfo("SUBSYSTEM_ID"), 2, subsystemID);
                if (sysNameID != null) {
                    SMISIBMTSSVC_StorageVolumeBackendVolumeViewToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), 3, sysNameID);
                }
                if ((rs = ps.executeQuery()).next()) {
                    htValues.put("name", rs.getString("NAME"));
                    htValues.put("nameformat", rs.getString("NAME_FORMAT"));
                } else {
                    this.logInfo(this.myClassname, "updateNameAndNameFormat(DBConnection conn, Hashtable htValues)", "Unable to find a name & nameformat value using query: " + sql);
                }
            }
            finally {
                if (ps != null) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignore) {}
                    }
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
    }
}

