/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlPhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_PhysicalMediaToDBMapper;

public class SMISLSISSI_PhysicalMediaToDBMapper
extends SMISCIM_PhysicalMediaToDBMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "LSISSI_PhysicalMedia";
        String mSMIS = "1.0.2";
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.0.3";
        DBAttributeMapper.RegistrationData mR2 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        mSMIS = "1.1.0";
        DBAttributeMapper.RegistrationData mR3 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1, mR2, mR3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        this.logEntry(this.myClassname, "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{conn, htValues, scanID});
        MapperResult mr = null;
        String migrated = (String)htValues.get("ref_subsystem_migrated");
        if (migrated != null && migrated.equals("1")) {
            String serialNum = (String)htValues.get("serialnumber");
            if (serialNum != null) {
                Statement ps = null;
                ResultSet rs = null;
                try {
                    int autoID = Integer.MIN_VALUE;
                    String sql = SqlPhysicalVolume.getQueryString(0);
                    ps = conn.getConnection().prepareStatement(sql);
                    ps.setString(1, serialNum.trim());
                    ps.setString(2, serialNum.trim());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        autoID = rs.getInt(1);
                    }
                    try {
                        rs.close();
                        ps.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                    if (autoID != Integer.MIN_VALUE) {
                        sql = SqlPhysicalVolume.getQueryString(1);
                        ps = conn.getConnection().prepareStatement(sql);
                        SMISLSISSI_PhysicalMediaToDBMapper.setPreparedStatementParameter((PreparedStatement)ps, PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), 1, new Integer(autoID));
                        ps.executeUpdate();
                        ColumnInfo deviceID = PhysicalVolume.getColumnInfo("DEVICE_ID");
                        deviceID.setIsPrimaryKey();
                        this.m_htAttribToMapperInfo.put("ref_physicalvolume_device_id", new MapperInfo(deviceID));
                        ColumnInfo autoIDCol = PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID");
                        autoIDCol.unsetAutoGenerated();
                        this.m_htAttribToMapperInfo.put("auto_id", new MapperInfo(autoIDCol));
                        htValues.put("auto_id", Integer.toString(autoID));
                    }
                }
                catch (SQLException e) {
                    this.logException(this.myClassname, "persist(DBConnection pConn, Hashtable pParams, String pScanID)", e, "serial_number =" + serialNum);
                }
                finally {
                    if (ps != null) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ignore) {}
                        }
                        try {
                            ps.close();
                        }
                        catch (SQLException ignore) {}
                    }
                }
                mr = super.persist(conn, htValues, scanID);
                ColumnInfo phname = PhysicalVolume.getColumnInfo("DEVICE_ID");
                phname.setIsPrimaryKey();
                MapperInfo phnameMapperInfo = new MapperInfo(phname);
                ColumnInfo phIdInfo = PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID");
                phIdInfo.setAutoGenerated();
                phnameMapperInfo.setDerivedColumn(phIdInfo);
                this.m_htAttribToMapperInfo.put("ref_physicalvolume_device_id", phnameMapperInfo);
            } else {
                this.logWarning(this.myClassname, "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "Physical Volume with SystemNamesID of " + htValues.get("ref_physicalvolume_system_names_id") + " and DeviceID of " + htValues.get("ref_physicalvolume_device_id") + " had no serial number value, so correlation with migrated data could not be done.");
            }
            htValues.remove("ref_subsystem_migrated");
        } else {
            mr = super.persist(conn, htValues, scanID);
        }
        this.logExit(this.myClassname, "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mr);
        return mr;
    }
}

