/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class ZoneMemberXmlToDBMapper
extends DBAttributeMapper {
    private static final String VENDORTYPE = "VendorType";
    private static final String SANWWN = "SANWWN";
    private static final String NAME = "Name";
    private static final String TYPE = "Type";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "ZoneMemberXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public ZoneMemberXmlToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion(VENDORTYPE.toLowerCase(), "Zone_Member_Vendor_Type");
        this.m_dataConverter.addComplexDataConversion(SANWWN.toLowerCase(), ":", 2);
        this.m_dataConverter.addComplexDataConversion(NAME.toLowerCase(), ":", 3);
        ColumnInfo memberWWN = ZoneMember.getColumnInfo("MEMBER_NAME");
        memberWWN.setIsPrimaryKey();
        MapperInfo memberWWNMapperInfo = new MapperInfo(memberWWN);
        ColumnInfo memberIdInfo = ZoneMember.getColumnInfo("ZONE_MEMBER_ID");
        memberIdInfo.setAutoGenerated();
        memberWWNMapperInfo.setDerivedColumn(memberIdInfo);
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), memberWWNMapperInfo);
        this.m_htAttribToMapperInfo.put(VENDORTYPE.toLowerCase(), new MapperInfo(ZoneMember.getColumnInfo("VENDOR_TYPE")));
        this.m_htAttribToMapperInfo.put(TYPE.toLowerCase(), new MapperInfo(ZoneMember.getColumnInfo("TYPE")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        if (conn == null || htValues == null) {
            throw new SQLException("ZoneMemberXml requires non-null values for the DBConnection and Hashtable parameters.");
        }
        MapperResult mr = null;
        String uniqueXML = (String)htValues.get("UniqueIdXml");
        if (uniqueXML != null) {
            htValues.put(SANWWN, uniqueXML);
            htValues.put(NAME, uniqueXML);
            this.m_dataConverter.removeSimpleAndComplexDataConversion(TYPE);
            if (htValues.get("ToUniqueIdXml") != null && htValues.get("FromUniqueIdXml") != null) {
                htValues.put(TYPE, uniqueXML);
                this.m_dataConverter.addComplexDataConversion(TYPE, ":", 4);
            } else {
                this.m_dataConverter.addSimpleDataConversion(TYPE, "Zone_Member_Type");
            }
        } else {
            throw new SQLException("ZoneMemberXml mapper requires the UniqueIdXml attribute as part of the discovered values in provided hashtable.");
        }
        mr = super.persist(conn, htValues, scanID);
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

