/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class ZoneSetXmlToDBMapper
extends DBAttributeMapper {
    private static final String SANWWN = "SanWWN";
    private static final String NAME = "Name";
    private static final String ACTIVE = "Active";
    private static final String ACTIVEUNI = "ActiveUNI";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String mCIMClass = "ZoneSetXml";
        String mSMIS = null;
        String mDeviceType = null;
        String mAgentVersion = null;
        DBAttributeMapper.RegistrationData mR1 = new DBAttributeMapper.RegistrationData(mCIMClass, mSMIS, mDeviceType, mAgentVersion);
        return new DBAttributeMapper.RegistrationData[]{mR1};
    }

    public ZoneSetXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion(SANWWN.toLowerCase(), ":", 2);
        this.m_dataConverter.addComplexDataConversion(NAME.toLowerCase(), ":", 3);
        this.m_dataConverter.addComplexDataConversion(ACTIVEUNI.toLowerCase(), ":", 4);
        this.m_dataConverter.addSimpleDataConversion(ACTIVE.toLowerCase(), "Boolean");
        ColumnInfo zsetname = Zset.getColumnInfo("ZSET_NAME");
        zsetname.setIsPrimaryKey();
        MapperInfo zsetnameMapperInfo = new MapperInfo(zsetname);
        ColumnInfo zsetIdInfo = Zset.getColumnInfo("ZSET_ID");
        zsetIdInfo.setAutoGenerated();
        zsetnameMapperInfo.setDerivedColumn(zsetIdInfo);
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), zsetnameMapperInfo);
        this.m_htAttribToMapperInfo.put(SANWWN.toLowerCase(), new MapperInfo(Zset.getColumnInfo("FABRIC_WWN")));
        this.m_htAttribToMapperInfo.put(ACTIVE.toLowerCase(), new MapperInfo(Zset.getColumnInfo("ACTIVE")));
        this.m_htAttribToMapperInfo.put(ACTIVEUNI.toLowerCase(), new MapperInfo(Zset.getColumnInfo("ACTIVE")));
    }

    public MapperResult persist(DBConnection conn, Hashtable htValues, String scanID) throws SQLException {
        String methodName = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, methodName, new Object[]{conn, htValues, scanID});
        MapperResult mr = null;
        String uniqueXML = (String)htValues.get("UniqueIdXml");
        if (uniqueXML != null) {
            htValues.put(SANWWN.toLowerCase(), uniqueXML);
            htValues.put(NAME.toLowerCase(), uniqueXML);
            if (htValues.get("ToUniqueIdXml") != null && htValues.get("FromUniqueIdXml") != null) {
                htValues.put(ACTIVEUNI.toLowerCase(), uniqueXML);
            }
            mr = super.persist(conn, htValues, scanID);
        }
        this.logExit(this.myClassname, methodName, mr);
        return mr;
    }
}

