/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.interfaces;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.interfaces.ParameterException;

public class DiscoverRequest
implements Serializable,
Cloneable {
    public static final String CIMOM = "CIMOM";
    public static final String IPADDRESS = "IPADDRESS";
    public static final String AGENT = "AGENT";
    public static final String SCANNER = "SCANNER";
    public static final String USERID = "USERID";
    public static final String PASSWORD = "PASSWORD";
    public static final String DEVICEID = "DEVICEID";
    public static final String CAPABILITY_DATA = "CAPABILITY";
    public static final String TOP_LEVEL_COMPUTERSYSTEM = "TL_CS";
    public static final String VENDOR = "VENDOR";
    public static final String MODEL = "MODEL";
    public static final String CIMOM_SOFTWARE_LEVEL = "CIMOMSWLVL";
    private String cCommand = null;
    private String cDescription;
    private HashMap cParameterTypes;
    private HashMap cParameterValues;

    private DiscoverRequest() {
        this.cParameterValues = new HashMap();
    }

    public DiscoverRequest(String pDescription, String[] pParameters, String[] pParameterTypes) throws IllegalArgumentException {
        this.cDescription = pDescription;
        this.cParameterTypes = new HashMap();
        if (pParameters.length != pParameterTypes.length) {
            throw new IllegalArgumentException("Number of parameters and corresponding types differ.");
        }
        for (int i = 0; i < pParameters.length; ++i) {
            this.cParameterTypes.put(pParameters[i], pParameterTypes[i]);
        }
        this.cParameterValues = new HashMap();
    }

    public void setCommand(String pCommand) {
        this.cCommand = pCommand;
    }

    public String getCommand() {
        return this.cCommand;
    }

    public void setParameters(Map pParameters) throws ParameterException {
        if (this.cParameterTypes.size() != pParameters.size()) {
            throw new ParameterException("Not all parameters are specified.");
        }
        this.cParameterValues.clear();
        for (Map.Entry mEntry : pParameters.entrySet()) {
            String bParameter = (String)mEntry.getKey();
            Object bValue = mEntry.getValue();
            if (!this.cParameterTypes.containsKey(bParameter)) {
                throw new ParameterException("Invalid parameter (" + bParameter + ")");
            }
            String bParameterType = this.getParameterType(bParameter);
            try {
                if (bValue == null || !Class.forName(bParameterType).isInstance(bValue)) {
                    throw new ParameterException("Parameter " + bParameter + "(" + (bValue == null ? "null" : bValue.getClass().getName()) + ") is not of type " + this.cParameterTypes.get(bParameter));
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ParameterException("Class named " + bParameterType + " is not defined");
            }
            this.cParameterValues.put(bParameter, bValue);
        }
    }

    public Map getParameters() {
        return this.cParameterValues;
    }

    public Object getParameter(String pParameter) {
        return this.cParameterValues.get(pParameter);
    }

    public String getParameterType(String pParameter) {
        return (String)this.cParameterTypes.get(pParameter);
    }

    public static Object getParameter(Map pParameters, String pParameter, String pClass) throws ParameterException {
        Object mObj = pParameters.get(pParameter);
        if (mObj == null) {
            throw new ParameterException("Parameter " + pParameter + " is missing.");
        }
        try {
            if (!Class.forName(pClass).isInstance(mObj)) {
                throw new ParameterException("Parameter " + pParameter + "(" + mObj.getClass().getName() + ") is not of type " + pClass);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParameterException("Class named " + pClass + " is not defined");
        }
        return mObj;
    }

    public String toString() {
        StringBuffer mBuffer = new StringBuffer();
        mBuffer.append("DiscoverRequest: " + this.cDescription + "\n");
        Set mEntrySet = this.cParameterTypes.entrySet();
        for (Map.Entry bEntry : mEntrySet) {
            mBuffer.append("     " + bEntry.getKey() + (this.cParameterValues.get(bEntry.getKey()) != null ? "=" + this.cParameterValues.get(bEntry.getKey()).toString() : "") + ", type is " + bEntry.getValue() + "\n");
        }
        return mBuffer.toString();
    }

    public String getDescription() {
        return this.cDescription;
    }

    public Object clone() throws CloneNotSupportedException {
        DiscoverRequest mReturn = new DiscoverRequest();
        mReturn.cCommand = this.cCommand;
        mReturn.cDescription = this.cDescription;
        mReturn.cParameterTypes = (HashMap)this.cParameterTypes.clone();
        return mReturn;
    }
}

