/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.logging;

import com.ibm.log.LogComponent;
import com.ibm.log.mgr.LogManager;
import java.util.Vector;

class JLogObjectPool {
    private Vector<LogComponent> pool;
    private LogManager logManager = null;
    private int uniqueKey = 0;
    private String baseName = null;

    JLogObjectPool(LogManager lm, String baseName) {
        this.logManager = lm;
        this.baseName = baseName;
        this.createPool();
    }

    private void createPool() {
        this.pool = new Vector();
    }

    synchronized LogComponent getLogComponent() {
        LogComponent component = null;
        int size = this.pool.size();
        component = size > 0 ? this.pool.remove(size - 1) : this.getUniqueLogComponent();
        return component;
    }

    synchronized void returnLogComponent(LogComponent logComponent) {
        this.pool.add(logComponent);
    }

    private LogComponent getUniqueLogComponent() {
        int key;
        if ((key = this.uniqueKey++) == Integer.MAX_VALUE) {
            throw new RuntimeException("Last unique key generated");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.baseName);
        sb.append(".");
        sb.append(key);
        return this.logManager.getObject(sb.toString());
    }
}

