/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.soap.encoding.soapenc.Base64;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.middleware.data.SoapClient;
import org.eclipse.aperi.util.SRMCrypto;

public class MiddlewareCrypto {
    private static char[] password = null;
    private static byte[] salt = new byte[]{-94, 52, -38, 17, 105, 22, -51, 116};
    private static Cipher cipher = null;
    private static PBEParameterSpec params = null;
    private static SecretKey key = null;
    private static Properties setup = null;
    private static String tsnm_baseDir = null;
    private static final String PROPERTIES_FILE = "configuration" + File.separator + "setup.properties";
    private static final String INSTALL_PASS_KEY = "installationPass";
    private static boolean initialized = false;

    public static void initStaticVars() {
        cipher = null;
        params = null;
        key = null;
        setup = null;
        tsnm_baseDir = null;
        initialized = false;
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        try {
            if (password == null) {
                password = MiddlewareCrypto.loadPassword();
            }
            MiddlewareCrypto.initialize(password);
        }
        catch (Exception e) {
            password = null;
            key = null;
            e.printStackTrace();
            initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(char[] password) {
        try {
            Object object = SoapClient.genKeyLock;
            synchronized (object) {
                params = new PBEParameterSpec(salt, 5);
                PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
                SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
                key = keyFac.generateSecret(pbeKeySpec);
                cipher = Cipher.getInstance("PBEWithMD5AndDES");
                initialized = true;
            }
        }
        catch (Exception e) {
            password = null;
            key = null;
            e.printStackTrace();
            initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encrypt(byte[] enc) throws Exception {
        MiddlewareCrypto.initialize();
        Cipher cipher = MiddlewareCrypto.cipher;
        synchronized (cipher) {
            MiddlewareCrypto.cipher.init(1, (Key)key, params);
            return MiddlewareCrypto.cipher.doFinal(enc);
        }
    }

    public static String encrypt(String encStr) throws Exception {
        MiddlewareCrypto.initialize();
        byte[] doneByte = MiddlewareCrypto.encrypt(encStr.getBytes());
        return Base64.encode((byte[])doneByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decrypt(byte[] dec) throws Exception {
        MiddlewareCrypto.initialize();
        Cipher cipher = MiddlewareCrypto.cipher;
        synchronized (cipher) {
            MiddlewareCrypto.cipher.init(2, (Key)key, params);
            return MiddlewareCrypto.cipher.doFinal(dec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decrypt(String decStr) throws Exception {
        MiddlewareCrypto.initialize();
        Cipher cipher = MiddlewareCrypto.cipher;
        synchronized (cipher) {
            MiddlewareCrypto.cipher.init(2, (Key)key, params);
            byte[] newByte = Base64.decode((String)decStr);
            byte[] doneByte = MiddlewareCrypto.decrypt(newByte);
            return new String(doneByte);
        }
    }

    private static char[] loadPassword() throws Exception {
        char[] password = null;
        tsnm_baseDir = Variables.getBaseDirectory();
        setup = new Properties();
        setup.load(new FileInputStream(tsnm_baseDir + File.separator + PROPERTIES_FILE));
        String pass = setup.getProperty(INSTALL_PASS_KEY);
        if (pass != null) {
            password = SRMCrypto.decrypt(pass).toCharArray();
            pass = null;
        }
        return password;
    }

    public static void setPassword(String pass) throws Exception {
        password = SRMCrypto.decrypt(pass).toCharArray();
        initialized = false;
    }
}

