/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.util.Enumeration;
import java.util.Hashtable;

public class RoleChecker {
    public static int SUPERUSER = 1;
    public static int APERI_ADMIN = 2;
    public static int DISK_VIEWER = 4;
    public static int DISK_ADMIN = 8 | DISK_VIEWER;
    public static int FABRIC_VIEWER = 16;
    public static int FABRIC_ADMIN = 0x20 | FABRIC_VIEWER;
    public static int DATA_VIEWER = 64;
    public static int DATA_ADMIN = 0x80 | DATA_VIEWER;
    public static int TAPE_VIEWER = 1024;
    public static int TAPE_ADMIN = 0x800 | TAPE_VIEWER;
    public static int NO_ROLE = 0;
    public static String APERI_SUPERUSER = "Superuser";
    public static String APERI_ADMINISTRATOR = "Aperi Administrator";
    public static String DISK_ADMINISTRATOR = "Disk Administrator";
    public static String DISK_OPERATOR = "Disk Operator";
    public static String FABRIC_ADMINISTRATOR = "Fabric Administrator";
    public static String FABRIC_OPERATOR = "Fabric Operator";
    public static String DATA_ADMINISTRATOR = "Data Administrator";
    public static String DATA_OPERATOR = "Data Operator";
    public static String TAPE_ADMINISTRATOR = "Tape Administrator";
    public static String TAPE_OPERATOR = "Tape Operator";
    private static Hashtable roleMap = new Hashtable();

    public static String getRoleName(int roleID) {
        String roleName = null;
        Integer role = new Integer(roleID);
        if (roleMap.contains(role)) {
            Enumeration e = roleMap.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Integer value = (Integer)roleMap.get(key);
                if (role.compareTo(value) != 0) continue;
                roleName = (String)key;
                break;
            }
        }
        return roleName;
    }

    public static int getRoleID(String roleName) {
        int roleID = 0;
        Integer rID = RoleChecker.getIntegerRoleID(roleName);
        if (rID != null) {
            roleID = rID;
        }
        return roleID;
    }

    public static Integer getIntegerRoleID(String roleName) {
        Integer roleID = null;
        if (roleName != null && roleMap.containsKey(roleName)) {
            roleID = (Integer)roleMap.get(roleName);
        }
        return roleID;
    }

    public static boolean isValidRole(int role) {
        boolean isValid = false;
        if (role < SUPERUSER) {
            return isValid;
        }
        if (role == SUPERUSER) {
            isValid = true;
        } else {
            int otherRoles = APERI_ADMIN | DATA_ADMIN | TAPE_ADMIN | FABRIC_ADMIN | DISK_ADMIN;
            if ((role & otherRoles) == role) {
                isValid = true;
            }
        }
        return isValid;
    }

    public static boolean isUserInRole(int userRoles, int requiredRoles) {
        boolean retVal = false;
        if (RoleChecker.isValidRole(requiredRoles) && RoleChecker.isValidRole(userRoles)) {
            retVal = userRoles == SUPERUSER ? true : (userRoles == requiredRoles ? true : ((userRoles & requiredRoles) == 0 ? false : (userRoles & requiredRoles) == requiredRoles));
        }
        return retVal;
    }

    static {
        roleMap.put(APERI_SUPERUSER, new Integer(SUPERUSER));
        roleMap.put(APERI_ADMINISTRATOR, new Integer(APERI_ADMIN));
        roleMap.put(DISK_ADMINISTRATOR, new Integer(DISK_ADMIN));
        roleMap.put(DISK_OPERATOR, new Integer(DISK_VIEWER));
        roleMap.put(FABRIC_ADMINISTRATOR, new Integer(FABRIC_ADMIN));
        roleMap.put(FABRIC_OPERATOR, new Integer(FABRIC_VIEWER));
        roleMap.put(DATA_ADMINISTRATOR, new Integer(DATA_ADMIN));
        roleMap.put(DATA_OPERATOR, new Integer(DATA_VIEWER));
        roleMap.put(TAPE_ADMINISTRATOR, new Integer(TAPE_ADMIN));
        roleMap.put(TAPE_OPERATOR, new Integer(TAPE_VIEWER));
    }
}

