/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponseImpl;

public class ViewerRequestImpl
implements ViewerRequest {
    protected GraphModel.ID modelId;
    protected Vector subFocusNodes;
    protected Timestamp ts;
    protected ViewerResponse response;
    protected int requestType = 0;
    protected int refreshRate;
    protected Serializable obj;
    protected TopoSetting topoSetting;

    public ViewerRequestImpl() {
    }

    public boolean equals(Object o) {
        if (!(o instanceof ViewerRequestImpl)) {
            return false;
        }
        ViewerRequestImpl that = (ViewerRequestImpl)o;
        return this.modelId == null ? that.modelId == null : this.modelId.equals(that.modelId);
    }

    public int hashCode() {
        return (this.modelId != null ? this.modelId.hashCode() : 0) * 37 << 16;
    }

    public ViewerRequestImpl(int requestType) {
        this(null);
    }

    public ViewerRequestImpl(GraphModel.ID focusNodes) {
        this();
        this.modelId = focusNodes;
    }

    public Enumeration elements() {
        Vector<ViewerRequestImpl> v = new Vector<ViewerRequestImpl>();
        v.add(this);
        return v.elements();
    }

    public ViewerResponse constructResponse() {
        this.response = new ViewerResponseImpl();
        this.response.setRequest(this);
        this.response.setResponseType(this.requestType);
        return this.response;
    }

    public Timestamp getTimestamp() {
        return this.ts;
    }

    public GraphModel.ID getFocusNode() {
        return this.modelId;
    }

    public Vector getSubFocusNode() {
        return this.subFocusNodes;
    }

    public ViewerResponse getResponse() {
        return this.response;
    }

    public void setResponse(ViewerResponse resp) {
        this.response = resp;
    }

    public void setTimestamp(Timestamp ts) {
        this.ts = ts;
    }

    public void addRequest(GraphModel.ID model, Timestamp ts) {
        this.modelId = model;
        this.ts = ts;
    }

    public GraphModel.ID getModelID() {
        return this.modelId;
    }

    public void setRequestType(int type) {
        this.requestType = type;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRefreshRate(int sec) {
        this.refreshRate = sec;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRequestObject(Serializable o) {
        this.obj = o;
    }

    public Serializable getRequestObject() {
        return this.obj;
    }

    public void setTopoSettings(TopoSetting topoSetting) {
        this.topoSetting = topoSetting;
    }

    public TopoSetting getTopoSettings() {
        return this.topoSetting;
    }
}

