/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestHandler;

public class TopoSettingHandler {
    public static final String SETTING_SHOW_HEALTH = "show_health";
    public static final String SETTING_SHOW_PERF = "show_perf";
    public static final String SETTING_SHOW_ZONE = "show_zone";
    public static final String SETTING_SHOW_CONN = "show_conn";
    public static final String SETTING_FILTERING_LEVEL = "filtering_level";
    public static final String SET_GLOBAL_SETTING_FOR_USER = "INSERT INTO   T_RES_TOPO_GLOBAL_SETTINGS (USERNAME, SETTING, VAL) VALUES (?,?,?)";
    public static final String UPDATE_GLOBAL_SETTING_FOR_USER = "UPDATE    T_RES_TOPO_GLOBAL_SETTINGS SET \tT_RES_TOPO_GLOBAL_SETTINGS.VAL = ? WHERE    T_RES_TOPO_GLOBAL_SETTINGS.USERNAME = ? and    T_RES_TOPO_GLOBAL_SETTINGS.SETTING = ?";
    public static final String GET_GLOBAL_SETTINGS_FOR_USER = "SELECT \tSETTINGS.SETTING SETTING, \tSETTINGS.VAL VAL FROM \tT_RES_TOPO_GLOBAL_SETTINGS SETTINGS WHERE    SETTINGS.USERNAME = ?";

    public static TopoSetting readSettings(Connection con, String username) throws SQLException {
        TopoSetting topoSetting = new TopoSetting();
        TopoSettingHandler.readGlobalSettings(con, username, topoSetting);
        return topoSetting;
    }

    public static void writeSettings(Connection con, String username, TopoSetting topoSetting) throws SQLException {
        TopoSettingHandler.writeGlobalSettings(con, username, topoSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readGlobalSettings(Connection con, String username, TopoSetting topoSetting) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(GET_GLOBAL_SETTINGS_FOR_USER);
            stmt.setString(1, username);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String setting = (String)resultSet.getObject("SETTING");
                Integer valueInt = (Integer)resultSet.getObject("VAL");
                int value = valueInt;
                if (setting.equals(SETTING_SHOW_HEALTH)) {
                    if (value == 0) {
                        topoSetting.setOverlayHealthEnabled(false);
                        continue;
                    }
                    if (value != 1) continue;
                    topoSetting.setOverlayHealthEnabled(true);
                    continue;
                }
                if (setting.equals(SETTING_SHOW_PERF)) {
                    if (value == 0) {
                        topoSetting.setOverlayPerfEnabled(false);
                        continue;
                    }
                    if (value != 1) continue;
                    topoSetting.setOverlayPerfEnabled(true);
                    continue;
                }
                if (setting.equals(SETTING_SHOW_ZONE)) {
                    if (value == 0) {
                        topoSetting.setShowZoneEnabled(false);
                        continue;
                    }
                    if (value != 1) continue;
                    topoSetting.setShowZoneEnabled(true);
                    continue;
                }
                if (setting.equals(SETTING_SHOW_CONN)) {
                    if (value == 0) {
                        topoSetting.setShowConnectionEnabled(false);
                        continue;
                    }
                    if (value != 1) continue;
                    topoSetting.setShowConnectionEnabled(true);
                    continue;
                }
                if (!setting.equals(SETTING_FILTERING_LEVEL) || value != 0 && value != 2 && value != 1) continue;
                topoSetting.setFilteringLevel(value);
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "readGlobalSettings", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerRequestHandler.class.getName(), "readGlobalSettings", e);
                }
            }
        }
    }

    private static void writeGlobalSettings(Connection con, String username, TopoSetting topoSetting) throws SQLException {
        int health = 0;
        if (topoSetting.isOverlayHealthEnabled()) {
            health = 1;
        }
        int perf = 0;
        if (topoSetting.isOverlayPerfEnabled()) {
            perf = 1;
        }
        int zone = 0;
        if (topoSetting.isShowZoneEnabled()) {
            zone = 1;
        }
        int conn = 0;
        if (topoSetting.isShowConnectionEnabled()) {
            conn = 1;
        }
        int filt = topoSetting.getFilteringLevel();
        TopoSettingHandler.writeSetting(con, username, SETTING_SHOW_HEALTH, health);
        TopoSettingHandler.writeSetting(con, username, SETTING_SHOW_PERF, perf);
        TopoSettingHandler.writeSetting(con, username, SETTING_SHOW_ZONE, zone);
        TopoSettingHandler.writeSetting(con, username, SETTING_SHOW_CONN, conn);
        TopoSettingHandler.writeSetting(con, username, SETTING_FILTERING_LEVEL, filt);
        con.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSetting(Connection con, String username, String setting, int value) throws SQLException {
        block11: {
            PreparedStatement stmt = null;
            try {
                block12: {
                    stmt = con.prepareStatement(UPDATE_GLOBAL_SETTING_FOR_USER);
                    stmt.setInt(1, value);
                    stmt.setString(2, username);
                    stmt.setString(3, setting);
                    int rows = stmt.executeUpdate();
                    if (rows != 0) break block11;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block12;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "writeGlobalSettings", e);
                    }
                }
                stmt = con.prepareStatement(SET_GLOBAL_SETTING_FOR_USER);
                stmt.setString(1, username);
                stmt.setString(2, setting);
                stmt.setInt(3, value);
                stmt.executeUpdate();
            }
            finally {
                block13: {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block13;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "writeGlobalSettings", e);
                    }
                }
            }
        }
    }
}

