/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestDispatcher;

public class ViewerAutoRefreshTimer
implements Runnable {
    private boolean alive = false;
    private boolean stopped = false;
    private int timeout = 60000;
    private Thread thread = null;
    private ViewerRequestDispatcher dispatcher;

    public ViewerAutoRefreshTimer(ViewerRequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public int getTimeout() {
        return this.timeout / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ViewerAutoRefreshTimer viewerAutoRefreshTimer = this;
        synchronized (viewerAutoRefreshTimer) {
            if (!this.alive) {
                this.alive = true;
                this.thread = new Thread(this);
                this.thread.setName(GuiUtil.getString("Topology Viewer - Autorefresh timer"));
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ViewerAutoRefreshTimer viewerAutoRefreshTimer = this;
        synchronized (viewerAutoRefreshTimer) {
            while (true) {
                if (this.stopped) {
                    this.alive = false;
                    return;
                }
                try {
                    this.wait(this.timeout);
                    try {
                        if (this.stopped) continue;
                        this.dispatcher.refreshAllViews();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        ViewerAutoRefreshTimer viewerAutoRefreshTimer = this;
        synchronized (viewerAutoRefreshTimer) {
            this.stopped = false;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimer() {
        ViewerAutoRefreshTimer viewerAutoRefreshTimer = this;
        synchronized (viewerAutoRefreshTimer) {
            this.notify();
        }
        this.startTimer();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        ViewerAutoRefreshTimer viewerAutoRefreshTimer = this;
        synchronized (viewerAutoRefreshTimer) {
            this.stopped = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(int seconds) {
        ViewerAutoRefreshTimer viewerAutoRefreshTimer = this;
        synchronized (viewerAutoRefreshTimer) {
            this.timeout = seconds * 1000;
            this.notify();
        }
    }
}

