/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.server.guireq.topology.request.handler.GraphHolder;

public class ViewerCache {
    public static Vector cache = new Vector();

    public static synchronized GraphModel getFromCache(GraphModel.ID focusId, boolean onlyClosed) {
        GraphHolder holder = new GraphHolder(focusId);
        int len = cache.size();
        for (int i = 0; i < len; ++i) {
            if (!cache.elementAt(i).equals(focusId)) continue;
            GraphHolder graphModelHolder = (GraphHolder)cache.remove(i);
            cache.insertElementAt(graphModelHolder, 0);
            if (onlyClosed) {
                if (graphModelHolder.isClosed()) {
                    return graphModelHolder.getModel();
                }
                return null;
            }
            return graphModelHolder.getModel();
        }
        return null;
    }

    public static Vector getAllElementsFromCache() {
        return cache;
    }

    public static synchronized void updateCache(int status, GraphModel.ID focusId, GraphModel graphModel) {
        GraphHolder holder = new GraphHolder(focusId, graphModel);
        if (0 != status) {
            cache.remove(holder);
        } else if (graphModel != null) {
            int i = cache.indexOf(holder);
            if (i > -1) {
                ((GraphHolder)cache.elementAt(i)).open();
            } else {
                cache.add(0, holder);
            }
        }
    }

    public static synchronized void markAsClosed(GraphModel.ID focusId) {
        GraphHolder holder = new GraphHolder(focusId);
        int i = cache.indexOf(holder);
        if (i > -1) {
            ((GraphHolder)cache.elementAt(i)).close();
        }
    }

    public static synchronized void removeClosedTabs() {
        int len = cache.size();
        Iterator iter = cache.iterator();
        while (iter.hasNext()) {
            GraphHolder holder = (GraphHolder)iter.next();
            if (!holder.isClosed()) continue;
            iter.remove();
        }
    }

    public static void clearCache() {
        cache.removeAllElements();
    }
}

