/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestDispatcher;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

class ViewerGuiGotResponse
implements Runnable {
    private short status;
    private String errorMessage;
    private Response response;
    private ViewerRequestDispatcher requestor;
    private ViewerRequestNode node;
    private Request request;
    private static final String SERVER = MessageLog.getMessageNoID("GUI0001L", null);
    private static final String STATUS = MessageLog.getMessageNoID("GUI0002L", null);
    static int cntr = 0;

    protected ViewerGuiGotResponse(short status, Request request, Response response, String errorMessage, ViewerRequestDispatcher requestor, ViewerRequestNode node) {
        this.status = status;
        this.response = response;
        this.errorMessage = errorMessage;
        this.requestor = requestor;
        this.node = node;
        this.request = request;
    }

    public static synchronized boolean lock() {
        if (cntr == 0) {
            ++cntr;
            return true;
        }
        return false;
    }

    public static synchronized void unlock() {
        --cntr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.requestor.removeNode(this.node)) {
            this.requestor.finishRefresh(this.request);
            return;
        }
        ViewerResponse rsp = null;
        Object o = null;
        if (this.response != null && (rsp = (ViewerResponse)this.response.responseData) != null) {
            o = rsp.getResponse();
        }
        if ((this.status != 0 || o instanceof Throwable) && ViewerGuiGotResponse.lock()) {
            try {
                this.requestor.getTimer().stopTimer();
                if (o instanceof Throwable) {
                    GuiClient.serverError(this.status, ((Throwable)o).getMessage());
                } else {
                    GuiClient.serverError(this.status, this.errorMessage);
                }
            }
            finally {
                ViewerGuiGotResponse.unlock();
            }
        }
        this.requestor.handleResponse(this.status, this.request, this.response);
    }
}

