/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponseImpl;
import org.eclipse.aperi.server.guireq.topology.request.handler.TopoSettingHandler;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerPinnedList;
import org.eclipse.aperi.server.guireq.topology.views.ViewerProbeMgr;
import org.eclipse.aperi.server.guireq.topology.views.ViewerPropagatedStatus;
import org.eclipse.aperi.server.guireq.topology.views.ViewerRoot;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSanL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerStorageL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSwitchL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL2;

public class ViewerRequestHandler {
    static boolean debug = false;
    static int tempIds = 0;
    public static final String SELECT_TIMEOUT = "SELECT \tSETTINGS.TV_REFRESH_TIMEOUT TIMEOUT FROM \tT_STORM_SETTINGS SETTINGS ";
    public static final String UPDATE_TIMEOUT = "UPDATE     T_STORM_SETTINGS SET T_STORM_SETTINGS.TV_REFRESH_TIMEOUT = ?";

    public static synchronized int getTmpId() {
        return tempIds++;
    }

    public static ViewerResponse handleRequest(Connection con, Request request) {
        ViewerRequest rqst = (ViewerRequest)request.requestData;
        String username = request.userName;
        if (debug) {
            System.out.println("ENTER- handleRequest(): " + rqst);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerRequestHandler.class.getName(), "handleRequest", "");
        }
        ViewerResponse resp = null;
        if (rqst == null) {
            resp = new ViewerResponseImpl();
            resp.addResponse(1, null);
            return resp;
        }
        resp = rqst.constructResponse();
        Enumeration e = rqst.elements();
        ViewerRequest singleRqst = (ViewerRequest)e.nextElement();
        try {
            if (rqst.getRequestType() == 0) {
                GraphModel.ID modelId = singleRqst.getModelID();
                ViewerPropagatedStatus.propagateStatus(con, null, modelId.getFocusLevel());
                String level = modelId.getFocusLevel();
                if (level.equals("Overview")) {
                    new ViewerRoot().getView(con, rqst, resp);
                } else if (level.equals("FabricL0")) {
                    new ViewerSanL0().getView(con, rqst, resp);
                } else if (level.equals("FabricL2")) {
                    new ViewerSanL1().getView(con, rqst, resp);
                } else if (level.equals("ComputerL0")) {
                    new ViewerServerL0().getView(con, rqst, resp);
                } else if (level.equals("ComputerL2")) {
                    new ViewerServerL2().getView(con, rqst, resp);
                } else if (level.equals("SwitchL0")) {
                    new ViewerSwitchL0().getView(con, rqst, resp);
                } else if (level.equals("SwitchL2")) {
                    new ViewerSwitchL2().getView(con, rqst, resp);
                } else if (level.equals("StorageL0")) {
                    new ViewerStorageL0().getView(con, rqst, resp);
                } else if (level.equals("SubsystemL2")) {
                    new ViewerSubsystemL2().getView(con, rqst, resp);
                } else if (level.equals("TapeLibraryL1")) {
                    new ViewerTapeLibraryL1().getView(con, rqst, resp);
                } else if (level.equals("TapeLibraryL2")) {
                    new ViewerTapeLibraryL2().getView(con, rqst, resp);
                } else if (level.equals("OtherL0")) {
                    new ViewerOtherL0().getView(con, rqst, resp);
                } else if (level.equals("OtherL2")) {
                    new ViewerOtherL2().getView(con, rqst, resp);
                } else if (level.equals("PinList")) {
                    ViewerPinnedList.getView(con, rqst, resp);
                } else if (level.equals("ComputerL1") || level.equals("SwitchL1") || level.equals("SubsystemL1") || level.equals("OtherL1")) {
                    int id = ViewerRequestHandler.getTmpId();
                    if (level.equals("ComputerL1")) {
                        new ViewerServerL1().getView(con, rqst, resp, id);
                    } else if (level.equals("SwitchL1")) {
                        new ViewerSwitchL1().getView(con, rqst, resp);
                    } else if (level.equals("SubsystemL1")) {
                        new ViewerSubsystemL1().getView(con, rqst, resp);
                    } else if (level.equals("OtherL1")) {
                        new ViewerOtherL1().getView(con, rqst, resp, id);
                    }
                }
            } else if (rqst.getRequestType() == 2) {
                ViewerRequestHandler.getRefreshInterval(con, rqst, resp);
            } else if (rqst.getRequestType() == 1) {
                ViewerRequestHandler.setRefreshInterval(con, rqst, resp);
            } else if (rqst.getRequestType() == 3) {
                new ViewerProbeMgr();
                ViewerProbeMgr.probe(con, username, rqst, resp);
            } else if (rqst.getRequestType() == 4) {
                ViewerRequestHandler.getTopoSettings(con, username, rqst, resp);
            } else if (rqst.getRequestType() == 5) {
                ViewerRequestHandler.setTopoSettings(con, username, rqst, resp);
            }
        }
        catch (Throwable ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(ViewerRequestHandler.class.getName(), "handleRequest", ex);
            }
            if (ex instanceof Exception) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(bos);
                ex.printStackTrace(pw);
                pw.flush();
                ex = new Throwable(bos.toString());
            }
            resp.addResponse(1, ex);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerRequestHandler.class.getName(), "handleRequest", "");
        }
        if (debug) {
            System.out.println("EXIT- handleRequest()");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(resp);
            oos.flush();
            oos.close();
            byte[] bytes = baos.toByteArray();
            int size = bytes.length;
            System.out.println("Total Size: " + size);
        }
        catch (IOException e1) {
            // empty catch block
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getRefreshInterval(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(SELECT_TIMEOUT);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer timeout = (Integer)resultSet.getObject("TIMEOUT");
                if (timeout == null) {
                    timeout = new Integer(300);
                }
                resp.setRefreshRate(timeout);
            }
        }
        finally {
            block17: {
                block16: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block16;
                        TraceLogger.exception(ViewerRequestHandler.class.getName(), "getRefreshInterval", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block17;
                    TraceLogger.exception(ViewerRequestHandler.class.getName(), "getRefreshInterval", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRefreshInterval(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        int i = 0;
        try {
            stmt = con.prepareStatement(UPDATE_TIMEOUT);
            stmt.setInt(1, rqst.getRefreshRate());
            i = stmt.executeUpdate();
            con.commit();
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "setRefreshInterval", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "setRefreshInterval", e);
                }
            }
        }
    }

    public static Timestamp getLatestUpdate(Connection con) {
        return null;
    }

    public static void getTopoSettings(Connection con, String username, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        TopoSetting topoSetting = TopoSettingHandler.readSettings(con, username);
        resp.setTopoSettings(topoSetting);
    }

    public static void setTopoSettings(Connection con, String username, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        TopoSetting topoSetting = rqst.getTopoSettings();
        if (topoSetting == null) {
            return;
        }
        TopoSettingHandler.writeSettings(con, username, topoSetting);
    }
}

