/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerOtherL2
extends ViewerOtherL1 {
    private static final boolean debug = false;
    public static final String SELECT_OTHER = "SELECT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE  FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on\tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on\tOTHER.VENDOR_ID = VENDOR.VENDOR_ID WHERE     OTHER.OTHER_ID = ? and \t OTHER.PREFIX_ID = ?";
    public static final String SELECT_PORT_FROM_OTHER = "SELECT distinct     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS FROM T_RES_PORT, T_VIEW_VOTHER2PORT OTHER2PORT WHERE     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PREFIX_ID = ? and \t T_RES_PORT.PORT_ID = OTHER2PORT.PORT_ID ";
    public static final String SELECT_PORT2PORT_FROM_OTHER = "SELECT \tOTHER2PORT2PORT.PORT_ID PORT_ID, \tOTHER2PORT2PORT.DETECTABLE DETECTABLE, \tOTHER2PORT2PORT.PORT_ID2 PORT_ID2, \t CASE \t\tWHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL THEN T_RES_PORT.DISPLAY_NAME\t\tELSE T_RES_PORT.NAME \tEND PORT2_NAME, \tT_RES_PORT.PORT_NUMBER PORT_NUMBER, \tOTHER2PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\tENTITY2PORT.PREFIX_ID,\tENTITY2PORT.ENTITY_ID  FROM    T_RES_PORT, (SELECT  \tPORT2PORT.PORT_ID2 PORT_ID, \tOTHER2PORT.OTHER_ID OTHER_ID, \tOTHER2PORT.PREFIX_ID PREFIX_ID, \tOTHER2PORT.PORT_ID PORT_ID2, \tPORT2PORT.DETECTABLE DETECTABLE,    PORT2PORT.PORT2PORT_ID PORT2PORT_ID FROM  T_VIEW_PORT2PORT PORT2PORT,T_VIEW_VOTHER2PORT OTHER2PORT WHERE     PORT2PORT.PORT_ID1 = OTHER2PORT.PORT_ID) OTHER2PORT2PORT, T_VIEW_ENTITY2PORT ENTITY2PORT WHERE     ENTITY2PORT.PORT_ID = T_RES_PORT.PORT_ID and \t T_RES_PORT.PORT_ID = OTHER2PORT2PORT.PORT_ID and     OTHER2PORT2PORT.OTHER_ID =? and \t OTHER2PORT2PORT.PREFIX_ID = ? ";
    public static final String SELECT_SWITCH_FROM_OTHER = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on    T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on  \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID, T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE     SWITCH2OTHER.OTHER_ID = ? and \t SWITCH2OTHER.OTHER_PREFIX_ID = ? and \t T_RES_SWITCH.SWITCH_ID = SWITCH2OTHER.SWITCH_ID ";
    public static final String SELECT_SWITCH2OTHER_FROM_OTHER = "SELECT distinct \tSWITCH2OTHER.SWITCH_PREFIX_ID PREFIX_ID, \tSWITCH2OTHER.SWITCH_ID SWITCH_ID,    SWITCH2OTHER.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE     SWITCH2OTHER.OTHER_ID = ? and \t SWITCH2OTHER.OTHER_PREFIX_ID = ? ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_OTHER = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VOTHER2PORT OTHER2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE    OTHER2PORT.PREFIX_ID = ? and    OTHER2PORT.OTHER_ID = ? and \tOTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_OTHER = "SELECT distinct    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM     T_RES_ZONE, T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE, T_RES_FABRIC FABRIC WHERE \t OTHER2PORT.PREFIX_ID = ? and     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \t PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_OTHER = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID WHERE     OTHER2PORT.PREFIX_ID = ? and \t OTHER2PORT.OTHER_ID = ? and     OTHER2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID ";
    public static final String SELECT_ZSET2ZONE_FROM_OTHER = "SELECT DISTINCT     ZSET2ZONE.ZONE_ID,     ZSET2ZONE.ZSET_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZSET2ZONE ZSET2ZONE WHERE \t OTHER2PORT.PREFIX_ID = ? and     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_OTHER = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_PORT2ZSET PORT2ZSET,    T_RES_ZSET, T_RES_FABRIC FABRIC WHERE \t OTHER2PORT.PREFIX_ID = ? and     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_OTHER = "SELECT distinct \tSWITCH2FABRIC.PREFIX_ID, \tSWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2OTHER SWITCH2OTHER,T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC  WHERE \tT_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and    SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID and    SWITCH2OTHER.OTHER_PREFIX_ID = ? and    SWITCH2OTHER.OTHER_ID = ?";
    public static final String SELECT_LUN_FROM_OTHER = "SELECT distinct       LUN2OTHER.SUBSYSTEM_ID,      LUN2OTHER.PREFIX_ID,       LUN2OTHER.OTHER_ID,       LUN2OTHER.DEVICE_LUN_ID DEVICE_LUN_ID,     LUN2OTHER.VOLUME_ID VOLUME_ID, \t LUN2OTHER.PATH   FROM   (SELECT DISTINCT    \t OTHER.PREFIX_ID PREFIX_ID,    \t OTHER.OTHER_ID OTHER_ID,    \t RTRIM(CAST(DATA_PATH.DEVICE_LUN_ID as CHAR(10))) PATH,    \t DATA_PATH.DEVICE_LUN_ID DEVICE_LUN_ID,    \t VOLUME.CONSOLIDATED_STATUS STATUS, \t DATA_PATH.VOLUME_ID VOLUME_ID,    \t DATA_PATH.SUBSYSTEM_ID SUBSYSTEM_ID FROM    \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,     \tT_VIEW_VOTHER OTHER, T_VIEW_VOTHER2PORT OTHER2PORT WHERE    \tOTHER.PREFIX_ID = OTHER2PORT.PREFIX_ID and    \tOTHER.OTHER_ID = OTHER2PORT.OTHER_ID and    \tOTHER2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and \tVOLUME.SVID = DATA_PATH.VOLUME_ID) LUN2OTHER WHERE  \t? = LUN2OTHER.PREFIX_ID and    ? = LUN2OTHER.OTHER_ID ";
    public static final String SELECT_ARRAYS_FROM_VOLUMES_FROM_OTHER = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\tOTHER2PORT.PREFIX_ID OTHER_PREFIX_ID, \tOTHER2PORT.OTHER_ID, \tDATA_PATH.VOLUME_ID FROM \tT_RES_DATA_PATH DATA_PATH,   \tT_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE \t? = OTHER2PORT.PREFIX_ID and \t? = OTHER2PORT.OTHER_ID and \tOTHER2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and \tDATA_PATH.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and \tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID = 'subsystem:' ";
    public static final String SELECT_VOLUMES_FROM_OTHER = "SELECT distinct     OTHER2PORT.PREFIX_ID, \t OTHER2PORT.OTHER_ID OTHER_ID,     CASE WHEN T_RES_STORAGE_VOLUME.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_STORAGE_VOLUME.DISPLAY_NAME) != '' THEN T_RES_STORAGE_VOLUME.DISPLAY_NAME \t\t  WHEN T_RES_STORAGE_VOLUME.SVID IS NOT NULL THEN CAST(T_RES_STORAGE_VOLUME.SVID as CHAR) \t END DISPLAY_NAME, T_RES_STORAGE_VOLUME.SVID SVID, T_RES_STORAGE_VOLUME.NAME || '+' || CAST(T_RES_STORAGE_VOLUME.NAME_FORMAT as CHAR) NATURAL_KEY, (T_RES_STORAGE_VOLUME.CAPACITY*512) CAPACITY, T_RES_STORAGE_VOLUME.POOL_ID POOL_ID, T_RES_STORAGE_VOLUME.FORMAT FORMAT, T_RES_STORAGE_VOLUME.IS_ASSIGNED IS_ASSIGNED, T_RES_STORAGE_VOLUME.USER_ATTRIB1 USER_ATTRIB1, T_RES_STORAGE_VOLUME.USER_ATTRIB2 USER_ATTRIB2, T_RES_STORAGE_VOLUME.USER_ATTRIB3 USER_ATTRIB3, T_RES_STORAGE_VOLUME.DETECTABLE DETECTABLE, T_RES_STORAGE_VOLUME.OPERATIONAL_STATUS OPERATIONAL_STATUS, T_RES_STORAGE_VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS  FROM \tT_RES_DATA_PATH DATA_PATH,  \tT_VIEW_VOTHER2PORT OTHER2PORT, T_RES_STORAGE_VOLUME WHERE \t? = OTHER2PORT.PREFIX_ID and \t? = OTHER2PORT.OTHER_ID and \tOTHER2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and    DATA_PATH.VOLUME_ID = T_RES_STORAGE_VOLUME.SVID ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphOther getOther(Connection con, GraphModel model, HashMap entityMap, String prefix, int otherId_) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphOther gOther = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_OTHER);
            stmt.setInt(1, otherId_);
            stmt.setString(2, prefix);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer unknownId = (Integer)resultSet.getObject("OTHER_ID");
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                String otherKey = prefixId + unknownId;
                if (entityMap == null || entityMap.get(otherKey) == null) {
                    gOther = new GraphOther(otherKey);
                    this.populator.populateOther(resultSet, gOther);
                    model.put(gOther);
                    entityMap.put(otherKey, gOther);
                    if (model != null) {
                        model.put(gOther);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(otherKey, gOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getOther", "Duplicated Other entry:" + otherKey);
            }
        }
        finally {
            block18: {
                block17: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        return gOther;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPortFromOther(Connection con, GraphModel model, HashMap entityMap, String prefix, int otherId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphFCPort gPort = null;
        String otherKey = prefix + otherId;
        GraphOther gOther = (GraphOther)entityMap.get(otherKey);
        if (gOther == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "MIssing host");
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_PORT_FROM_OTHER);
            stmt.setInt(1, otherId);
            stmt.setString(2, prefix);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                String portKey = "Port:" + portId;
                if (entityMap == null || entityMap.get(portKey) == null) {
                    String other2portKey;
                    GraphOther2FCPort other2port;
                    gPort = new GraphFCPort(portKey);
                    this.populator.populatePort(resultSet, gPort);
                    if (model != null) {
                        model.put(gPort);
                    }
                    if (entityMap != null) {
                        entityMap.put(portKey, gPort);
                    }
                    if ((other2port = (GraphOther2FCPort)entityMap.get(other2portKey = "other2port:" + prefix + otherId + ',' + portId)) == null) {
                        other2port = new GraphOther2FCPort(other2portKey);
                        other2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                        other2port.setOtherID((GraphOther.ID)gOther.getEntityID());
                        model.put(other2port);
                        entityMap.put(other2portKey, other2port);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Duplicated switch2port entry:" + other2portKey);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Duplicated port entry:" + portKey);
            }
        }
        finally {
            block40: {
                block39: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block39;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block40;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", e);
                }
            }
        }
        try {
            stmt = con.prepareStatement(SELECT_PORT2PORT_FROM_OTHER);
            stmt.setInt(1, otherId);
            stmt.setString(2, prefix);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                GraphFCPort gPort2;
                Integer portId1 = (Integer)resultSet.getObject("PORT_ID");
                Integer portId2 = (Integer)resultSet.getObject("PORT_ID2");
                String portName2 = (String)resultSet.getObject("PORT2_NAME");
                String portNumber = (String)resultSet.getObject("PORT_NUMBER");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer entityId = (Integer)resultSet.getObject("ENTITY_ID");
                String portKey1 = "Port:" + portId1;
                String portKey2 = "Port:" + portId2;
                gPort = (GraphFCPort)entityMap.get(portKey1);
                if (gPort == null) {
                    gPort = new GraphFCPort(portKey1);
                    gPort.setDisplayName(portName2);
                    gPort.setPortNumber(portNumber);
                    model.put(gPort);
                    entityMap.put(portKey1, gPort);
                }
                if ((gPort2 = (GraphFCPort)entityMap.get(portKey2)) == null) {
                    gPort2 = new GraphFCPort(portKey2);
                    model.put(gPort2);
                    entityMap.put(portKey2, gPort2);
                }
                if (gPort2 != null && gPort != null) {
                    String port2portKey = "port2port:" + prefix + otherId + ',' + prefixId + entityId + ',' + port2portId;
                    GraphFCPort2FCPort port2port = (GraphFCPort2FCPort)entityMap.get(port2portKey);
                    if (port2port == null) {
                        port2port = new GraphFCPort2FCPort(port2portKey);
                        port2port.setFCPort1ID((GraphFCPort.ID)gPort.getEntityID());
                        port2port.setFCPort2ID((GraphFCPort.ID)gPort2.getEntityID());
                        this.populator.populatePort2Port(resultSet, port2port);
                        model.put(port2port);
                        entityMap.put(port2portKey, port2port);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Duplicated port2port entry:" + port2portKey);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Missing port:" + portKey2);
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block42;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block43;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromOther(Connection con, GraphModel model, HashMap entityMap, String prefix, int otherId) throws SQLException {
        Integer switchId;
        String prefixId;
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSwitch gSwitch = null;
        String otherKey = prefix + otherId;
        GraphOther gOther = (GraphOther)entityMap.get(otherKey);
        if (gOther == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "MIssing host");
            }
            return;
        }
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH_FROM_OTHER);
            stmt.setInt(1, otherId);
            stmt.setString(2, prefix);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                prefixId = (String)resultSet.getObject("PREFIX_ID");
                switchId = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "SWITCH_ID is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                if (entityMap == null || entityMap.get(switchKey) == null) {
                    gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    if (model != null) {
                        model.put(gSwitch);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(switchKey, gSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Duplicated Switch entry:" + switchKey);
            }
        }
        finally {
            block39: {
                block38: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block38;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block39;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", e);
                }
            }
        }
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH2OTHER_FROM_OTHER);
            stmt.setInt(1, otherId);
            stmt.setString(2, prefix);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                prefixId = (String)resultSet.getObject("PREFIX_ID");
                switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "SWITCH_ID is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Switch not found:" + switchKey);
                    continue;
                }
                String portKey = "Port:" + portId;
                GraphFCPort gPort = (GraphFCPort)entityMap.get(portKey);
                if (gPort != null) {
                    String switch2portKey = "switch2fcport:" + switchId + ',' + portId;
                    GraphSwitch2FCPort switch2port = (GraphSwitch2FCPort)entityMap.get(switch2portKey);
                    if (switch2port == null) {
                        switch2port = new GraphSwitch2FCPort(switch2portKey);
                        switch2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                        switch2port.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                        model.put(switch2port);
                        entityMap.put(switch2portKey, switch2port);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Duplicated switch2port entry:" + switch2portKey);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Missing port entry:" + portKey);
            }
        }
        finally {
            block42: {
                block41: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block41;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block42;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOther2VolumeFromOther(Connection srmConnection, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        Integer otherId;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_VOLUMES_FROM_OTHER);
            stmt.setString(1, prefix);
            stmt.setInt(2, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String otherPrefixId = (String)resultSet.getObject("PREFIX_ID");
                otherId = (Integer)resultSet.getObject("OTHER_ID");
                Integer volumeId = (Integer)resultSet.getObject("SVID");
                if (volumeId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String otherKey = otherPrefixId + otherId;
                GraphOther gOther = (GraphOther)entityMap.get(otherKey);
                if (gOther == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + otherKey);
                    continue;
                }
                String volumeKey = "volume:" + volumeId;
                GraphVolume gVolume = (GraphVolume)entityMap.get(volumeKey);
                if (gVolume == null) {
                    gVolume = new GraphVolume(volumeKey);
                    this.populator.populateStorageVolume(resultSet, gVolume);
                    entityMap.put(volumeKey, gVolume);
                    model.put(gVolume);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + volumeKey);
                }
                String other2volumeKey = "other2volume:" + otherKey + ',' + volumeId;
                if (entityMap.get(other2volumeKey) == null) {
                    GraphOther2Volume gOther2volume = new GraphOther2Volume(other2volumeKey);
                    gOther2volume.setOtherID((GraphOther.ID)gOther.getEntityID());
                    gOther2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    model.put(gOther2volume);
                    entityMap.put(other2volumeKey, gOther2volume);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + other2volumeKey);
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block42;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block43;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", e);
                }
            }
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_ARRAYS_FROM_VOLUMES_FROM_OTHER);
            stmt.setString(1, prefix);
            stmt.setInt(2, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                GraphVolume gVolume;
                String prefixId = (String)resultSet.getObject("OTHER_PREFIX_ID");
                otherId = (Integer)resultSet.getObject("OTHER_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                String otherKey = prefixId + otherId;
                GraphOther gOther = (GraphOther)entityMap.get(otherKey);
                if (gOther == null || subsystemId == null) continue;
                String subsystemKey = "subsystem:" + subsystemId;
                String volumeKey = "volume:" + volumeId;
                GraphSubsystem gSubsystem = (GraphSubsystem)entityMap.get(subsystemKey);
                if (gSubsystem == null) {
                    gSubsystem = new GraphSubsystem(subsystemKey);
                    this.populator.populateSubsystem(resultSet, gSubsystem);
                    entityMap.put(subsystemKey, gSubsystem);
                    model.put(gSubsystem);
                }
                if ((gVolume = (GraphVolume)entityMap.get(volumeKey)) != null) {
                    String array2volumeKey = "subsystem2volume:" + subsystemId + ',' + volumeId;
                    GraphSubsystem2Volume array2volume = new GraphSubsystem2Volume(array2volumeKey);
                    array2volume.setSubsystemID((GraphSubsystem.ID)gSubsystem.getEntityID());
                    array2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    entityMap.put(array2volumeKey, array2volume);
                    model.put(array2volume);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + subsystemKey);
                }
                String other2volumeKey = "other2volume:" + otherKey + ',' + subsystemId;
                if (entityMap.get(other2volumeKey) == null) {
                    GraphOther2Volume gServer2volume = new GraphOther2Volume(other2volumeKey);
                    gServer2volume.setOtherID((GraphOther.ID)gOther.getEntityID());
                    gServer2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    model.put(gServer2volume);
                    entityMap.put(other2volumeKey, gServer2volume);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + other2volumeKey);
            }
        }
        finally {
            block46: {
                block45: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block45;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block46;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLUNsFromOther(Connection con, GraphModel model, HashMap entityMap, String prefixId, int entityId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getLUNsFromOther", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        Object gPool = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_LUN_FROM_OTHER);
            stmt.setString(1, prefixId);
            stmt.setInt(2, entityId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer otherIdInt = (Integer)resultSet.getObject("OTHER_ID");
                Integer lunId = (Integer)resultSet.getObject("DEVICE_LUN_ID");
                String path = (String)resultSet.getObject("PATH");
                String otherId = prefixId + otherIdInt;
                String lunStr = "(" + volumeId + ',' + otherId + ',' + lunId + ")";
                String lunKey = "lun:" + lunStr;
                GraphLun gLun = new GraphLun(lunKey);
                if (lunId != null) {
                    try {
                        gLun.setLunID(new Integer(lunId));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                gLun.setDisplayName(path);
                gLun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                GraphOther gOther = (GraphOther)entityMap.get(otherId);
                if (gOther == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getLunsFromOther", "Other not found: " + otherId);
                    continue;
                }
                model.put(gLun);
                entityMap.put(lunKey, gLun);
                String other2lunKey = "other2lun:" + otherId + ',' + lunStr;
                GraphOther2Lun other2lun = new GraphOther2Lun(other2lunKey);
                other2lun.setLunID((GraphLun.ID)gLun.getEntityID());
                other2lun.setOtherID((GraphOther.ID)gOther.getEntityID());
                model.put(other2lun);
                entityMap.put(other2lunKey, other2lun);
                GraphVolume gVolume = (GraphVolume)entityMap.get("volume:" + volumeId);
                if (gVolume == null) continue;
                String volume2lunKey = "lun2volume:" + volumeId + ',' + lunStr;
                GraphVolume2Lun volume2lun = new GraphVolume2Lun(volume2lunKey);
                volume2lun.setLunID((GraphLun.ID)gLun.getEntityID());
                volume2lun.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                model.put(volume2lun);
                entityMap.put(volume2lunKey, volume2lun);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException s) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getLUNsFromOther", s);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException s) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getLUNsFromSubsystem", s);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getLUNsFromSubsystem", "");
        }
    }

    public void getZonesFromOther(Connection con, GraphModel model, HashMap entityMap, String prefix, int entityId) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(con, model, entityMap, new Object[]{prefix, new Integer(entityId)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_OTHER, SELECT_ZONES_FROM_OTHER, SELECT_ZSET_FROM_OTHER, SELECT_ZSET2ZONE_FROM_OTHER, SELECT_ZONE2MEMBER_FROM_OTHER});
    }

    public void getZonesFromEntitiesConnectedToOther(Connection con, GraphModel model, HashMap entityMap, String prefix, int entityId) throws SQLException {
    }

    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        this.getSansFromSwitch(con, model, entityMap, new Object[]{prefix, new Integer(id)}, SELECT_SANS_FROM_SWITCH_FROM_OTHER);
    }

    public void getSansFromUnknown(Connection con, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        this.getSansFromUnknown(con, model, entityMap, new Object[]{prefix, new Integer(id)}, "SELECT \t OTHER2FABRIC.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC WHERE     OTHER2FABRIC.PREFIX_ID= ? and     OTHER2FABRIC.OTHER_ID  = ? ");
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        String subfix;
        int otherIdInt;
        String prefix;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelOtherL2 gModel = null;
        GraphOther.ID id = (GraphOther.ID)rqst.getModelID().getFocusEntityID();
        String otherId = (String)id.getID();
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if ((lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) && this.getOther(con, gModel = new GraphModelOtherL2((GraphModelOtherL2.ID)rqst.getModelID()), entityMap, prefix = otherId.substring(0, otherId.indexOf(58) + 1), otherIdInt = Integer.parseInt(subfix = otherId.substring(otherId.indexOf(58) + 1))) != null) {
            this.getPortFromOther(con, gModel, entityMap, prefix, otherIdInt);
            this.getSwitchFromOther(con, gModel, entityMap, prefix, otherIdInt);
            this.getSansFromSwitch(con, (GraphModel)gModel, entityMap, prefix, otherIdInt);
            this.getOther2VolumeFromOther(con, gModel, entityMap, prefix, otherIdInt);
            this.getLUNsFromOther(con, gModel, entityMap, prefix, otherIdInt);
            this.commit(con);
            if (rqst.getModelID().isNeedZoneData()) {
                this.getZonesFromOther(con, gModel, entityMap, prefix, otherIdInt);
                this.commit(con);
            }
            gModel.setWithZoneData(false);
        }
        gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
        resp.addResponse(0, gModel);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }
}

