/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelComputerL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2HBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabase2TableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDatabaseGroup2Database;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphFilesystem2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA;
import org.eclipse.aperi.gui.topo.model.bean.GraphHBA2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphLogicalVolumeManager2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2Filesystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphTableSpace2LogicalVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerServerL2
extends ViewerServerL1 {
    public static boolean debug = false;
    public static final String SELECT_HOST = "SELECT \t\tT_RES_HOST.PREFIX_ID, \t    CASE WHEN T_RES_HOST.HOST_NAME IS NOT NULL THEN T_RES_HOST.HOST_NAME \t\t\t WHEN T_RES_HOST.HOST_URL IS NOT NULL THEN T_RES_HOST.HOST_URL \t\t\t ELSE CAST(T_RES_HOST.COMPUTER_ID as CHAR(10)) \t\tEND  DISPLAY_NAME,        T_RES_HOST.DEV_STATUS DEV_STATUS,        T_RES_HOST.DAT_STATUS DAT_STATUS, \t\tT_RES_HOST.HOST_NAME HOST_NAME, \t\tT_RES_HOST.COMPUTER_ID HOST_ID, \t\tT_RES_HOST.GUID GUID, \t\tT_RES_HOST.OS_TYPE OS_TYPE,\t\tT_RES_HOST.OS_VERSION OS_VERSION,\t\tT_RES_HOST.TIME_ZONE TIME_ZONE,\t\tT_RES_HOST.IP_ADDRESS IP_ADDRESS,\t\tT_RES_HOST.DETECTABLE DETECTABLE, \t\tT_RES_HOST.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_HOST.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HOST.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HOST.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_HOST.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_HOST.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VHOST T_RES_HOST WHERE \tT_RES_HOST.PREFIX_ID = ? and \tT_RES_HOST.COMPUTER_ID = ?";
    public static final String SELECT_PORT_FROM_HOST = "SELECT     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS , HBA.HBA_ID HBA_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_RES_PORT left outer join T_RES_HBA HBA on T_RES_PORT.HBA_ID = HBA.HBA_ID WHERE     HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = T_RES_PORT.PORT_ID";
    public static final String SELECT_HBA_FROM_HOST = "SELECT \t\t(T_RES_HBA.HBA_WWN || CASE WHEN T_RES_HBA.NAME IS NOT NULL THEN '-' || T_RES_HBA.NAME ELSE '' END || CASE WHEN T_RES_HBA.SERIAL_NUMBER IS NOT NULL THEN '(' || T_RES_HBA.SERIAL_NUMBER || ')' ELSE '' END) DISPLAY_NAME, \t\tT_RES_HBA.HBA_ID HBA_ID, \t\tT_RES_HBA.API_VERSION API_VERSION, \t\tT_RES_HBA.HBA_WWN HBA_WWN, \t\tT_RES_HBA.DRIVER_VERSION DRIVER_VERSION, \t\tT_RES_HBA.SERIAL_NUMBER SERIAL_NUMBER, \t\tT_RES_HBA.DRIVER_NAME DRIVER_NAME, \t\tT_RES_HBA.FIRMWARE_VERSION FIRMWARE_VERSION, \t\tT_RES_HBA.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_HBA.DETECTABLE DETECTABLE, \t\tT_RES_HBA.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_HBA.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL FROM     T_RES_HOST HOST, T_RES_HBA left outer join T_RES_VENDOR VENDOR on \t T_RES_HBA.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \t T_RES_HBA.MODEL_ID = MODEL.MODEL_ID WHERE \t HOST.COMPUTER_ID = ? and     HOST.COMPUTER_ID = T_RES_HBA.HOST_ID";
    public static final String SELECT_PORT2PORT_FROM_HOST = "SELECT \tHOST2PORT2PORT.PORT1_ID PORT1_ID, \tHOST2PORT2PORT.PORT2_ID PORT2_ID, \tCASE \t\tWHEN PORT1.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT1.DISPLAY_NAME) != '' THEN PORT1.DISPLAY_NAME \t\tELSE PORT1.NAME \tEND PORT1_NAME, \tPORT1.PORT_NUMBER PORT_NUMBER1, \tCASE \t\tWHEN PORT2.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT2.DISPLAY_NAME) != '' THEN PORT2.DISPLAY_NAME \t\tELSE PORT2.NAME \tEND PORT2_NAME, \tPORT2.PORT_NUMBER PORT_NUMBER2,    HOST2PORT2PORT.PORT2PORT_ID PORT2PORT_ID,    HOST2PORT2PORT.DETECTABLE DETECTABLE, \tENTITY2PORT.PREFIX_ID, \tENTITY2PORT.ENTITY_ID FROM  \t T_RES_PORT PORT1, T_RES_PORT PORT2,  (SELECT     HOST2PORT.PREFIX_ID,     HOST2PORT.HOST_ID HOST_ID, \t PORT2PORT.PORT_ID2 PORT1_ID,     HOST2PORT.PORT_ID PORT2_ID,    PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\t PORT2PORT.DETECTABLE DETECTABLE FROM T_VIEW_VHOST2PORT HOST2PORT,     T_VIEW_PORT2PORT PORT2PORT WHERE     HOST2PORT.PORT_ID = PORT2PORT.PORT_ID1) HOST2PORT2PORT, T_VIEW_ENTITY2PORT ENTITY2PORT WHERE \tENTITY2PORT.PORT_ID = PORT1.PORT_ID and \tPORT1.PORT_ID = HOST2PORT2PORT.PORT1_ID and    PORT2.PORT_ID = HOST2PORT2PORT.PORT2_ID and \tHOST2PORT2PORT.PREFIX_ID = ? and \tHOST2PORT2PORT.HOST_ID = ?";
    public static final String SELECT_SWITCH_FROM_HOST = "SELECT \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\t SWITCH2HOST.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2HOST SWITCH2HOST,    T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on     T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID WHERE \t SWITCH2HOST.HOST_PREFIX_ID = ?  and \t SWITCH2HOST.HOST_ID = ? and  \t SWITCH2HOST.SWITCH_PREFIX_ID = T_RES_SWITCH.PREFIX_ID and \t SWITCH2HOST.SWITCH_ID = T_RES_SWITCH.SWITCH_ID ";
    public static final String SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST = "SELECT \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\t HOST2SUBSYSTEM.SUBSYSTEM_PORT_ID PORT_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM,     T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on     T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on     T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE \t HOST2SUBSYSTEM.HOST_PREFIX_ID = ? and \t HOST2SUBSYSTEM.HOST_ID = ? and     HOST2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = T_RES_STORAGE_SUBSYSTEM.PREFIX_ID and \t HOST2SUBSYSTEM.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID ";
    public static String SELECT_SANS_FOR_HOST = "SELECT\t\tHOST2FABRIC.PREFIX_ID PREFIX_ID,\t\tHOST2FABRIC.HOST_ID HOST_ID,\t    HOST2FABRIC.FABRIC_ID FABRIC_ID FROM T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE \t\t? = HOST2FABRIC.PREFIX_ID and \t    ? = HOST2FABRIC.HOST_ID ";
    public static String SELECT_SANS_FROM_ARRAY_FROM_HOST = "SELECT     SUBSYSTEM2FABRIC.FABRIC_ID,     SUBSYSTEM2FABRIC.PREFIX_ID, \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC, T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM WHERE     SUBSYSTEM2FABRIC.PREFIX_ID = HOST2SUBSYSTEM.SUBSYSTEM_PREFIX_ID and \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID = HOST2SUBSYSTEM.SUBSYSTEM_ID and     HOST2SUBSYSTEM.PREFIX_ID = ? and \t HOST2SUBSYSTEM.HOST_ID = ?";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_HOST = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VHOST2PORT HOST2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE    HOST2PORT.PREFIX_ID = ? and    HOST2PORT.HOST_ID = ? and \tHOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_HOST = "SELECT DISTINCT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZONE, T_RES_FABRIC FABRIC WHERE \t HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_HOST = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM T_VIEW_VHOST2PORT HOST2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID left outer join T_RES_PORT PORT on  \t PORT2ZONE2.PORT_ID = PORT.PORT_ID WHERE     HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID  ";
    public static final String SELECT_ZSET2ZONE_FROM_HOST = "SELECT DISTINCT     PORT2ZONE.ZONE_ID ZONE_ID,     ZSET2ZONE.ZSET_ID ZSET_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZONE PORT2ZONE, \tT_RES_ZSET2ZONE ZSET2ZONE WHERE \t HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_HOST = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VHOST2PORT HOST2PORT, T_VIEW_PORT2ZSET PORT2ZSET,     T_RES_ZSET, T_RES_FABRIC FABRIC WHERE \t HOST2PORT.PREFIX_ID = ? and \t HOST2PORT.HOST_ID = ? and     HOST2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_VOLGROUP_FROM_HOST = "SELECT distinct \tT_RES_VOLGROUP.VOLGROUP_ID, \tT_RES_VOLGROUP.NAME NAME, \tT_RES_VOLGROUP.FREESPACE, \tT_RES_VOLGROUP.CAPACITY, \tT_RES_VOLGROUP.VOLGROUP_TYPE   FROM \tT_RES_VOLGROUP WHERE \t\tT_RES_VOLGROUP.COMPUTER_ID = ? ";
    public static final String DISK2VOLGROUP = "(SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP ";
    public static final String SELECT_LVM2LOGICALS_FROM_HOST = "SELECT \tLOGICALDISKS.VOLGROUP_ID, \tLOGICALDISKS.LOGICAL_DISK_ID, \tLOGICALDISKS.MOUNT_POINT, \tLOGICALDISKS.FILESYSTEM_ID, \tLOGICALDISKS.NAME FROM (SELECT distinct \tf.computer_id, \tDISK2VOLGROUP.volgroup_id, \tf.logical_disk_id, \tf.mount_point, \tf.filesystem_id,  \t'' name FROM \tt_res_chunk c, t_res_filesystem f, (SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP WHERE    DISK2VOLGROUP.DEVICE_ID = c.disk_id and \tc.logical_disk_id = f.logical_disk_id UNION ALL SELECT distinct \tf.computer_id, \tDISK2VOLGROUP.volgroup_id, \tf.logical_disk_id, \tf.mount_point, \tf.filesystem_id,  \t'' name FROM \tt_res_chunk c, t_res_filesystem f, t_res_logical_disk l, (SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP WHERE    DISK2VOLGROUP.device_id = c.disk_id and \tc.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id > 0    and l.parent_logdisk_id = f.logical_disk_id UNION ALL SELECT distinct \ts.computer_id, \tDISK2VOLGROUP.volgroup_id, \tc.logical_disk_id, \ts.path mount_point, \tCAST(NULL AS INTEGER) filesystem_id, \ts.name FROM \tt_res_chunk c, t_res_share s, t_res_logical_disk l, (SELECT \td.device_id, \tx.volgroup_id  FROM \tt_res_dev_access d, \tt_res_share s, \tt_res_controller c,       \tt_stat_disk x WHERE \ts.resource_type = 10 and \ts.resource_id = d.device_id and \ts.computer_id = c.computer_id and \td.device_id   = x.disk_id   and \td.controller_id = c.controller_id) DISK2VOLGROUP WHERE    DISK2VOLGROUP.device_id = c.disk_id and \tc.logical_disk_id = s.resource_id    and c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id = -1    and l.logical_disk_id not in   (select logical_disk_id from t_res_filesystem) ) LOGICALDISKS WHERE \tLOGICALDISKS.COMPUTER_ID = ?";
    public static final String SELECT_LUN2LOGICAL_FROM_HOST = "SELECT \tLOGICALDISKS.DISK_ID, \tLOGICALDISKS.LOGICAL_DISK_ID FROM (SELECT distinct \tf.computer_id, \tc.disk_id  , \tf.logical_disk_id FROM \tt_res_chunk c, t_res_filesystem f WHERE    c.logical_disk_id = f.logical_disk_id UNION ALL SELECT distinct \tf.computer_id, \tc.disk_id , \tf.logical_disk_id FROM \tt_res_chunk c, t_res_filesystem f, t_res_logical_disk l WHERE    c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id > 0    and l.parent_logdisk_id = f.logical_disk_id UNION ALL SELECT distinct \ts.computer_id, \tc.disk_id, \tc.logical_disk_id FROM \tt_res_chunk c, t_res_share s, t_res_logical_disk l WHERE    c.logical_disk_id = s.resource_id    and c.logical_disk_id = l.logical_disk_id    and l.parent_logdisk_id = -1    and l.logical_disk_id not in   (select logical_disk_id from t_res_filesystem) ) LOGICALDISKS WHERE \tLOGICALDISKS.COMPUTER_ID = ?";
    public static final String SELECT_LUN_FROM_HOST = "SELECT distinct     LUN2HOST.PREFIX_ID PREFIX_ID,    LUN2HOST.HOST_ID HOST_ID,     LUN2HOST.TARGET_ID, \tLUN2HOST.DEVICE_LUN_ID DEVICE_LUN_ID,    LUN2HOST.VOLUME_ID VOLUME_ID, \tLUN2HOST.PATH,   \tLUN2HOST.DEVICE_ID,\tLUN2HOST.CAPACITY, \tLUN2HOST.FREE_SPACE,\tLUN2HOST.CONSOLIDATED_STATUS,\tLUN2HOST.OPERATIONAL_STATUS  FROM  (SELECT DISTINCT   \t 'server:' PREFIX_ID,   \t COMPUTER.COMPUTER_ID HOST_ID,     ACCESS.TARGET TARGET_ID, \t ACCESS.LUN DEVICE_LUN_ID,   \t VOLUME.SVID VOLUME_ID,  \t ACCESS.PATH PATH,   \t ACCESS.DEVICE_ID,\t (DISK_HIST.CAPACITY * 512) CAPACITY, \t (DISK_HIST.FREE_SPACE * 512) FREE_SPACE,\t VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS,\t VOLUME.OPERATIONAL_STATUS  FROM   \tT_RES_HOST COMPUTER,     T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME   \tleft outer join T_RES_STORAGE_VOLUME VOLUME on   \t\tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) \t \t= lower(VOLUME.UNIQUE_ID),    T_RES_DEV_ACCESS ACCESS left outer join T_STAT_DISK_HIST DISK_HIST on \tACCESS.DEVICE_ID = DISK_HIST.DISK_ID and \tDISK_HIST.STATISTIC_TYPE = '3',     T_RES_CONTROLLER CONTROLLER WHERE       PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION (SELECT DISTINCT   \t HOST.PREFIX_ID,   \t HOST.COMPUTER_ID HOST_ID,   \t CAST(NULL AS INTEGER) TARGET_ID, \t DATA_PATH.DEVICE_LUN_ID DEVICE_LUN_ID,   \t DATA_PATH.VOLUME_ID VOLUME_ID,   \t RTRIM(CAST(DATA_PATH.DEVICE_LUN_ID as CHAR(10))) PATH,  \t CAST(NULL as INTEGER) DEVICE_ID,\t (VOLUME.CAPACITY*512) CAPACITY,\t CAST(NULL AS INTEGER) FREE_SPACE, \t VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS,\t VOLUME.OPERATIONAL_STATUS FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT, T_RES_STORAGE_VOLUME VOLUME, (SELECT DISTINCT   \tHOST.PREFIX_ID,  \tHOST.COMPUTER_ID HOST_ID,   \tDATA_PATH.VOLUME_ID VOLUME_ID FROM   \tT_RES_DATA_PATH DATA_PATH,     \tT_VIEW_VHOST HOST, T_VIEW_VHOST2PORT HOST2PORT WHERE   \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID  EXCEPT SELECT DISTINCT       'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID, \t VOLUME.SVID VOLUME_ID FROM   \tT_RES_HOST COMPUTER,     T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME   \tleft outer join T_RES_STORAGE_VOLUME VOLUME on   \t\tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) \t \t= lower(VOLUME.UNIQUE_ID),    T_RES_DEV_ACCESS ACCESS,     T_RES_CONTROLLER CONTROLLER WHERE       PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND     CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID) HOST2DATAPATH_IN WHERE   \tHOST2DATAPATH_IN.PREFIX_ID = HOST.PREFIX_ID and \tHOST2DATAPATH_IN.HOST_ID = HOST.COMPUTER_ID and  \tHOST2DATAPATH_IN.VOLUME_ID = DATA_PATH.VOLUME_ID and \tHOST.PREFIX_ID = HOST2PORT.PREFIX_ID and   \tHOST.COMPUTER_ID = HOST2PORT.HOST_ID and   \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and \tDATA_PATH.VOLUME_ID = VOLUME.SVID )) LUN2HOST WHERE  \t ? = LUN2HOST.PREFIX_ID and \t ? = LUN2HOST.HOST_ID";
    public static final String SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\tSUBSYSTEM2HOST.PREFIX_ID HOST_PREFIX_ID, \tSUBSYSTEM2HOST.HOST_ID, \tSUBSYSTEM2HOST.VOLUME_ID FROM (SELECT DISTINCT \t'server:' PREFIX_ID, \tCOMPUTER.COMPUTER_ID HOST_ID,  \tVOLUME.SVID VOLUME_ID, \tVOLUME.SUBSYSTEM_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME WHERE  \tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) = lower(VOLUME.UNIQUE_ID) and    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \t HOST2PORT.PREFIX_ID, \t HOST2PORT.HOST_ID HOST_ID, \t DATA_PATH.VOLUME_ID VOLUME_ID, \t DATA_PATH.SUBSYSTEM_ID FROM \tT_RES_DATA_PATH DATA_PATH,   \tT_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID )  SUBSYSTEM2HOST, T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE \t ? = SUBSYSTEM2HOST.PREFIX_ID and \t ? = SUBSYSTEM2HOST.HOST_ID and \t SUBSYSTEM2HOST.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and \t T_RES_STORAGE_SUBSYSTEM.PREFIX_ID = 'subsystem:' ";
    public static final String SELECT_VOLUMES_FROM_HOST = "SELECT distinct     VOLUMES2HOST.PREFIX_ID, \t VOLUMES2HOST.HOST_ID HOST_ID,     CASE WHEN T_RES_STORAGE_VOLUME.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_STORAGE_VOLUME.DISPLAY_NAME) != '' THEN T_RES_STORAGE_VOLUME.DISPLAY_NAME \t\t  WHEN T_RES_STORAGE_VOLUME.SVID IS NOT NULL THEN CAST(T_RES_STORAGE_VOLUME.SVID as CHAR) \t END DISPLAY_NAME, T_RES_STORAGE_VOLUME.SVID SVID, T_RES_STORAGE_VOLUME.NAME || '+' || CAST(T_RES_STORAGE_VOLUME.NAME_FORMAT as CHAR) NATURAL_KEY, (T_RES_STORAGE_VOLUME.CAPACITY*512) CAPACITY, T_RES_STORAGE_VOLUME.POOL_ID POOL_ID, T_RES_STORAGE_VOLUME.FORMAT FORMAT, T_RES_STORAGE_VOLUME.IS_ASSIGNED IS_ASSIGNED, T_RES_STORAGE_VOLUME.USER_ATTRIB1 USER_ATTRIB1, T_RES_STORAGE_VOLUME.USER_ATTRIB2 USER_ATTRIB2, T_RES_STORAGE_VOLUME.USER_ATTRIB3 USER_ATTRIB3, T_RES_STORAGE_VOLUME.DETECTABLE DETECTABLE, T_RES_STORAGE_VOLUME.OPERATIONAL_STATUS OPERATIONAL_STATUS, T_RES_STORAGE_VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS  FROM (SELECT DISTINCT \t 'server:' PREFIX_ID, \t COMPUTER.COMPUTER_ID HOST_ID,     VOLUME.SVID VOLUME_ID FROM \tT_RES_HOST COMPUTER,    T_RES_PHYSICAL_VOLUME PHYSICAL_VOLUME,    T_RES_DEV_ACCESS ACCESS,    T_RES_CONTROLLER CONTROLLER, \tT_RES_STORAGE_VOLUME VOLUME  WHERE  \tlower(PHYSICAL_VOLUME.SUBSYSTEM_SERIAL_NUMBER || '/' || PHYSICAL_VOLUME.SERIAL_NUMBER) = lower(VOLUME.UNIQUE_ID) and    PHYSICAL_VOLUME.PHYSICAL_VOLUME_ID = ACCESS.DEVICE_ID AND    ACCESS.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID AND    CONTROLLER.COMPUTER_ID = COMPUTER.COMPUTER_ID UNION SELECT DISTINCT \tHOST2PORT.PREFIX_ID, \tHOST2PORT.HOST_ID HOST_ID, \tDATA_PATH.VOLUME_ID VOLUME_ID FROM \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,  \tT_VIEW_VHOST2PORT HOST2PORT WHERE \tHOST2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID ) VOLUMES2HOST,     T_RES_STORAGE_VOLUME WHERE \t ? = VOLUMES2HOST.PREFIX_ID and \t ? = VOLUMES2HOST.HOST_ID and \t T_RES_STORAGE_VOLUME.SVID = VOLUMES2HOST.VOLUME_ID";
    public static final String SELECT_FILESYSTEM_FROM_HOST = "SELECT distinct   \tT_RES_FILESYSTEM.FILESYSTEM_ID, \tT_RES_FILESYSTEM.LOGICAL_DISK_ID, \tT_RES_FILESYSTEM.MOUNT_POINT,   \tT_RES_FILESYSTEM.CAPACITY,     \tT_RES_FILESYSTEM.FILESYSTEM_TYPE,    \tT_RES_FILESYSTEM.FREE_SPACE,   \tT_RES_FILESYSTEM.PHYSICAL_SIZE FROM   \tT_RES_HOST HOST, T_RES_FILESYSTEM WHERE  \t? = HOST.COMPUTER_ID AND \tHOST.COMPUTER_ID = T_RES_FILESYSTEM.COMPUTER_ID ";
    public static final String SELECT_LOGICAL_VOLUME_FROM_HOST = "select \tLOGICAL.logical_disk_id, \tSHARE.path  from \tT_RES_SHARE SHARE, T_RES_LOGICAL_DISK LOGICAL where \tSHARE.computer_id = ?   and \tSHARE.resource_type = 11   and \tSHARE.resource_id = LOGICAL.logical_disk_id ";
    public static final String SELECT_LOGICAL2LOGICAL_FROM_HOST = "select \tPLOGICAL.logical_disk_id PARENT_DISK_ID, \tCLOGICAL.LOGICAL_DISK_ID CHILD_DISK_ID  from \tT_RES_SHARE SHARE, T_RES_LOGICAL_DISK PLOGICAL, T_RES_LOGICAL_DISK CLOGICAL where \tSHARE.computer_id = ?   and \tSHARE.resource_type = 11   and \tSHARE.resource_id = PLOGICAL.logical_disk_id and \tPLOGICAL.LOGICAL_DISK_ID = CLOGICAL.PARENT_LOGDISK_ID";
    public static final String SELECT_FILESYSTEM_SIMPLE_FROM_LUN = "SELECT distinct   \tFS.FILESYSTEM_ID,\tDEVICE.DEVICE_ID FROM   \tT_RES_HOST HOST, T_RES_DEV_ACCESS DEVICE, T_STAT_DISK STATDISK,   \tT_RES_FILESYSTEM FS, T_RES_CHUNK CHUNK, T_RES_SHARE SHARE, T_RES_CONTROLLER CONTROLLER WHERE  \t? = HOST.COMPUTER_ID and \tHOST.COMPUTER_ID = CONTROLLER.COMPUTER_ID and\tCONTROLLER.CONTROLLER_ID = DEVICE.CONTROLLER_ID and   \tDEVICE.DEVICE_ID = STATDISK.DISK_ID and  \tSTATDISK.DISK_ID = CHUNK.DISK_ID and   \tHOST.COMPUTER_ID = FS.COMPUTER_ID and   \tFS.LOGICAL_DISK_ID = CHUNK.LOGICAL_DISK_ID and  \tSHARE.RESOURCE_ID = CHUNK.lOGICAL_DISK_ID ";
    private static final String SELECT_FILESYSTEM_COMPOUND_FROM_LUN_FROM_HOST = "SELECT distinct \tf.filesystem_id, \tf.logical_disk_id, \td.disk_id, \tf.mount_point, \tf.capacity, \tf.free_space, \tf.filesystem_id, \ta.path, \ts1.name, \ts1.path, \td.capacity FROM  t_res_filesystem f, t_res_host c2, t_res_share s1, t_res_logical_disk l2, t_res_logical_disk l, t_res_chunk h, t_stat_disk d, t_res_dev_access a  , t_res_vendor vendor  , (select   distinct c.computer_id     , pv.physical_volume_id      , pv.serial_number lun_id     , sv.svid  from     t_res_host c     , t_res_physical_volume pv left outer join t_res_storage_volume sv on \tlower(pv.subsystem_serial_number || '/' || pv.serial_number) = lower(sv.unique_id)     , t_res_dev_access da      , t_res_controller ctl where        pv.physical_volume_id = da.device_id      and da.controller_id = ctl.controller_id     and ctl.computer_id = c.computer_id) \t ssluncmp  where (l2.parent_logdisk_id <= 0) and (f.logical_disk_id = l2.logical_disk_id) and (l.parent_logdisk_id = l2.logical_disk_id) and (l.parent_logdisk_id = f.logical_disk_id) and (h.logical_disk_id = l.logical_disk_id) and (c2.computer_id = f.computer_id) and (d.disk_id = h.disk_id) and (a.device_id = d.disk_id) and (a.device_id = h.disk_id) and c2.computer_id = ?";
    public static final String SELECT_LVM_FROM_HOST = "SELECT \tT_RES_VOLGROUP.VOLGROUP_ID, \tT_RES_VOLGROUP.NAME NAME, \tT_RES_VOLGROUP.FREESPACE, \tT_RES_VOLGROUP.CAPACITY, \tT_RES_VOLGROUP.VOLGROUP_TYPE  FROM \tT_RES_VOLGROUP WHERE \tT_RES_VOLGROUP.COMPUTER_ID = ?";
    public static final String SELECT_LOGICALS_FROM_HOST = "SELECT \tT_RES_LOGICAL_DISK.LOGICAL_DISK_ID,\tT_RES_SHARE.PATH FROM \tT_RES_LOGICAL_DISK, t_res_chunk CHUNK, T_RES_SHARE  WHERE \tCHUNK.LOGICAL_DISK_ID = T_RES_SHARE.RESOURCE_ID and \tCHUNK.LOGICAL_DISK_ID = T_RES_LOGICAL_DISK.LOGICAL_DISK_ID and \tT_RES_SHARE.COMPUTER_ID = ?";
    public static final String SELECT_DISKS_FROM_LVM_FROM_HOST = "SELECT\tDEVICE.DEVICE_ID, DISK.volgroup_id  FROM \tT_RES_DEV_ACCESS DEVICE, T_RES_SHARE SHARE, T_RES_CONTROLLER CONTROLLER, \tT_STAT_DISK DISK WHERE \tSHARE.COMPUTER_ID = ? and \tSHARE.RESOURCE_TYPE = 10 and \tSHARE.RESOURCE_ID = DEVICE.DEVICE_ID and \tSHARE.COMPUTER_ID = CONTROLLER.computer_id and \tDEVICE.DEVICE_ID   = DISK.DISK_ID   and \tDEVICE.CONTROLLER_ID = CONTROLLER.CONTROLLER_ID ";
    public static final String SELECT_RDBMS_FROM_HOST = "SELECT \tT_RES_RDBMS.RDBMS_ID,\tT_RES_RDBMS.RDBMS_NAME, \tT_RES_RDBMS.RDBMS_TYPE FROM \tT_RES_RDBMS  WHERE \tT_RES_RDBMS.COMPUTER_ID = ?";
    public static final String SELECT_DATABASES_FROM_HOST = "SELECT \tRDBMS.RDBMS_ID, \tT_RES_DATABASE.DATABASE_ID,\tT_RES_DATABASE.NAME FROM \tT_RES_DATABASE, T_RES_RDBMS RDBMS  WHERE \tT_RES_DATABASE.RDBMS_ID = RDBMS.RDBMS_ID and \tRDBMS.COMPUTER_ID = ?";
    public static final String SELECT_TABLESPACE_FROM_HOST = "SELECT \tDATABASE.DATABASE_ID, \tT_RES_TABLESPACE.TABLESPACE_ID,\tT_RES_TABLESPACE.NAME FROM \tT_RES_TABLESPACE, T_RES_DATABASE DATABASE, T_RES_RDBMS RDBMS  WHERE \tT_RES_TABLESPACE.DATABASE_ID = DATABASE.DATABASE_ID and \tDATABASE.RDBMS_ID = RDBMS.RDBMS_ID and \tRDBMS.COMPUTER_ID = ?";
    public static final String SELECT_TABLESPACE2LOGICAL_FROM_HOST = "SELECT \tTS2LOGICAL.TABLESPACE_ID, \tTS2LOGICAL.LOGICAL_DISK_ID, \tTS2LOGICAL.COMPUTER_ID FROM (SELECT \tTABLESPACE.TABLESPACE_ID, \tSHARE.RESOURCE_ID LOGICAL_DISK_ID, \tRDBMS.COMPUTER_ID FROM \tT_RES_DATABASE DATABASE, T_RES_RDBMS RDBMS, T_RES_TABLESPACE TABLESPACE, T_RES_DATAFILE DATAFILE,\tT_RES_SHARE SHARE  WHERE \t(DATAFILE.NAME = '\\.'|| SHARE.PATH  OR \tDATAFILE.NAME = SHARE.PATH \t) and \tSHARE.COMPUTER_ID = RDBMS.COMPUTER_ID and \tDATAFILE.FILESYSTEM_ID = -1 and \tDATAFILE.TABLESPACE_ID = TABLESPACE.TABLESPACE_ID and \tTABLESPACE.DATABASE_ID = DATABASE.DATABASE_ID and \tDATABASE.RDBMS_ID = RDBMS.RDBMS_ID  ) TS2LOGICAL WHERE \tTS2LOGICAL.COMPUTER_ID = ?";
    public static final String SELECT_TABLESPACE2FILESYSTEM_FROM_HOST = "SELECT \tTABLESPACE.TABLESPACE_ID, \tDATAFILE.FILESYSTEM_ID FROM \tT_RES_DATABASE DATABASE, T_RES_RDBMS RDBMS, T_RES_TABLESPACE TABLESPACE, T_RES_DATAFILE DATAFILE  WHERE \tDATAFILE.FILESYSTEM_ID != -1 and \tDATAFILE.TABLESPACE_ID = TABLESPACE.TABLESPACE_ID and \tTABLESPACE.DATABASE_ID = DATABASE.DATABASE_ID and \tDATABASE.RDBMS_ID = RDBMS.RDBMS_ID and \tRDBMS.COMPUTER_ID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphComputer getHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, int hostId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("host...");
        }
        GraphComputer gHost = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_HOST);
            stmt.setString(1, prefixId);
            stmt.setInt(2, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostIdNew = (Integer)resultSet.getObject("HOST_ID");
                if (hostIdNew == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Host ID is NULL");
                    continue;
                }
                String hostKey = prefixId + hostIdNew;
                if (entityMap == null || entityMap.get(hostKey) == null) {
                    gHost = new GraphComputer(hostKey);
                    this.populator.populateHost(resultSet, gHost);
                    if (model != null) {
                        model.put(gHost);
                    }
                    if (entityMap == null) continue;
                    entityMap.put(hostKey, gHost);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Duplicated Host entry:" + hostKey);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("array totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        return gHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHBAs(Connection con, GraphModel model, HashMap entityMap, int hostId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("hba...");
        }
        GraphHBA gHBA = null;
        String hostKey = "server:" + hostId;
        GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_HBA_FROM_HOST);
            stmt.setInt(1, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer hbaId = (Integer)resultSet.getObject("HBA_ID");
                if (hbaId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHBAs", "HBA ID is NULL");
                    continue;
                }
                String hbaKey = "hba:" + hbaId;
                if (entityMap == null || entityMap.get(hbaKey) == null) {
                    gHBA = new GraphHBA(hbaKey);
                    this.populator.populateHBA(resultSet, gHBA, true);
                    if (model != null) {
                        model.put(gHBA);
                    }
                    if (entityMap != null) {
                        entityMap.put(hbaKey, gHBA);
                    }
                    GraphComputer2HBA gHost2hba = new GraphComputer2HBA(hbaKey);
                    gHost2hba.setHBAID((GraphHBA.ID)gHBA.getEntityID());
                    gHost2hba.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    model.put(gHost2hba);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getHBAs", "Duplicated HBA entry:subsystem:" + hostId);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHBAs", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHBAs", e);
                }
            }
        }
        if (debug) {
            System.out.println("HBA totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPorts(Connection con, GraphModel model, HashMap entityMap, String prefixId, int hostId) throws SQLException {
        Integer portID;
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("ports...");
        }
        String serverKey = prefixId + hostId;
        GraphComputer gHost = (GraphComputer)entityMap.get(serverKey);
        GraphFCPort gPort = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_PORT_FROM_HOST);
            stmt.setString(1, prefixId);
            stmt.setInt(2, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer hbaId;
                portID = (Integer)resultSet.getObject("PORT_ID");
                if (portID == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "PORT_ID is NULL");
                    continue;
                }
                String portKey = "Port:" + portID;
                if (entityMap == null || entityMap.get(portKey) == null) {
                    gPort = new GraphFCPort(portKey);
                    this.populator.populatePort(resultSet, gPort);
                    if (model != null) {
                        model.put(gPort);
                    }
                    if (entityMap != null) {
                        entityMap.put(portKey, gPort);
                    }
                    String host2portKey = "server2port:" + serverKey + ',' + portID;
                    GraphComputer2FCPort gHost2port = new GraphComputer2FCPort(host2portKey);
                    gHost2port.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    gHost2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                    model.put(gHost2port);
                    entityMap.put(host2portKey, gHost2port);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Duplicated PORT entry:" + portKey);
                }
                if ((hbaId = (Integer)resultSet.getObject("HBA_ID")) == null) continue;
                String hba2portKey = "hba2port:" + hbaId + ',' + portID;
                if (entityMap.get(hba2portKey) == null) {
                    String hbaKey = "hba:" + hbaId;
                    GraphHBA gHba = (GraphHBA)entityMap.get(hbaKey);
                    if (gHba != null) {
                        GraphHBA2FCPort hba2port = new GraphHBA2FCPort(hba2portKey);
                        hba2port.setHBAID((GraphHBA.ID)gHba.getEntityID());
                        hba2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                        model.put(hba2port);
                        entityMap.put(hba2portKey, hba2port);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Missing HBA entry:" + hbaKey);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Duplicated HBA2PORT entry:" + hba2portKey);
            }
        }
        finally {
            block46: {
                block45: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block45;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block46;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", e);
                }
            }
        }
        if (debug) {
            System.out.println("Port totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_PORT2PORT_FROM_HOST);
            stmt.setString(1, prefixId);
            stmt.setInt(2, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                GraphFCPort gPort2;
                portID = (Integer)resultSet.getObject("PORT1_ID");
                String portName1 = (String)resultSet.getObject("PORT1_NAME");
                Integer portID2 = (Integer)resultSet.getObject("PORT2_ID");
                String portNumber1 = (String)resultSet.getObject("PORT_NUMBER1");
                String portNumber2 = (String)resultSet.getObject("PORT_NUMBER2");
                String portName2 = (String)resultSet.getObject("PORT2_NAME");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String prefixID = (String)resultSet.getObject("PREFIX_ID");
                Integer entityId = (Integer)resultSet.getObject("ENTITY_ID");
                if (portID == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "PORT_ID is NULL");
                    continue;
                }
                String portKey1 = "Port:" + portID;
                String portKey2 = "Port:" + portID2;
                gPort = (GraphFCPort)entityMap.get(portKey1);
                if (gPort == null) {
                    gPort = new GraphFCPort(portKey1);
                    gPort.setDisplayName(portName1);
                    gPort.setPortNumber(portNumber1);
                    model.put(gPort);
                    entityMap.put(portKey1, gPort);
                }
                if ((gPort2 = (GraphFCPort)entityMap.get(portKey2)) == null) {
                    gPort2 = new GraphFCPort(portKey2);
                    gPort2.setDisplayName(portName2);
                    gPort2.setPortNumber(portNumber2);
                    model.put(gPort2);
                    entityMap.put(portKey2, gPort2);
                }
                if (gPort2 == null || gPort == null) continue;
                String port2portKey = "port2port:" + prefixId + hostId + ',' + prefixID + entityId + ',' + port2portId;
                if (entityMap.get(port2portKey) == null) {
                    GraphFCPort2FCPort fcport2fcport = new GraphFCPort2FCPort(port2portKey);
                    fcport2fcport.setFCPort1ID((GraphFCPort.ID)gPort.getEntityID());
                    fcport2fcport.setFCPort2ID((GraphFCPort.ID)gPort2.getEntityID());
                    this.populator.populatePort2Port(resultSet, fcport2fcport);
                    model.put(fcport2fcport);
                    entityMap.put(port2portKey, fcport2fcport);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                if (gPort2 == null) {
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Missing port entry:" + portKey1);
                    continue;
                }
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPorts", "Missing port entry:" + portKey1);
            }
        }
        finally {
            block49: {
                block48: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block48;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block49;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPorts", e);
                }
            }
        }
        if (debug) {
            System.out.println("Port totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixID, int hostId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("Switch...");
        }
        GraphSwitch gSwitch = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_SWITCH_FROM_HOST);
            stmt.setString(1, prefixID);
            stmt.setInt(2, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitch", "SWITCH_WWN is NULL");
                    continue;
                }
                String switchKey = prefixId + switchId;
                if (entityMap == null || entityMap.get(switchKey) == null) {
                    gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    if (model != null) {
                        model.put(gSwitch);
                    }
                    if (entityMap != null) {
                        entityMap.put(switchKey, gSwitch);
                    }
                }
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                String portKey = "Port:" + portId;
                GraphFCPort gPort = (GraphFCPort)entityMap.get(portKey);
                if (gPort == null) continue;
                String switch2portKey = "switch2fcport:" + switchKey + ',' + portId;
                GraphSwitch2FCPort switch2port = new GraphSwitch2FCPort(switch2portKey);
                switch2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                switch2port.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                model.put(switch2port);
                entityMap.put(switch2portKey, switch2port);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
        if (debug) {
            System.out.println("Switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSubsystemFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixID, int hostId) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("subsystem...");
        }
        GraphSubsystem gArray = null;
        boolean i = false;
        try {
            stmt = con.prepareStatement(SELECT_DIRECTLY_ATTACHED_SUBSYSTEM_FROM_HOST);
            stmt.setString(1, prefixID);
            stmt.setInt(2, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (subsystemId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "SUBSYSTEM_ID is NULL");
                    continue;
                }
                String arrayKey = prefixId + subsystemId;
                if (entityMap == null || entityMap.get(arrayKey) == null) {
                    gArray = new GraphSubsystem(arrayKey);
                    this.populator.populateSubsystem(resultSet, gArray);
                    if (model != null) {
                        model.put(gArray);
                    }
                    if (entityMap != null) {
                        entityMap.put(arrayKey, gArray);
                    }
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSubsystem", "Duplicated Subsystem entry:subsystem:" + hostId);
                }
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                String portKey = "Port:" + portId;
                GraphFCPort gPort = (GraphFCPort)entityMap.get(portKey);
                if (gPort == null) continue;
                String array2portKey = "subsystem2fcport:" + arrayKey + ',' + portId;
                GraphSubsystem2FCPort array2port = new GraphSubsystem2FCPort(array2portKey);
                array2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                array2port.setSubsystemID((GraphSubsystem.ID)gArray.getEntityID());
                model.put(array2port);
                entityMap.put(array2portKey, array2port);
            }
        }
        finally {
            block24: {
                block23: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block23;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block24;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("subsystem totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
    }

    public void getZonesFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, int switchId) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(con, model, entityMap, new Object[]{prefixId, new Integer(switchId)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_HOST, SELECT_ZONES_FROM_HOST, SELECT_ZSET_FROM_HOST, SELECT_ZSET2ZONE_FROM_HOST, SELECT_ZONE2MEMBER_FROM_HOST});
    }

    public void getZonesFromEntitiesConnectedToHost(Connection con, GraphModel model, HashMap entityMap, int switchId) throws SQLException {
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHost2VolumeFromHost(Connection srmConnection, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        Integer hostId;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("host2volume ...");
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_VOLUMES_FROM_HOST);
            stmt.setString(1, prefix);
            stmt.setInt(2, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String hostPrefixId = (String)resultSet.getObject("PREFIX_ID");
                hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer volumeId = (Integer)resultSet.getObject("SVID");
                if (volumeId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String hostKey = hostPrefixId + hostId;
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + hostKey);
                    continue;
                }
                String volumeKey = "volume:" + volumeId;
                GraphVolume gVolume = (GraphVolume)entityMap.get(volumeKey);
                if (gVolume == null) {
                    gVolume = new GraphVolume(volumeKey);
                    this.populator.populateStorageVolume(resultSet, gVolume);
                    entityMap.put(volumeKey, gVolume);
                    model.put(gVolume);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + volumeKey);
                }
                String server2volumeKey = "server2volume:" + hostId + ',' + volumeId;
                if (entityMap.get(server2volumeKey) == null) {
                    GraphComputer2Volume gServer2volume = new GraphComputer2Volume(server2volumeKey);
                    gServer2volume.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    gServer2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    model.put(gServer2volume);
                    entityMap.put(server2volumeKey, gServer2volume);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + server2volumeKey);
            }
        }
        finally {
            block49: {
                block48: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block48;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block49;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", e);
                }
            }
        }
        if (debug) {
            System.out.println("host2volume totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (debug) {
            System.out.println("host2volume ...");
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_ARRAYS_FROM_VOLUMES_FROM_HOST);
            stmt.setString(1, prefix);
            stmt.setInt(2, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                GraphVolume gVolume;
                String prefixId = (String)resultSet.getObject("HOST_PREFIX_ID");
                hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer subsystemId = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                String hostKey = prefixId.toString() + hostId;
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + hostKey);
                    continue;
                }
                if (subsystemId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String subsystemKey = "subsystem:" + subsystemId;
                String volumeKey = "volume:" + volumeId;
                GraphSubsystem gSubsystem = (GraphSubsystem)entityMap.get(subsystemKey);
                if (gSubsystem == null) {
                    gSubsystem = new GraphSubsystem(subsystemKey);
                    this.populator.populateSubsystem(resultSet, gSubsystem);
                    entityMap.put(subsystemKey, gSubsystem);
                    model.put(gSubsystem);
                }
                if ((gVolume = (GraphVolume)entityMap.get(volumeKey)) != null) {
                    String array2volumeKey = "subsystem2volume:" + subsystemId + ',' + volumeId;
                    GraphSubsystem2Volume array2volume = new GraphSubsystem2Volume(array2volumeKey);
                    array2volume.setSubsystemID((GraphSubsystem.ID)gSubsystem.getEntityID());
                    array2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    entityMap.put(array2volumeKey, array2volume);
                    model.put(array2volume);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + subsystemKey);
                }
                String server2volumeKey = "server2volume:" + hostId + ',' + subsystemId;
                if (entityMap.get(server2volumeKey) == null) {
                    GraphComputer2Volume gServer2volume = new GraphComputer2Volume(server2volumeKey);
                    gServer2volume.setComputerID((GraphComputer.ID)gHost.getEntityID());
                    gServer2volume.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                    model.put(gServer2volume);
                    entityMap.put(server2volumeKey, gServer2volume);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + server2volumeKey);
            }
        }
        finally {
            block52: {
                block51: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block51;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block52;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", e);
                }
            }
        }
        if (debug) {
            System.out.println("host2volume totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLUN(Connection con, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("subsystem...");
        }
        Object gArray = null;
        boolean i = false;
        if (debug) {
            System.out.println("Pools...");
        }
        Object gPool = null;
        i = false;
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("lun...");
        }
        gArray = null;
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_LUN_FROM_HOST);
            stmt.setString(1, prefix);
            stmt.setInt(2, id);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer volumeId = (Integer)resultSet.getObject("VOLUME_ID");
                String hostPrefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer hostId = (Integer)resultSet.getObject("HOST_ID");
                Integer lunId = (Integer)resultSet.getObject("DEVICE_LUN_ID");
                Integer deviceId = (Integer)resultSet.getObject("DEVICE_ID");
                String hostKey = hostPrefixId + hostId;
                String lunStr = "(" + volumeId + ',' + hostKey + ',' + deviceId + ',' + lunId + ")";
                String lunKey = "lun:" + lunStr;
                GraphLun gLun = new GraphLun(lunKey);
                this.populator.populateLUN(resultSet, gLun);
                GraphComputer gHost = (GraphComputer)entityMap.get(hostKey);
                if (gHost == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "Host not found: server:" + hostId);
                    continue;
                }
                GraphVolume gVolume = (GraphVolume)entityMap.get("volume:" + volumeId);
                model.put(gLun);
                entityMap.put(lunKey, gLun);
                String host2lunKey = "server2lun:" + hostKey + ',' + lunStr;
                GraphComputer2Lun host2lun = new GraphComputer2Lun(host2lunKey);
                host2lun.setLunID((GraphLun.ID)gLun.getEntityID());
                host2lun.setComputerID((GraphComputer.ID)gHost.getEntityID());
                model.put(host2lun);
                entityMap.put(host2lunKey, host2lun);
                if (gVolume == null) continue;
                String volume2lunKey = "lun2volume:" + volumeId + ',' + lunStr;
                GraphVolume2Lun volume2lun = new GraphVolume2Lun(volume2lunKey);
                volume2lun.setLunID((GraphLun.ID)gLun.getEntityID());
                volume2lun.setVolumeID((GraphVolume.ID)gVolume.getEntityID());
                model.put(volume2lun);
                entityMap.put(volume2lunKey, volume2lun);
            }
        }
        finally {
            block20: {
                block19: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block19;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block20;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLVM(Connection con, GraphModel model, HashMap entityMap, String prefix, int hostId) throws SQLException {
        GraphAssociation lvm2lun;
        String key;
        GraphLun gLun;
        String lvmKey;
        String logicalKey;
        Integer lvmId;
        Integer logicalId;
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("lvm...");
        }
        boolean i = false;
        if (debug) {
            System.out.println("logical...");
        }
        GraphLogicalVolumeManager gLVM = null;
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_LVM_FROM_HOST);
            stmt.setInt(1, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer lvmId2 = (Integer)resultSet.getObject("VOLGROUP_ID");
                String arrayKey = "lvm:" + lvmId2;
                if (entityMap != null && entityMap.get(arrayKey) != null) continue;
                gLVM = new GraphLogicalVolumeManager(arrayKey);
                this.populator.populateLVM(resultSet, gLVM);
                if (model != null) {
                    model.put(gLVM);
                }
                if (entityMap == null) continue;
                entityMap.put(arrayKey, gLVM);
            }
        }
        finally {
            block87: {
                block86: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block86;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block87;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        GraphLogicalVolume gLogical = null;
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_LOGICALS_FROM_HOST);
            stmt.setInt(1, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                logicalId = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                String logicalKey2 = "logvol:" + logicalId;
                if (entityMap != null && entityMap.get(logicalKey2) != null) continue;
                gLogical = new GraphLogicalVolume(logicalKey2);
                this.populator.populateLogicalVolume(resultSet, gLogical);
                if (model != null) {
                    model.put(gLogical);
                }
                if (entityMap == null) continue;
                entityMap.put(logicalKey2, gLogical);
            }
        }
        finally {
            block90: {
                block89: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block89;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block90;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_LVM2LOGICALS_FROM_HOST);
            stmt.setInt(1, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                logicalId = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                lvmId = (Integer)resultSet.getObject("VOLGROUP_ID");
                logicalKey = "logvol:" + logicalId;
                lvmKey = "lvm:" + lvmId;
                gLogical = (GraphLogicalVolume)entityMap.get(logicalKey);
                if (gLogical == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "logical volume not found: server:" + hostId);
                    continue;
                }
                gLVM = (GraphLogicalVolumeManager)entityMap.get(lvmKey);
                if (gLVM == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "volumeManager not found: server:" + hostId);
                    continue;
                }
                String key2 = "lvm2lv:" + lvmId + ',' + logicalId;
                GraphLogicalVolumeManager2LogicalVolume lvm2logical = new GraphLogicalVolumeManager2LogicalVolume(key2);
                lvm2logical.setLogicalVolumeManagerID(gLVM);
                lvm2logical.setLogicalVolumeID(gLogical);
                model.put(lvm2logical);
                entityMap.put(key2, lvm2logical);
            }
        }
        finally {
            block93: {
                block92: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block92;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block93;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_DISKS_FROM_LVM_FROM_HOST);
            stmt.setInt(1, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                Integer lunId = (Integer)resultSet.getObject("DEVICE_ID");
                lvmId = (Integer)resultSet.getObject("VOLGROUP_ID");
                String lunKey = "lun:" + lunId;
                lvmKey = "lvm:" + lvmId;
                gLun = (GraphLun)entityMap.get(lunKey);
                if (gLun == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getHostFromSubsystem", "LUN volume not found: server:" + hostId);
                    continue;
                }
                gLVM = (GraphLogicalVolumeManager)entityMap.get(lvmKey);
                if (gLVM == null) continue;
                key = "lvm2lun:" + lvmId + ',' + lunId;
                lvm2lun = new GraphLogicalVolumeManager2Lun(key);
                ((GraphLogicalVolumeManager2Lun)lvm2lun).setLogicalVolumeManagerID(gLVM);
                ((GraphLogicalVolumeManager2Lun)lvm2lun).setLunID(gLun);
                model.put(lvm2lun);
                entityMap.put(key, lvm2lun);
            }
        }
        finally {
            block96: {
                block95: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block95;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block96;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        i = false;
        try {
            stmt = con.prepareStatement(SELECT_LUN2LOGICAL_FROM_HOST);
            stmt.setInt(1, hostId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                logicalId = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                Integer lunId = (Integer)resultSet.getObject("DISK_ID");
                logicalKey = "logvol:" + logicalId;
                String lunKey = "lun:" + lunId;
                gLogical = (GraphLogicalVolume)entityMap.get(logicalKey);
                gLun = (GraphLun)entityMap.get(lunKey);
                key = "lun2logical:" + lunId + ',' + logicalId;
                lvm2lun = new GraphLogicalVolume2Lun(key);
                ((GraphLogicalVolume2Lun)lvm2lun).setLunID(gLun);
                ((GraphLogicalVolume2Lun)lvm2lun).setLogicalVolumeID(gLogical);
                model.put(lvm2lun);
                entityMap.put(key, lvm2lun);
            }
        }
        finally {
            block99: {
                block98: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block98;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "lvm", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block99;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("LVG totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFilesystems(Connection con, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("lvm...");
        }
        boolean i = false;
        if (debug) {
            System.out.println("logical...");
        }
        if ("server:".equals(prefix)) {
            Integer filesystemId;
            i = false;
            try {
                stmt = con.prepareStatement(SELECT_FILESYSTEM_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    filesystemId = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    String filesystemKey = "filesystem:" + filesystemId;
                    GraphFilesystem gFS = (GraphFilesystem)entityMap.get(filesystemKey);
                    if (gFS != null) continue;
                    gFS = new GraphFilesystem(filesystemKey);
                    this.populator.populateFileSystem(resultSet, gFS);
                    model.put(gFS);
                    entityMap.put(filesystemKey, gFS);
                }
            }
            finally {
                block50: {
                    block49: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block49;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block50;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            if (debug) {
                System.out.println("lun totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
            }
            i = false;
            try {
                stmt = con.prepareStatement(SELECT_FILESYSTEM_SIMPLE_FROM_LUN);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    String filesystemKey;
                    GraphFilesystem filesystem;
                    filesystemId = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    Integer deviceId = (Integer)resultSet.getObject("DEVICE_ID");
                    String lunKey = "lun:" + deviceId;
                    GraphLun gLun = (GraphLun)entityMap.get(lunKey);
                    if (gLun == null || (filesystem = (GraphFilesystem)entityMap.get(filesystemKey = "filesystem:" + filesystemId)) == null) continue;
                    String filesystem2lunKey = "fs2lun:" + filesystemId + ',' + deviceId;
                    GraphFilesystem2Lun filesystem2lun = new GraphFilesystem2Lun(filesystem2lunKey);
                    filesystem2lun.setFilesystemID(filesystem);
                    filesystem2lun.setLunID(gLun);
                    model.put(filesystem2lun);
                    entityMap.put(filesystem2lunKey, filesystem2lun);
                }
            }
            finally {
                block53: {
                    block52: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block52;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block53;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            if (debug) {
                System.out.println("lun totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
            }
            try {
                stmt = con.prepareStatement(SELECT_FILESYSTEM_COMPOUND_FROM_LUN_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    Integer hostId = new Integer(id);
                    Integer filesystemId2 = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    Integer diskId = (Integer)resultSet.getObject("DISK_ID");
                    String path = (String)resultSet.getObject("PATH");
                    String mountPoint = (String)resultSet.getObject("MOUNT_POINT");
                    String logicalKey = "logvol:" + diskId;
                    GraphLogicalVolume gLogical = (GraphLogicalVolume)entityMap.get(logicalKey);
                    if (gLogical == null) continue;
                    String filesystemKey = "filesystem:" + filesystemId2;
                    GraphFilesystem filesystem = new GraphFilesystem(filesystemKey);
                    filesystem.setDisplayName(mountPoint);
                    model.put(filesystem);
                    entityMap.put(filesystemKey, filesystem);
                    String filesystem2logicalKey = "fs2lun:" + filesystemId2 + ',' + diskId;
                    GraphFilesystem2LogicalVolume filesystem2logical = new GraphFilesystem2LogicalVolume(filesystem2logicalKey);
                    filesystem2logical.setFilesystemID(filesystem);
                    filesystem2logical.setLogicalVolumeID(gLogical);
                    model.put(filesystem2logical);
                    entityMap.put(filesystem2logicalKey, filesystem2logical);
                }
            }
            finally {
                block56: {
                    block55: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block55;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block56;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            if (debug) {
                System.out.println("lun totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDatabases(Connection con, GraphModel model, HashMap entityMap, String prefix, int id) throws SQLException {
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("lvm...");
        }
        boolean i = false;
        if (debug) {
            System.out.println("logical...");
        }
        if ("server:".equals(prefix)) {
            GraphAssociation gDB2TS;
            GraphTableSpace gTablespace;
            String tablespaceKey;
            Integer tablespaceId;
            String key;
            GraphDatabase gDB;
            String databaseKey;
            Integer rdbmsId;
            i = false;
            try {
                stmt = con.prepareStatement(SELECT_RDBMS_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    rdbmsId = (Integer)resultSet.getObject("RDBMS_ID");
                    String rdbmsKey = "rdbms:" + rdbmsId;
                    GraphDatabaseGroup gRDBMS = (GraphDatabaseGroup)entityMap.get(rdbmsKey);
                    if (gRDBMS != null) continue;
                    gRDBMS = new GraphDatabaseGroup(rdbmsKey);
                    this.populator.populateRDBMS(resultSet, gRDBMS);
                    model.put(gRDBMS);
                    entityMap.put(rdbmsKey, gRDBMS);
                }
            }
            finally {
                block75: {
                    block74: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block74;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block75;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            try {
                stmt = con.prepareStatement(SELECT_DATABASES_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    rdbmsId = (Integer)resultSet.getObject("RDBMS_ID");
                    Integer databaseId = (Integer)resultSet.getObject("DATABASE_ID");
                    String rdbmsKey = "rdbms:" + rdbmsId;
                    databaseKey = "database:" + databaseId;
                    GraphDatabaseGroup gRDBMS = (GraphDatabaseGroup)entityMap.get(rdbmsKey);
                    gDB = (GraphDatabase)entityMap.get(databaseKey);
                    if (gRDBMS == null || gDB != null) continue;
                    gDB = new GraphDatabase(databaseKey);
                    this.populator.populateDatabase(resultSet, gDB);
                    model.put(gDB);
                    entityMap.put(databaseKey, gDB);
                    key = "rdbms2database:" + rdbmsId + ',' + databaseId;
                    GraphDatabaseGroup2Database gDBG2DB = new GraphDatabaseGroup2Database(key);
                    gDBG2DB.setDatabaseGroupID(gRDBMS);
                    gDBG2DB.setDatabaseID(gDB);
                    model.put(gDBG2DB);
                    entityMap.put(key, gDBG2DB);
                }
            }
            finally {
                block78: {
                    block77: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block77;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block78;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            try {
                stmt = con.prepareStatement(SELECT_TABLESPACE_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    Integer databaseId = (Integer)resultSet.getObject("DATABASE_ID");
                    tablespaceId = (Integer)resultSet.getObject("TABLESPACE_ID");
                    tablespaceKey = "tablespace:" + tablespaceId;
                    databaseKey = "database:" + databaseId;
                    gTablespace = (GraphTableSpace)entityMap.get(tablespaceKey);
                    gDB = (GraphDatabase)entityMap.get(databaseKey);
                    if (gDB == null || gTablespace != null) continue;
                    gTablespace = new GraphTableSpace(tablespaceKey);
                    this.populator.populateTableSpace(resultSet, gTablespace);
                    model.put(gTablespace);
                    entityMap.put(tablespaceKey, gTablespace);
                    key = "database2tablespace:" + databaseId + ',' + tablespaceId;
                    gDB2TS = new GraphDatabase2TableSpace(key);
                    ((GraphDatabase2TableSpace)gDB2TS).setTableSpaceID(gTablespace);
                    ((GraphDatabase2TableSpace)gDB2TS).setDatabaseID(gDB);
                    model.put(gDB2TS);
                    entityMap.put(key, gDB2TS);
                }
            }
            finally {
                block81: {
                    block80: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block80;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block81;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            try {
                stmt = con.prepareStatement(SELECT_TABLESPACE2LOGICAL_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    Integer logicalId = (Integer)resultSet.getObject("LOGICAL_DISK_ID");
                    tablespaceId = (Integer)resultSet.getObject("TABLESPACE_ID");
                    tablespaceKey = "tablespace:" + tablespaceId;
                    String logicalKey = "logvol:" + logicalId;
                    gTablespace = (GraphTableSpace)entityMap.get(tablespaceKey);
                    GraphLogicalVolume gLogical = (GraphLogicalVolume)entityMap.get(logicalKey);
                    if (gLogical == null || gTablespace == null) continue;
                    key = "tablespace2logical:" + tablespaceId + ',' + logicalId;
                    gDB2TS = new GraphTableSpace2LogicalVolume(key);
                    ((GraphTableSpace2LogicalVolume)gDB2TS).setTableSpaceID(gTablespace);
                    ((GraphTableSpace2LogicalVolume)gDB2TS).setLogicalVolumeID(gLogical);
                    model.put(gDB2TS);
                    entityMap.put(key, gDB2TS);
                }
            }
            finally {
                block84: {
                    block83: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block83;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block84;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
            try {
                stmt = con.prepareStatement(SELECT_TABLESPACE2FILESYSTEM_FROM_HOST);
                stmt.setInt(1, id);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    Integer filesystemId = (Integer)resultSet.getObject("FILESYSTEM_ID");
                    tablespaceId = (Integer)resultSet.getObject("TABLESPACE_ID");
                    tablespaceKey = "tablespace:" + tablespaceId;
                    String filesystemKey = "filesystem:" + filesystemId;
                    gTablespace = (GraphTableSpace)entityMap.get(tablespaceKey);
                    GraphFilesystem gFS = (GraphFilesystem)entityMap.get(filesystemKey);
                    if (gFS == null || gTablespace == null) continue;
                    key = "tablespace2filesystem:" + tablespaceId + ',' + filesystemId;
                    GraphTableSpace2Filesystem gTS2FS = new GraphTableSpace2Filesystem(key);
                    gTS2FS.setTableSpaceID(gTablespace);
                    gTS2FS.setFilesystemID(gFS);
                    model.put(gTS2FS);
                    entityMap.put(key, gTS2FS);
                }
            }
            finally {
                block87: {
                    block86: {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException e) {
                            if (!TraceLogger.enableTrace) break block86;
                            TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                        }
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block87;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getLUN", e);
                    }
                }
            }
        }
    }

    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, int hostId) throws SQLException {
        this.getSansFromHost(con, model, entityMap, prefixId, new Integer(hostId), SELECT_SANS_FOR_HOST);
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelComputerL2 gModel = null;
        String hostId = null;
        GraphComputer.ID id = (GraphComputer.ID)rqst.getModelID().getFocusEntityID();
        hostId = (String)id.getID();
        int i = hostId.indexOf(58);
        String prefixId = hostId.substring(0, i + 1);
        hostId = hostId.substring(i + 1);
        int hostIdInt = Integer.parseInt(hostId);
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            gModel = new GraphModelComputerL2((GraphModelComputerL2.ID)rqst.getModelID());
            GraphComputer gHost = this.getHost(con, null, entityMap, prefixId, hostIdInt);
            if (gHost != null) {
                gModel.put(gHost);
                if ("server:".equals(prefixId)) {
                    this.getHBAs(con, gModel, entityMap, hostIdInt);
                }
                this.getHost2VolumeFromHost(con, gModel, entityMap, prefixId, hostIdInt);
                this.getLUN(con, gModel, entityMap, prefixId, hostIdInt);
                if ("server:".equals(prefixId)) {
                    // empty if block
                }
                this.getPorts(con, gModel, entityMap, prefixId, hostIdInt);
                this.getSubsystemFromHost(con, gModel, entityMap, prefixId, hostIdInt);
                this.getSwitchFromHost(con, gModel, entityMap, prefixId, hostIdInt);
                this.commit(con);
                if (rqst.getModelID().isNeedZoneData()) {
                    this.getZonesFromHost(con, gModel, entityMap, prefixId, hostIdInt);
                    this.commit(con);
                }
                gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
                resp.addResponse(0, gModel);
            } else {
                resp.addResponse(0, gModel);
            }
        } else {
            resp.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

