/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.Metric;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerStorageL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerSubsystemL1
extends ViewerStorageL0 {
    private static final boolean debug = false;
    public static final String SELECT_SUBSYSTEM = "    SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 , CAST(NULL as Integer) PERF_STATUS FROM     T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE     T_RES_STORAGE_SUBSYSTEM.PREFIX_ID = ? and \t T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static String SELECT_METRIC = "SELECT \tMETRIC.PM_QUERY, \tMETRIC.PM_TABLE, \tMETRIC.NAME_KEY, \tMETRIC.DATA_TYPE, \tMETRIC.UNIT_TYPE, \tMETRIC.PRECISION  FROM \tT_PMM_METRIC METRIC WHERE \tMETRIC.SUMM_TYPE = ? and \tDEV_TYPE = ? and \tCOMP_TYPE = ? and \tMETRIC_TYPE = ?";
    public static final String SELECT_SWITCH_FROM_ARRAY = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, \t T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \t T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID where     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = ? and \t SWITCH2SUBSYSTEM.SUBSYSTEM_ID = ? and  \t SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID = T_RES_SWITCH.PREFIX_ID and \t SWITCH2SUBSYSTEM.SWITCH_ID = T_RES_SWITCH.SWITCH_ID ";
    public static final String SELECT_SWITCH2ARRAY_FROM_ARRAY = "SELECT distinct \t SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID PREFIX_ID, \t SWITCH2SUBSYSTEM.SWITCH_ID SWITCH_ID, \t SWITCH2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2SUBSYSTEM.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM WHERE     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = ? and \t SWITCH2SUBSYSTEM.SUBSYSTEM_ID = ? ";
    public static final String SELECT_ZONE2MEMBER_FROM_SUBSYSTEM = "SELECT DISTINCT     'subsystem:' || CAST(SUBSYSTEM2PORT.SUBSYSTEM_ID as CHAR) ENTITY_KEY,     PORT2ZONE.ZONE_ID ZONE_ID FROM T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT, T_VIEW_PORT2ZONE PORT2ZONE WHERE \t SUBSYSTEM2PORT.PREFIX_ID = ? and \t SUBSYSTEM2PORT.SUBSYSTEM_ID = ? and     SUBSYSTEM2PORT.PORT_ID = PORT2ZONE.PORT_ID";
    public static String SELECT_SANS_FROM_ARRAY = "SELECT     SUBSYSTEM2FABRIC.FABRIC_ID,     SUBSYSTEM2FABRIC.PREFIX_ID, \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC WHERE \t SUBSYSTEM2FABRIC.PREFIX_ID = ? and \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID = ?";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_ARRAY = "SELECT \t SWITCH2FABRIC.PREFIX_ID, \t SWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE     T_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and \t SWITCH2FABRIC.SWITCH_ID = SWITCH2SUBSYSTEM.SWITCH_ID and     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = ? and     SWITCH2SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static final String SELECT_SANS_FROM_DIRECTLY_ATTACHED_HOST_FROM_SUBSYSTEM = "SELECT \t HOST2FABRIC.FABRIC_ID FABRIC_ID, \t HOST2FABRIC.HOST_ID HOST_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM, T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE \t HOST2FABRIC.HOST_ID = HOST2SUBSYSTEM.HOST_ID and     HOST2SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static final String SELECT_SUBSYSTEM_WITH_STATS_PRE = "SELECT   \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3  ";
    public static final String SELECT_SUBSYSTEM_WITH_STATS_POST = "\t    ,CASE WHEN TMP2.STATUS IS NULL THEN 0 ELSE TMP2.STATUS END PERF_STATUS \tFROM   \t\tT_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join \t(SELECT          MAX(TS.START_DATE_DEV || TS.START_TIME_DEV) ID,         SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID     FROM          T_PRF_TIMESTAMP TS, #table_name# S,         T_RES_STORAGE_SUBSYSTEM SUBSYSTEM     WHERE      \t TS.COMP_TYPE = 1 and      \t TS.SUMM_TYPE = 1 and          TS.TIME_ID = S.TIME_ID and          S.ELEMENT_ID = SUBSYSTEM.SUBSYSTEM_ID      GROUP BY SUBSYSTEM.SUBSYSTEM_ID)  TS2SYSTEM on      T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = TS2SYSTEM.SUBSYSTEM_ID  left outer join T_PRF_TIMESTAMP TS on     TS2SYSTEM.ID = (TS.START_DATE_DEV || TS.START_TIME_DEV) and \t TS.COMP_TYPE = 1 and \t TS.DEV_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID     left outer join #table_name# S on \t TS.TIME_ID = S.TIME_ID  and S.ELEMENT_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID left outer join \t   T_RES_VENDOR VENDOR on   \t\t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on   \t\t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID left outer join  (SELECT       CASE WHEN TMP1.MAX_STATUS = 0 THEN 0 \t\tWHEN TMP1.MIN_STATUS = 2 THEN 2 \t\tELSE 1 \t END STATUS,      TMP1.SUBSYSTEM_ID   FROM   (SELECT  \tSUBSYSTEM2THRESH.SUBSYSTEM_ID,  \tMAX(CASE WHEN THRESH_EXC.BOUND_TYPE IS NULL THEN 0 \t     WHEN THRESH_EXC.BOUND_TYPE =1 OR THRESH_EXC.BOUND_TYPE =2 THEN 2 \t     ELSE 1 \tEND) MAX_STATUS, \tMIN(CASE WHEN THRESH_EXC.BOUND_TYPE IS NULL THEN 0 \t     WHEN THRESH_EXC.BOUND_TYPE =1 OR THRESH_EXC.BOUND_TYPE =2 THEN 2 \t     ELSE 1 \tEND) MIN_STATUS FROM \t(SELECT SUBSYSTEM.SUBSYSTEM_ID, THRESH.THRESH_TYPE \tFROM  \t  T_RES_STORAGE_SUBSYSTEM SUBSYSTEM,     (SELECT  \tPOLICY.DEV_TYPE, POLICY.DEV_ID, THRESH.COMP_TYPE, THRESH.THRESH_TYPE      FROM \tT_PMM_THRESHOLD THRESH, T_PMM_THRESHOLD_POLICY POLICY     WHERE \tTHRESH.ORIGIN = POLICY.ORIGIN and  \tTHRESH.POLICY_ID = POLICY.POLICY_ID and  \tTHRESH.ENABLED = 1 and  \tPOLICY.DEV_TYPE > 0 and POLICY.DEV_TYPE < 6) THRESH) SUBSYSTEM2THRESH left outer join  (SELECT  THRESH.DEV_ID, THRESH.COMP_TYPE, THRESH.COMP_TYPE, THRESH.THRESH_TYPE, EXC2.BOUND_TYPE FROM (SELECT  \tPOLICY.DEV_TYPE, POLICY.DEV_ID, THRESH.COMP_TYPE, THRESH.THRESH_TYPE FROM \tT_PMM_THRESHOLD THRESH, T_PMM_THRESHOLD_POLICY POLICY WHERE \tTHRESH.ORIGIN = POLICY.ORIGIN and  \tTHRESH.POLICY_ID = POLICY.POLICY_ID and  \tTHRESH.ENABLED = 1 and  \t(POLICY.DEV_TYPE > 0 and POLICY.DEV_TYPE < 6)) THRESH  \tleft outer join ( \t\tSELECT MAX(EXC.START_DATE_DEV || EXC.START_TIME_DEV) DATE,   \t\t    EXC.COMP_TYPE, EXC.COMP_ID,   \t\t    EXC.DEV_TYPE, EXC.DEV_ID,  \t\t    EXC.THRESH_TYPE  \t\tFROM  \t\t    T_PMM_EXCEPTION EXC  \t\tGROUP BY EXC.COMP_TYPE, EXC.COMP_ID, EXC.DEV_TYPE, EXC.DEV_ID, EXC.THRESH_TYPE) EXC on \tTHRESH.DEV_TYPE = EXC.DEV_TYPE and \t(THRESH.DEV_ID = -1 OR THRESH.DEV_ID = EXC.DEV_ID) and \tTHRESH.COMP_TYPE = EXC.COMP_TYPE and \tTHRESH.THRESH_TYPE = EXC.THRESH_TYPE left outer join T_PMM_EXCEPTION EXC2 on   \t\t\t    EXC.DEV_ID = EXC2.DEV_ID and EXC.DEV_TYPE = EXC2.DEV_TYPE and   \t\t\t    EXC.COMP_ID = EXC2.COMP_ID and EXC.COMP_TYPE = EXC2.COMP_TYPE and   \t\t\t    EXC.DATE = (EXC2.START_DATE_DEV || EXC2.START_TIME_DEV) and   \t\t\t    EXC.THRESH_TYPE = EXC2.THRESH_TYPE) THRESH_EXC on \tSUBSYSTEM2THRESH.SUBSYSTEM_ID = THRESH_EXC.DEV_ID and  \tSUBSYSTEM2THRESH.THRESH_TYPE = THRESH_EXC.THRESH_TYPE GROUP BY SUBSYSTEM2THRESH.SUBSYSTEM_ID) TMP1 ) TMP2 on \tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = TMP2.SUBSYSTEM_ID \tWHERE   \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID = ? and \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ? ";
    public static final String SELECT_SUBSYSTEM_TYPE = "SELECT SUBSYSTEM.TYPE TYPE FROM \tT_RES_STORAGE_SUBSYSTEM SUBSYSTEM WHERE \tSUBSYSTEM.SUBSYSTEM_ID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromSubsystem(Connection srmConnection, GraphModel model, HashMap entityMap, String prefixID, int subsystemId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSubsystem gArray = (GraphSubsystem)entityMap.get(prefixID + subsystemId);
        if (gArray == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "Subsystem not found:subsystem:" + subsystemId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SWITCH_FROM_ARRAY);
            stmt.setString(1, prefixID);
            stmt.setInt(2, subsystemId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String switchKey = prefixId + switchId;
                GraphSwitch gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch != null) continue;
                gSwitch = new GraphSwitch(switchKey);
                this.populator.populateSwitch(resultSet, gSwitch, true);
                model.put(gSwitch);
                entityMap.put(switchKey, gSwitch);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitch2ArrayFromSubsystem(Connection srmConnection, GraphModel model, HashMap entityMap, String prefixID, int subsystemId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSubsystem gArray = (GraphSubsystem)entityMap.get(prefixID + subsystemId);
        if (gArray == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "Subsystem not found:subsystem:" + subsystemId);
            }
            return;
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SWITCH2ARRAY_FROM_ARRAY);
            stmt.setString(1, prefixID);
            stmt.setInt(2, subsystemId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String switchKey = prefixId + switchId;
                GraphSwitch gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "Switch not found:" + switchKey);
                    continue;
                }
                String switch2ArrayKey = "port2port:" + prefixId + switchId + ',' + prefixID + subsystemId + ',' + port2portId;
                if (entityMap.get(switch2ArrayKey) == null) {
                    GraphSwitch2Subsystem switch2array = new GraphSwitch2Subsystem(switch2ArrayKey);
                    switch2array.setSubsystemID((GraphSubsystem.ID)gArray.getEntityID());
                    switch2array.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                    this.populator.populatePort2Port(resultSet, switch2array);
                    model.put(switch2array);
                    entityMap.put(switch2ArrayKey, switch2array);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "Duplicated :" + switch2ArrayKey);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2ArrayFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2ArrayFromSubsystem", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "");
        }
    }

    public void getZonesFromSubsystem(Connection con, GraphModel model, HashMap entityMap, String prefixId, int subsystemId) throws SQLException {
    }

    public void getSansFromHost(Connection con, GraphModel model, HashMap entityMap, String prefixId, int subsystemId) throws SQLException {
        this.getSansFromHost(con, model, entityMap, prefixId, new Integer(subsystemId), SELECT_SANS_FROM_DIRECTLY_ATTACHED_HOST_FROM_SUBSYSTEM);
    }

    public void getSansFromSubsystem(Connection con, GraphModel model, HashMap entityMap, String prefixId, int subsystemId) throws SQLException {
        this.getSansFromSubsystem(con, model, entityMap, prefixId, new Integer(subsystemId), SELECT_SANS_FROM_ARRAY);
    }

    public void getSansFromSwitch(Connection con, GraphModel model, HashMap entityMap, String prefixId, int subsystemId) throws SQLException {
        this.getSansFromSwitch(con, model, entityMap, prefixId, new Integer(subsystemId), SELECT_SANS_FROM_SWITCH_FROM_ARRAY);
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metric getMetric(Connection con, int dev, int comp, int summ, int pmmetric) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(SELECT_METRIC);
            stmt.setInt(1, summ);
            stmt.setInt(2, dev);
            stmt.setInt(3, comp);
            stmt.setInt(4, pmmetric);
            resultSet = stmt.executeQuery();
            Metric metric = null;
            while (resultSet.next()) {
                metric = new Metric((String)resultSet.getObject("PM_QUERY"), (String)resultSet.getObject("NAME_KEY"), (String)resultSet.getObject("PM_TABLE"));
            }
            Metric metric2 = metric;
            return metric2;
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getMetric", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getMetric", e);
                }
            }
        }
    }

    public static String getQuery(Metric[] metrics, String preQuery, String postQuery, boolean replaceTable, String tableName) {
        Metric metric = null;
        for (int i = 0; i < metrics.length; ++i) {
            metric = metrics[i];
            if (metric != null) {
                preQuery = preQuery + ", " + metric.query + " " + metric.nameKey + " ";
                tableName = metric.tableName;
                continue;
            }
            boolean m = false;
            boolean w = false;
        }
        if (tableName != null && replaceTable) {
            postQuery = postQuery.replaceAll("#table_name#", tableName);
        }
        return preQuery + postQuery;
    }

    public static Metric[] getMetrics(Connection con, int dev, int comp) throws SQLException {
        Vector<Metric> vmetrics = new Vector<Metric>();
        block0 : switch (dev) {
            case 5: {
                switch (comp) {
                    case 12: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 819));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 820));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 803));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 806));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 812));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 815));
                        break;
                    }
                    case 2: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 852));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 853));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 858));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 859));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 863));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 864));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 819));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 820));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 803));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 806));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 812));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 815));
                    }
                }
                break;
            }
            case 4: {
                switch (comp) {
                    case 12: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 819));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 820));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 803));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 806));
                        break block0;
                    }
                    case 2: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 852));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 853));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 858));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 859));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 863));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 864));
                        break block0;
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                switch (comp) {
                    case 12: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 819));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 820));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 803));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 806));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 822));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 823));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 812));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 815));
                        break;
                    }
                    case 2: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 852));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 853));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 858));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 859));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 863));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 864));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 819));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 820));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 803));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 806));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 822));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 823));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 812));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 815));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 832));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 834));
                    }
                }
                break;
            }
            case 6: {
                switch (comp) {
                    case 14: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 855));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 856));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 858));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 859));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 872));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 874));
                        break block0;
                    }
                    case 13: {
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 855));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 856));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 858));
                        vmetrics.add(ViewerSubsystemL1.getMetric(con, dev, comp, 1, 859));
                    }
                }
            }
        }
        return vmetrics.toArray(new Metric[vmetrics.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSubsystemType(Connection con, int subsystemId) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = con.prepareStatement(SELECT_SUBSYSTEM_TYPE);
            stmt.setInt(1, subsystemId);
            resultSet = stmt.executeQuery();
            Object metric = null;
            String type = null;
            while (resultSet.next()) {
                type = (String)resultSet.getObject("TYPE");
            }
            String string = type;
            return string;
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getSubsystemType", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getMetric", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphSubsystem getSubsystem(Connection con, GraphModel model, HashMap entityMap, String prefixID, int subsystemId, boolean withPerformance) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphSubsystem gSubsystem = null;
        boolean i = false;
        String stype = null;
        try {
            if (withPerformance && "subsystem:".equals(prefixID)) {
                int dev;
                stype = ViewerSubsystemL1.getSubsystemType(con, subsystemId);
                String query = null;
                if ("FAStT".equalsIgnoreCase(stype)) {
                    dev = 5;
                    query = ViewerSubsystemL1.getQuery(ViewerSubsystemL1.getMetrics(con, dev, 1), SELECT_SUBSYSTEM_WITH_STATS_PRE, SELECT_SUBSYSTEM_WITH_STATS_POST, true, "T_PRF_DSVOL");
                } else if ("SVC".equalsIgnoreCase(stype)) {
                    dev = 4;
                    query = ViewerSubsystemL1.getQuery(ViewerSubsystemL1.getMetrics(con, dev, 1), SELECT_SUBSYSTEM_WITH_STATS_PRE, SELECT_SUBSYSTEM_WITH_STATS_POST, true, "T_PRF_DSVOL");
                } else if ("ESS".equals(stype) || "DS8000".equals(stype) || "DS6000".equals(stype)) {
                    dev = 0;
                    if ("ESS".equals(stype)) {
                        dev = 1;
                    } else if ("DS6000".equals(stype)) {
                        dev = 2;
                    } else if ("DS8000".equals(stype)) {
                        dev = 3;
                    }
                    query = ViewerSubsystemL1.getQuery(ViewerSubsystemL1.getMetrics(con, dev, 1), SELECT_SUBSYSTEM_WITH_STATS_PRE, SELECT_SUBSYSTEM_WITH_STATS_POST, true, "T_PRF_DSVOL");
                } else {
                    query = SELECT_SUBSYSTEM;
                }
                stmt = con.prepareStatement(query);
            } else {
                stmt = con.prepareStatement(SELECT_SUBSYSTEM);
            }
            stmt.setString(1, prefixID);
            stmt.setInt(2, subsystemId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer subsystemIdInt = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (subsystemIdInt == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getSubsystem", "Subsystem ID is NULL");
                    continue;
                }
                String subsystemKey = prefixId + subsystemIdInt;
                if (entityMap.get(subsystemKey) == null) {
                    gSubsystem = new GraphSubsystem(subsystemKey);
                    this.populator.populateSubsystem(resultSet, gSubsystem);
                    if (model != null) {
                        model.put(gSubsystem);
                    }
                    if (entityMap != null) {
                        entityMap.put(subsystemKey, gSubsystem);
                    }
                    if (!withPerformance || !"subsystem:".equals(prefixID)) continue;
                    GraphSubsystemPerf perf = new GraphSubsystemPerf((String)gSubsystem.getEntityID().getID());
                    Integer status = (Integer)resultSet.getObject("PERF_STATUS");
                    if (status == null) {
                        perf.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                    } else if (status == 0) {
                        perf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    } else if (status == 1) {
                        perf.setHealthStatus(GraphModelConstant.STATUS_WARNING);
                    } else if (status == 2) {
                        perf.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                    }
                    Integer hitsRx = null;
                    Integer hitsTx = null;
                    Double ioRateRx = null;
                    Double ioRateWx = null;
                    Double dataRx = null;
                    Double dataTx = null;
                    if ("ESS".equals(stype) || "DS6000".equals(stype) || "DS8000".equals(stype) || "FAStT".equals(stype)) {
                        try {
                            hitsRx = (Integer)resultSet.getObject("MET_READ_HITS_PERC_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setCacheHitRx(hitsRx != null ? new Double((double)hitsRx.intValue() / 100.0) : null);
                        try {
                            hitsTx = (Integer)resultSet.getObject("MET_WRITE_HITS_PERC_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setCacheHitTx(hitsTx != null ? new Double((double)hitsTx.intValue() / 100.0) : null);
                        try {
                            ioRateRx = (Double)resultSet.getObject("MET_READ_IO_RATE_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setIORateRx(ioRateRx);
                        try {
                            ioRateWx = (Double)resultSet.getObject("MET_WRITE_IO_RATE_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setIORateTx(ioRateWx);
                        try {
                            dataRx = (Double)resultSet.getObject("MET_READ_KB_RATE_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setDataRateRx(dataRx);
                        try {
                            dataTx = (Double)resultSet.getObject("MET_WRITE_KB_RATE_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setDataRateTx(dataTx);
                    }
                    Double respTimeRx = null;
                    Double respTimeTx = null;
                    if ("ESS".equals(stype) || "DS8000".equals(stype) || "DS6000".equals(stype)) {
                        try {
                            respTimeRx = (Double)resultSet.getObject("MET_READ_RESP_TIME_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setResponseTimeRx(respTimeRx);
                        try {
                            respTimeTx = (Double)resultSet.getObject("MET_WRITE_RESP_TIME_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setResponseTimeTx(respTimeTx);
                    }
                    Integer cacheHolding = null;
                    Integer nvsPerc = null;
                    if ("ESS".equals(stype) || "DS8000".equals(stype) || "DS6000".equals(stype)) {
                        try {
                            nvsPerc = (Integer)resultSet.getObject("MET_NVS_FULL_PERC_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setNVSFullPercentage(nvsPerc != null ? new Double(nvsPerc.intValue()) : null);
                        try {
                            cacheHolding = (Integer)resultSet.getObject("MET_CACHE_HOLD_TIME_NAME");
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        perf.setCacheHoldingTime(cacheHolding);
                    }
                    if ("SVC".equals(stype) || dataTx != null || dataRx != null || ioRateRx != null || ioRateWx != null || hitsRx != null || hitsTx != null || respTimeRx != null || respTimeTx != null || cacheHolding != null || nvsPerc != null) {
                        model.put(perf);
                    } else {
                        perf = new GraphSubsystemPerf("subsystemperf:" + subsystemKey);
                        perf.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                        model.put(perf);
                    }
                    GraphSubsystem2SubsystemPerf array2perf = new GraphSubsystem2SubsystemPerf("subsystem2perf:" + gSubsystem.getEntityID().getID());
                    array2perf.setSubsystemID((GraphSubsystem.ID)gSubsystem.getEntityID());
                    array2perf.setSubsystemPerfID((GraphSubsystemPerf.ID)perf.getEntityID());
                    model.put(array2perf);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getSubsystem", "Duplicated Array entry:" + subsystemKey);
            }
        }
        finally {
            block67: {
                block66: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block66;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block67;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getSubsystem", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getSubsystem", "");
        }
        return gSubsystem;
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getView", "");
        }
        GraphModelSubsystemL1 gModel = null;
        String subsystemId = null;
        GraphModel.MultiEntityID multiNodeModelID = (GraphModel.MultiEntityID)rqst.getModelID();
        Vector childFocusNodeIDV = multiNodeModelID.getChildFocusEntityIDs();
        HashMap entityMap = new HashMap();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            gModel = new GraphModelSubsystemL1((GraphModelSubsystemL1.ID)rqst.getModelID());
            for (GraphSubsystem.ID arrayId : childFocusNodeIDV) {
                int subsystemIdInt;
                subsystemId = (String)arrayId.getID();
                int i = subsystemId.indexOf(58);
                String prefixId = subsystemId.substring(0, i + 1);
                if (this.getSubsystem(con, gModel, entityMap, prefixId, subsystemIdInt = Integer.parseInt(subsystemId = subsystemId.substring(i + 1)), false) == null) continue;
                this.getSwitchFromSubsystem(con, gModel, entityMap, prefixId, subsystemIdInt);
                this.getSwitch2ArrayFromSubsystem(con, gModel, entityMap, prefixId, subsystemIdInt);
                this.getSansFromSwitch(con, (GraphModel)gModel, entityMap, prefixId, subsystemIdInt);
                this.commit(con);
                if (!rqst.getModelID().isNeedZoneData()) continue;
                this.getZonesFromSubsystem(con, gModel, entityMap, prefixId, subsystemIdInt);
                this.commit(con);
            }
            gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
            resp.addResponse(0, gModel);
        } else {
            resp.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getView", "");
        }
    }
}

