/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelTapeLibraryL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphMediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeDrive2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2MediaChanger;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary2TapeDrive;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerTapeLibraryL1;

public class ViewerTapeLibraryL2
extends ViewerTapeLibraryL1 {
    private static boolean debug = false;
    public static String SELECT_SANS_FROM_TAPE = "SELECT distinct     TAPE2FABRIC.PREFIX_ID, \t TAPE2FABRIC.FABRIC_ID,     TAPE2FABRIC.TAPE_LIBRARY_ID FROM T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.PREFIX_ID = ? and \t TAPE2FABRIC.TAPE_LIBRARY_ID = ? ";
    public static final String SELECT_PORT2PORT_FROM_TAPE = "select     PORT2PORT.PORT_ID1 PORT_ID,     PORT2PORT.PORT_ID2 PORT2_ID, \t CASE \t\tWHEN PORT1.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT1.DISPLAY_NAME) != '' THEN PORT1.DISPLAY_NAME \t\tELSE PORT1.NAME \t END PORT1_NAME, \t PORT1.PORT_NUMBER PORT_NUMBER1, \t CASE \t\tWHEN PORT2.DISPLAY_NAME IS NOT NULL AND RTRIM(PORT2.DISPLAY_NAME)!= '' THEN PORT2.DISPLAY_NAME \t\tELSE PORT2.NAME \t END PORT2_NAME, \t PORT2.PORT_NUMBER PORT_NUMBER2,     PORT2PORT.PORT2PORT_ID PORT2PORT_ID, \t PORT2PORT.DETECTABLE DETECTABLE,\t ENTITY2PORT.PREFIX_ID,\t ENTITY2PORT.ENTITY_ID  from     T_RES_PORT PORT1, T_RES_PORT PORT2, T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2PORT PORT2PORT, T_VIEW_ENTITY2PORT ENTITY2PORT where     ENTITY2PORT.PORT_ID = PORT1.PORT_ID and \t PORT1.PORT_ID = PORT2PORT.PORT_ID1 and \t PORT2.PORT_ID = PORT2PORT.PORT_ID2 and     TAPE2PORT.PORT_ID = PORT2PORT.PORT_ID1 and     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? ";
    public static final String SELECT_PORTS_FROM_TAPE = "SELECT     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS FROM T_VIEW_VTAPE2PORT TAPE2PORT,    T_RES_PORT WHERE     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = T_RES_PORT.PORT_ID ";
    public static final String SELECT_SWITCH_FROM_TAPE = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 ,\tSWITCH2TAPE.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on \tT_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID WHERE     T_RES_SWITCH.SWITCH_ID = SWITCH2TAPE.SWITCH_ID and \t SWITCH2TAPE.TAPE_PREFIX_ID = ? and \t SWITCH2TAPE.TAPE_LIBRARY_ID = ? ";
    public static String SELECT_SANS_FROM_SWITCH_FROM_TAPE = "SELECT distinct     TAPE2FABRIC.PREFIX_ID, \t TAPE2FABRIC.FABRIC_ID,     TAPE2FABRIC.TAPE_LIBRARY_ID FROM T_VIEW_VSWITCH2TAPE SWITCH2TAPE, T_VIEW_VTAPE2FABRIC TAPE2FABRIC WHERE     TAPE2FABRIC.PREFIX_ID = SWITCH2TAPE.TAPE_PREFIX_ID and \t TAPE2FABRIC.TAPE_LIBRARY_ID = SWITCH2TAPE.TAPE_LIBRARY_ID and     SWITCH2TAPE.SWITCH_PREFIX_ID = ? and \t SWITCH2TAPE.SWITCH_ID = ?";
    public static final String SELECT_TAPE_DRIVES = "SELECT distinct    CASE WHEN T_RES_TAPE_DRIVE.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_TAPE_DRIVE.DISPLAY_NAME) != '' THEN T_RES_TAPE_DRIVE.DISPLAY_NAME    \t  ELSE CAST (T_RES_TAPE_DRIVE.TAPE_DRIVE_ID as CHAR)    END DISPLAY_NAME,    LOCATION.LOCATION_COORDINATES LOCATION, \tT_RES_TAPE_DRIVE.TAPE_DRIVE_ID TAPE_DRIVE_ID, \tT_RES_TAPE_DRIVE.OPERATIONAL_STATUS OPERATIONAL_STATUS, \tT_RES_TAPE_DRIVE.DETECTABLE DETECTABLE, \tT_RES_TAPE_DRIVE.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \tT_RES_TAPE_DRIVE.PROPAGATED_STATUS PROPAGATED_STATUS, \tT_RES_TAPE_DRIVE.MOUNT_COUNT MOUNT_COUNT, \tT_RES_TAPE_DRIVE.NEEDS_CLEANING NEEDS_CLEANING, \tT_RES_TAPE_DRIVE.FIRMWARE_VERSION FIRMWARE_VERSION, \tT_RES_TAPE_DRIVE.USER_ATTRIB1 USER_ATTRIB1, \tT_RES_TAPE_DRIVE.USER_ATTRIB2 USER_ATTRIB2, \tT_RES_TAPE_DRIVE.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_TAPE_DRIVE left outer join T_RES_TAPE_MEDIA_LOCATION LOCATION on \t T_RES_TAPE_DRIVE.LOCATION_ID = LOCATION.LOCATION_ID WHERE   \t T_RES_TAPE_DRIVE.TAPE_LIBRARY_ID = ?  ";
    public static final String SELECT_MEDIA_CHANGER = "SELECT distinct    CASE WHEN T_RES_TAPE_MEDIA_CHANGER.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_TAPE_MEDIA_CHANGER.DISPLAY_NAME) != '' THEN T_RES_TAPE_MEDIA_CHANGER.DISPLAY_NAME    \t  ELSE CAST (T_RES_TAPE_MEDIA_CHANGER.TAPE_MEDIA_CHANGER_ID as CHAR)    END DISPLAY_NAME,    T_RES_TAPE_MEDIA_CHANGER.TAPE_MEDIA_CHANGER_ID TAPE_MEDIA_CHANGER_ID, \tT_RES_TAPE_MEDIA_CHANGER.OPERATIONAL_STATUS OPERATIONAL_STATUS, \tT_RES_TAPE_MEDIA_CHANGER.DETECTABLE DETECTABLE, \tT_RES_TAPE_MEDIA_CHANGER.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \tT_RES_TAPE_MEDIA_CHANGER.PROPAGATED_STATUS PROPAGATED_STATUS, \tT_RES_TAPE_MEDIA_CHANGER.FIRMWARE_VERSION FIRMWARE_VERSION, \tT_RES_TAPE_MEDIA_CHANGER.USER_ATTRIB1 USER_ATTRIB1, \tT_RES_TAPE_MEDIA_CHANGER.USER_ATTRIB2 USER_ATTRIB2, \tT_RES_TAPE_MEDIA_CHANGER.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_TAPE_MEDIA_CHANGER WHERE   \t T_RES_TAPE_MEDIA_CHANGER.TAPE_LIBRARY_ID = ?  ";
    public static final String SELECT_TAPE_DRIVES2PORT_FROM_TAPE = "SELECT distinct \t T_RES_TAPE_DRIVE.TAPE_DRIVE_ID TAPE_DRIVE_ID,     PORT.PORT_ID PORT_ID FROM     T_RES_NODE NODE,     T_RES_PORT PORT, T_RES_TAPE_DRIVE WHERE   \t T_RES_TAPE_DRIVE.TAPE_LIBRARY_ID = ? and     T_RES_TAPE_DRIVE.NODE_ID = NODE.NODE_ID and     NODE.NODE_ID = PORT.NODE_ID  ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_TAPE = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VTAPE2PORT TAPE2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE    TAPE2PORT.PREFIX_ID = ? and    TAPE2PORT.TAPE_LIBRARY_ID = ? and \tTAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_TAPE = "SELECT DISTINCT    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZONE PORT2ZONE, T_RES_ZONE, T_RES_FABRIC FABRIC WHERE \t TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_TAPE = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM T_VIEW_VTAPE2PORT TAPE2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID  WHERE     TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID  ";
    public static final String SELECT_ZSET2ZONE_FROM_TAPE = "SELECT DISTINCT     ZSET2ZONE.ZONE_ID,     ZSET2ZONE.ZSET_ID FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZONE PORT2ZONE,  \tT_RES_ZSET2ZONE ZSET2ZONE WHERE \t TAPE2PORT.PREFIX_ID = ? and     TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID ";
    public static final String SELECT_ZSET_FROM_TAPE = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VTAPE2PORT TAPE2PORT, T_VIEW_PORT2ZSET PORT2ZSET, \tT_RES_ZSET, T_RES_FABRIC FABRIC WHERE \t TAPE2PORT.PREFIX_ID = ? and \t TAPE2PORT.TAPE_LIBRARY_ID = ? and     TAPE2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTapeDrivesFromTape(Connection srmConnection, GraphModel model, HashMap entityMap, int tapeId) throws SQLException {
        Integer tapeDriveId;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getTapeDrivesFromTape", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphTapeLibrary gTape = (GraphTapeLibrary)entityMap.get("tapelibrary:" + tapeId);
        if (gTape == null) {
            return;
        }
        if (debug) {
            System.out.println("tapedrives ...");
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_TAPE_DRIVES);
            stmt.setInt(1, tapeId);
            resultSet = stmt.executeQuery();
            boolean i = false;
            while (resultSet.next()) {
                tapeDriveId = (Integer)resultSet.getObject("TAPE_DRIVE_ID");
                String tapeDriveKey = "tapedrive:" + tapeDriveId;
                if (entityMap.get(tapeDriveKey) == null) {
                    GraphTapeDrive gTapeDrive = new GraphTapeDrive(tapeDriveKey);
                    this.populator.populateTapeDrive(resultSet, gTapeDrive);
                    entityMap.put(tapeDriveKey, gTapeDrive);
                    model.put(gTapeDrive);
                    String tapelibrary2tapedriveKey = "tape2tapedrive:" + tapeId + ',' + tapeDriveId;
                    GraphTapeLibrary2TapeDrive tapelibrary2tapedrive = new GraphTapeLibrary2TapeDrive(tapelibrary2tapedriveKey);
                    tapelibrary2tapedrive.setTapeLibraryID((GraphTapeLibrary.ID)gTape.getEntityID());
                    tapelibrary2tapedrive.setTapeDriveID((GraphTapeDrive.ID)gTapeDrive.getEntityID());
                    entityMap.put(tapelibrary2tapedriveKey, tapelibrary2tapedrive);
                    model.put(tapelibrary2tapedrive);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getTapeDrivesFromTape", "Duplicated tape drive:" + tapeDriveKey);
            }
        }
        finally {
            block40: {
                block39: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block39;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block40;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("tapedrives totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("tapedrive2port ...");
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_TAPE_DRIVES2PORT_FROM_TAPE);
            stmt.setInt(1, tapeId);
            resultSet = stmt.executeQuery();
            boolean i = false;
            while (resultSet.next()) {
                tapeDriveId = (Integer)resultSet.getObject("TAPE_DRIVE_ID");
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                String tapeDriveKey = "tapedrive:" + tapeDriveId;
                GraphTapeDrive gTapeDrive = (GraphTapeDrive)entityMap.get(tapeDriveKey);
                if (gTapeDrive != null) {
                    String portKey = "Port:" + portId;
                    GraphFCPort gPort = (GraphFCPort)entityMap.get(portKey);
                    if (gPort != null) {
                        String tapedrive2portKey = "tapedrive2port:" + tapeDriveId + ',' + portId;
                        GraphTapeDrive2FCPort tapedrive2port = new GraphTapeDrive2FCPort(tapedrive2portKey);
                        tapedrive2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                        tapedrive2port.setTapeDriveID((GraphTapeDrive.ID)gTapeDrive.getEntityID());
                        entityMap.put(tapedrive2portKey, tapedrive2port);
                        model.put(tapedrive2port);
                        String tape2portKey = "tape2port:" + tapeId + ',' + portId;
                        GraphTapeLibrary2FCPort tape2port = new GraphTapeLibrary2FCPort(tape2portKey);
                        tape2port.setTapeLibraryID((GraphTapeLibrary.ID)gTape.getEntityID());
                        tape2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                        model.put(tape2port);
                        entityMap.put(tape2portKey, tape2port);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "Missing FCPort entry for:" + portKey);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "Missing tape drive:" + tapeDriveKey);
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block42;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block43;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("tapedrive2port totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTapeMediaChanger(Connection srmConnection, GraphModel model, HashMap entityMap, int tapeId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        GraphTapeLibrary gTape = (GraphTapeLibrary)entityMap.get("tapelibrary:" + tapeId);
        if (gTape == null) {
            return;
        }
        if (debug) {
            System.out.println("mediachanger ...");
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_MEDIA_CHANGER);
            stmt.setInt(1, tapeId);
            resultSet = stmt.executeQuery();
            boolean i = false;
            while (resultSet.next()) {
                Integer tapeMediaChangerId = (Integer)resultSet.getObject("TAPE_MEDIA_CHANGER_ID");
                String tapeMediaChangerKey = "mediachanger:" + tapeMediaChangerId;
                if (entityMap.get(tapeMediaChangerKey) == null) {
                    GraphMediaChanger gTapeMediaChanger = new GraphMediaChanger(tapeMediaChangerKey);
                    this.populator.populateTapeMediaChanger(resultSet, gTapeMediaChanger);
                    entityMap.put(tapeMediaChangerKey, gTapeMediaChanger);
                    model.put(gTapeMediaChanger);
                    String tape2mediachangerKey = "tape2mediachanger:" + tapeId + ',' + tapeMediaChangerId;
                    GraphTapeLibrary2MediaChanger tape2mediachanger = new GraphTapeLibrary2MediaChanger(tape2mediachangerKey);
                    tape2mediachanger.setTapeLibraryID((GraphTapeLibrary.ID)gTape.getEntityID());
                    tape2mediachanger.setMediaChangerID((GraphMediaChanger.ID)gTapeMediaChanger.getEntityID());
                    entityMap.put(tape2mediachangerKey, tape2mediachanger);
                    model.put(tape2mediachanger);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", "Duplicated tape drive:" + tapeMediaChangerKey);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", e);
                }
            }
        }
        if (debug) {
            System.out.println("mediachanger totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getTapeMediaChanger", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPortsFromTape(Connection srmConnection, GraphModel model, HashMap entityMap, String prefixId, int tapeId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        String tapeKey = prefixId + tapeId;
        GraphTapeLibrary tape = (GraphTapeLibrary)entityMap.get(tapeKey);
        if (tape == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "tape was not found:" + tapeKey);
            }
            return;
        }
        if (debug) {
            System.out.println("ports ...");
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_PORTS_FROM_TAPE);
            stmt.setString(1, prefixId);
            stmt.setInt(2, tapeId);
            resultSet = stmt.executeQuery();
            boolean i = false;
            while (resultSet.next()) {
                Integer pordId = (Integer)resultSet.getObject("PORT_ID");
                if (pordId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String portKey = "Port:" + pordId;
                if (entityMap.get(portKey) == null) {
                    GraphFCPort gPort = new GraphFCPort(portKey);
                    this.populator.populatePort(resultSet, gPort);
                    entityMap.put(portKey, gPort);
                    model.put(gPort);
                    GraphTapeLibrary2FCPort tape2port = new GraphTapeLibrary2FCPort("tape2port:" + tapeKey + ',' + pordId);
                    tape2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                    tape2port.setTapeLibraryID((GraphTapeLibrary.ID)tape.getEntityID());
                    model.put(tape2port);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "Duplicated host entry:" + portKey);
            }
        }
        finally {
            block44: {
                block43: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block43;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block44;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("ports totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("port2port totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        init = System.currentTimeMillis();
        if (debug) {
            System.out.println("port2port ...");
        }
        try {
            stmt = srmConnection.prepareStatement(SELECT_PORT2PORT_FROM_TAPE);
            stmt.setString(1, prefixId);
            stmt.setInt(2, tapeId);
            resultSet = stmt.executeQuery();
            boolean i = false;
            while (resultSet.next()) {
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                String portName1 = (String)resultSet.getObject("PORT1_NAME");
                String portNumber1 = (String)resultSet.getObject("PORT_NUMBER1");
                String portNumber2 = (String)resultSet.getObject("PORT_NUMBER2");
                Integer portId2 = (Integer)resultSet.getObject("PORT2_ID");
                String portName2 = (String)resultSet.getObject("PORT2_NAME");
                Integer port2portId = (Integer)resultSet.getObject("PORT2PORT_ID");
                String prefixID = (String)resultSet.getObject("PREFIX_ID");
                Integer entityId = (Integer)resultSet.getObject("ENTITY_ID");
                if (portId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String portKey = "Port:" + portId;
                String portKey2 = "Port:" + portId2;
                GraphFCPort gPort2 = (GraphFCPort)entityMap.get(portKey2);
                GraphFCPort gPort = (GraphFCPort)entityMap.get(portKey);
                if (gPort2 == null) {
                    gPort2 = new GraphFCPort(portKey2);
                    gPort2.setDisplayName(portName2);
                    gPort2.setPortNumber(portNumber2);
                    entityMap.put(portKey2, gPort2);
                    model.put(gPort2);
                }
                if (gPort == null) {
                    gPort = new GraphFCPort(portKey);
                    gPort.setDisplayName(portName1);
                    gPort.setPortNumber(portNumber1);
                    entityMap.put(portKey, gPort);
                    model.put(gPort);
                }
                String port2portKey = "port2port:" + prefixId + tapeId + ',' + prefixID + entityId + ',' + port2portId;
                GraphFCPort2FCPort port2port = new GraphFCPort2FCPort(port2portKey);
                port2port.setFCPort1ID((GraphFCPort.ID)gPort.getEntityID());
                port2port.setFCPort2ID((GraphFCPort.ID)gPort2.getEntityID());
                this.populator.populatePort2Port(resultSet, port2port);
                entityMap.put(port2portKey, port2port);
                model.put(port2port);
            }
        }
        finally {
            block47: {
                block46: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block46;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block47;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("port2port totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getPortsFromSubsystem", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSwitchFromTape(Connection srmConnection, GraphModel model, HashMap entityMap, String prefixID, int tapeId) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "");
        }
        long init = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        if (debug) {
            System.out.println("switch ...");
        }
        boolean i = false;
        try {
            stmt = srmConnection.prepareStatement(SELECT_SWITCH_FROM_TAPE);
            stmt.setString(1, prefixID);
            stmt.setInt(2, tapeId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                String prefixId = (String)resultSet.getObject("PREFIX_ID");
                Integer switchId = (Integer)resultSet.getObject("SWITCH_ID");
                if (switchId == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String switchKey = prefixId + switchId;
                GraphSwitch gSwitch = null;
                gSwitch = (GraphSwitch)entityMap.get(switchKey);
                if (gSwitch == null) {
                    gSwitch = new GraphSwitch(switchKey);
                    this.populator.populateSwitch(resultSet, gSwitch, true);
                    entityMap.put(switchKey, gSwitch);
                    model.put(gSwitch);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "Duplicated host entry:" + switchKey);
                }
                Integer portId = (Integer)resultSet.getObject("PORT_ID");
                String portKey = "Port:" + portId;
                GraphFCPort gPort = (GraphFCPort)entityMap.get(portKey);
                if (gPort != null) {
                    String host2portKey = "switch2fcport:" + switchKey + ',' + portId;
                    GraphSwitch2FCPort gHost2port = new GraphSwitch2FCPort(host2portKey);
                    gHost2port.setFCPortID((GraphFCPort.ID)gPort.getEntityID());
                    gHost2port.setSwitchID((GraphSwitch.ID)gSwitch.getEntityID());
                    model.put(gHost2port);
                    entityMap.put(host2portKey, gHost2port);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "Missing port entity:" + portKey);
            }
        }
        finally {
            block25: {
                block24: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block24;
                        TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", e);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block25;
                    TraceLogger.exception(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", e);
                }
            }
        }
        if (debug) {
            System.out.println("switch totalTime: " + (double)(System.currentTimeMillis() - init) / 1000.0);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getSwitchFromSubsystem", "");
        }
    }

    public void getZonesFromTape(Connection con, GraphModel model, HashMap entityMap, String prefixId, int switchId) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(con, model, entityMap, new Object[]{prefixId, new Integer(switchId)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_TAPE, SELECT_ZONES_FROM_TAPE, SELECT_ZSET_FROM_TAPE, SELECT_ZSET2ZONE_FROM_TAPE, SELECT_ZONE2MEMBER_FROM_TAPE});
    }

    public void getZonesFromEntitiesConnectedToTape(Connection con, GraphModel model, HashMap entityMap, String prefixId, int switchId) throws SQLException {
    }

    public void commit(Connection con) {
        block2: {
            try {
                con.commit();
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", e);
            }
        }
    }

    public void getView(Connection con, ViewerRequest rqst, ViewerResponse resp) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerTapeLibraryL2.class.getName(), "getView", "");
        }
        GraphModelTapeLibraryL2 gModel = null;
        String tapeId = null;
        GraphTapeLibrary.ID id = (GraphTapeLibrary.ID)rqst.getModelID().getFocusEntityID();
        tapeId = (String)id.getID();
        int i = tapeId.indexOf(58);
        String prefixId = tapeId.substring(0, i + 1);
        tapeId = tapeId.substring(i + 1);
        int tapeIdInt = Integer.parseInt(tapeId);
        HashMap<String, GraphTapeLibrary> entityMap = new HashMap<String, GraphTapeLibrary>();
        Timestamp prevUpdate = rqst.getTimestamp();
        Timestamp lastUpdate = null;
        if (lastUpdate == null || prevUpdate == null || lastUpdate.after(prevUpdate)) {
            GraphTapeLibrary gTapeLibrary = this.getTapeLibrary(con, null, null, prefixId, tapeIdInt);
            gModel = new GraphModelTapeLibraryL2((GraphModelTapeLibraryL2.ID)rqst.getModelID());
            if (gTapeLibrary != null) {
                entityMap.put(prefixId + tapeId, gTapeLibrary);
                gModel.put(gTapeLibrary);
                this.getPortsFromTape(con, gModel, entityMap, prefixId, tapeIdInt);
                this.getSwitchFromTape(con, gModel, entityMap, prefixId, tapeIdInt);
                if ("tapelibrary:".equals(prefixId)) {
                    this.getTapeDrivesFromTape(con, gModel, entityMap, tapeIdInt);
                    this.getTapeMediaChanger(con, gModel, entityMap, tapeIdInt);
                }
                this.commit(con);
                this.getSansFromSwitch(con, (GraphModel)gModel, entityMap, prefixId, tapeIdInt);
                if (rqst.getModelID().isNeedZoneData()) {
                    this.getZonesFromTape(con, gModel, entityMap, prefixId, tapeIdInt);
                }
                this.commit(con);
                gModel.setWithZoneData(rqst.getModelID().isNeedZoneData());
                resp.addResponse(0, gModel);
            } else {
                resp.addResponse(0, gModel);
            }
        } else {
            resp.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerTapeLibraryL2.class.getName(), "getView", "");
        }
    }

    public void main(String[] args) {
    }
}

