/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmpagent.manager.data;

public class IPCapability {
    public static final int ADDED_CAPABILITY = 1;
    public static final int BROCADE = 4;
    public static final int CISCOMDS = 32;
    static final String className = IPCapability.class.getName();
    public static final int DISCOVERED = 2;
    public static final int ERROR = 1;
    public static final int NONE = 2;
    public static final int lastState = 2;
    public static final int MANUALLY_ENTERED = 1;
    public static final int NAS = 16;
    public static final int NO_CAPABILITY_CHANGE = 3;
    public static final int OK = 0;
    public static final int REMOVED_CAPABILITY = 2;
    public static final int SHARK = 8;
    public static final int STATISTICS = 2;
    public static final int TOPOLOGY = 1;
    private int capability = 0;
    private String iIpAddress = null;
    private int initialCapability = 0;
    private String iPassword = null;
    private String iUserId = null;

    public IPCapability(String address, String userId, String password) {
        String methodName = "IpTarget";
        this.iIpAddress = address;
        this.iUserId = userId;
        this.iPassword = password;
    }

    public int addCapability(int type) {
        int capability = 3;
        int currentCapability = this.getCapabilities();
        int newCapability = currentCapability | type;
        this.setCapabilities(newCapability);
        if ((currentCapability & type) == 0) {
            capability = 1;
        }
        return capability;
    }

    public boolean equals(Object o) {
        return o instanceof IPCapability && ((IPCapability)o).iIpAddress.equals(this.iIpAddress);
    }

    public int getCapabilities() {
        return this.capability;
    }

    public int getInitialCapabilities() {
        return this.initialCapability;
    }

    public String getIpAddress() {
        return this.iIpAddress;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public String getUserId() {
        return this.iUserId;
    }

    public boolean isBrocade() {
        return (this.getCapabilities() & 4) == 4;
    }

    public boolean isUserIdPasswordSet() {
        boolean ok = false;
        String userId = this.getUserId();
        String passwd = this.getPassword();
        if (userId != null && userId.length() > 0 && passwd != null && passwd.length() > 0) {
            ok = true;
        }
        return ok;
    }

    public int removeCapability(int type) {
        int capability = 3;
        int currentCapability = this.getCapabilities();
        int newCapability = currentCapability & ~type;
        this.setCapabilities(newCapability);
        if ((currentCapability & type) == type) {
            capability = 2;
        }
        return capability;
    }

    public void setCapabilities(int cap) {
        this.capability = cap;
    }

    public void setInitialCapabilities(int cap) {
        this.initialCapability = cap;
        this.capability = cap;
    }

    public int setPassword(String password) {
        int capability = 3;
        String currentPassword = this.iPassword;
        this.iPassword = password;
        if (password != null && password.length() > 0) {
            if (currentPassword == null) {
                capability = 1;
            } else if (currentPassword.length() == 0) {
                capability = 1;
            }
        }
        if (currentPassword != null && currentPassword.length() > 0) {
            if (password == null) {
                capability = 2;
            } else if (password.length() == 0) {
                capability = 2;
            }
        }
        return capability;
    }

    public int setUserId(String userId) {
        int capability = 3;
        String currentUserId = this.iUserId;
        this.iUserId = userId;
        if (userId != null && userId.length() > 0) {
            if (currentUserId == null) {
                capability = 1;
            } else if (currentUserId.length() == 0) {
                capability = 1;
            }
        }
        if (currentUserId != null && currentUserId.length() > 0) {
            if (userId == null) {
                capability = 2;
            } else if (userId.length() == 0) {
                capability = 2;
            }
        }
        return capability;
    }
}

