/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util;

import com.ibm.log.Level;
import com.ibm.log.util.MessageCatalog;
import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.util.resources.ServiceUtilMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceUtil
implements IDisposable {
    private Vector<ServiceCacheEntry> serviceCache = new Vector();
    private static final String RESOURCE_BUNDLE = ServiceUtilMessages.class.getName();
    private static MessageCatalog messageCatalog;
    private static final String CLASS_NAME;
    private static final String MSG = "aperi.logger.message.ServiceUtil";
    private static final String TRACE = "aperi.logger.trace.ServiceUtil";
    private static ILogger msgLogger;
    private static ILogger traceLogger;

    public void addService(IService serviceImpl, Class serviceInterface, Dictionary serviceProperties) {
        this.serviceCache.add(new ServiceCacheEntry(serviceImpl, serviceInterface, serviceProperties));
    }

    public void start(BundleContext context) throws Exception {
        for (ServiceCacheEntry currService : this.serviceCache) {
            try {
                if (!currService._started) {
                    this.startService(currService._serviceImpl);
                }
                currService._serviceRegistration = this.registerService(context, currService._serviceImpl, currService._serviceInterface, currService._serviceDictionary);
                currService._started = true;
            }
            catch (Exception e) {
                try {
                    msgLogger.message(Level.INFO, CLASS_NAME, "start", "STARTUP_FAILED_SHUTTING_DOWN");
                    this.stop();
                }
                catch (Exception stopException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    public void stop() throws Exception {
        Exception thrownException = null;
        while (!this.serviceCache.isEmpty()) {
            ServiceCacheEntry currService = this.serviceCache.lastElement();
            this.serviceCache.remove(currService);
            try {
                if (!currService._started) continue;
                this.unregisterService(currService._serviceRegistration, currService._serviceImpl.getName());
                this.stopService(currService._serviceImpl);
                currService._started = false;
            }
            catch (Exception e) {
                if (thrownException != null) continue;
                traceLogger.exception(Level.ERROR, CLASS_NAME, "stop", e, "Failed to stop service " + currService._serviceImpl.getName());
                thrownException = e;
            }
        }
        if (thrownException != null) {
            throw thrownException;
        }
    }

    private void startService(IService serviceImpl) throws Exception {
        Exception thrownException = null;
        boolean started = false;
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "startService", "STARTING_SERVICE", serviceImpl.getName());
        try {
            started = serviceImpl.startup();
        }
        catch (Throwable t) {
            thrownException = new Exception(messageCatalog.getMessage("FAILED_STARTUP", (Object)serviceImpl.getName()), t);
            traceLogger.exception(Level.ERROR, CLASS_NAME, "startService", thrownException);
        }
        if (!started) {
            msgLogger.message(Level.INFO, (Object)CLASS_NAME, "startService", "FAILED_STARTUP", serviceImpl.getName());
            if (thrownException == null) {
                thrownException = new Exception(messageCatalog.getMessage("FAILED_STARTUP", (Object)serviceImpl.getName()));
            }
            throw thrownException;
        }
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "startService", "STARTED_SERVICE", serviceImpl.getName());
    }

    private void stopService(IService serviceImpl) throws Exception {
        boolean stopped = false;
        Exception thrownException = null;
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "stopService", "STOPPING_SERVICE", serviceImpl.getName());
        try {
            stopped = serviceImpl.shutdown();
        }
        catch (Throwable t) {
            thrownException = new Exception(messageCatalog.getMessage("FAILED_STOP", (Object)serviceImpl.getName()), t);
            traceLogger.exception(Level.ERROR, CLASS_NAME, "stopService", thrownException);
        }
        if (!stopped) {
            msgLogger.message(Level.INFO, (Object)CLASS_NAME, "stopService", "FAILED_STOP", serviceImpl.getName());
            if (thrownException != null) {
                thrownException = new Exception(messageCatalog.getMessage("FAILED_STOP", (Object)serviceImpl.getName()));
            }
            throw thrownException;
        }
        msgLogger.message(Level.INFO, (Object)CLASS_NAME, "stopService", "STOPPED_SERVICE", serviceImpl.getName());
    }

    private ServiceRegistration registerService(BundleContext context, IService serviceImpl, Class serviceInterface, Dictionary serviceProperties) {
        ServiceRegistration serviceReg = null;
        traceLogger.text(Level.INFO, CLASS_NAME, "registerService", "Registering service: " + serviceImpl.getName());
        serviceReg = context.registerService(serviceInterface.getName(), (Object)serviceImpl, serviceProperties);
        traceLogger.text(Level.INFO, CLASS_NAME, "registerService", "Registration completed for service: " + serviceImpl.getName());
        return serviceReg;
    }

    private void unregisterService(ServiceRegistration serviceReg, String serviceName) {
        traceLogger.text(Level.INFO, CLASS_NAME, "unregisterService", "Unregistering service: " + serviceName);
        Bundle[] usingBundles = serviceReg.getReference().getUsingBundles();
        if (usingBundles != null && usingBundles.length > 0) {
            StringBuffer warningMsg = new StringBuffer();
            warningMsg.append("The service " + serviceName + " is being unregistered" + " but it is still in use by the following bundles: \n");
            for (int i = 0; i < usingBundles.length; ++i) {
                warningMsg.append("  ");
                warningMsg.append(usingBundles[i].getLocation());
                if (i == usingBundles.length - 1) continue;
                warningMsg.append("\n");
            }
            traceLogger.text(Level.WARN, CLASS_NAME, "unregisterService", warningMsg.toString());
        }
        serviceReg.unregister();
        traceLogger.text(Level.INFO, CLASS_NAME, "unregisterService", "Unregistered service: " + serviceName);
    }

    public void dispose() {
        this.serviceCache = null;
    }

    static {
        CLASS_NAME = ServiceUtil.class.getName();
        msgLogger = LogManagerFactory.getMessageLogger(MSG);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE);
        msgLogger.setMessageFile(RESOURCE_BUNDLE);
        messageCatalog = new MessageCatalog(RESOURCE_BUNDLE);
    }

    private class ServiceCacheEntry {
        private IService _serviceImpl = null;
        private Class _serviceInterface = null;
        private Dictionary _serviceDictionary = null;
        private ServiceRegistration _serviceRegistration = null;
        private boolean _started = false;

        public ServiceCacheEntry(IService serviceImpl, Class serviceInterface, Dictionary serviceProperties) {
            this._serviceImpl = serviceImpl;
            this._serviceInterface = serviceInterface;
            this._serviceDictionary = serviceProperties;
            this._serviceRegistration = null;
        }
    }
}

