/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware;

import com.ibm.log.Level;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.soap.encoding.soapenc.Base64;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Server;
import org.eclipse.aperi.internal.server.device.DeviceServerActivator;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.DBAccess;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Roles;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SessionContext;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.osgi.framework.ServiceReference;

public class DeviceServiceManager
implements Runnable,
IService,
IDeviceServiceManager,
ICliDispatcher {
    public static final long DEFAULT_MONITOR_INTERVAL = 60000L;
    private static final String setupFile = "setup.properties";
    public static final String MONITOR_INTERVAL = "monitorInterval";
    public static final String DS_FILE = "DeployedServices.ds";
    public static final String CONFIG_DIR = "configuration";
    private static Boolean started = Boolean.FALSE;
    private static Status status = new Status(5, 6);
    private static Hashtable<String, IService> serviceTable = new Hashtable();
    private static Thread daemonThread;
    private Properties setupProps = new Properties();
    private static DeviceServiceManager instance;
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManager";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.resources.TSNMServiceManagerText";
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    static final String TRACE_NAME = "aperi.logger.trace.TSNMServiceManager";
    static final String MESSAGE_NAME = "aperi.logger.message.TSNMServiceManager";
    static long startupTime;
    private static FileLock rFl;
    private static FileChannel rFc;
    private static PrintStream rPs;
    private static FileOutputStream rFos;

    public DeviceServiceManager() {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(BUNDLENAME);
        SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
    }

    public void run() {
        String className = this.getName();
        String methodName = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "run");
        }
        try {
            String configDir = Variables.getConfigurationDirectory();
            FileInputStream fis = new FileInputStream(configDir + File.separator + setupFile);
            Properties setupProperties = new Properties();
            setupProperties.load(fis);
            String deviceType = setupProperties.getProperty("tsnm.type");
            if ("manager".equals(deviceType)) {
                this.registerServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        status.setRunStatus(4);
        this.setServiceRoleAndLicenseMappings();
        status.setRunStatus(8);
        this.monitor();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, this.getClass(), "run");
        }
    }

    public String handshake(String clientPublicKey) {
        String serverPublicKeyEncEncrypted = null;
        try {
            KeyAgreement serverKeyAgree = null;
            PublicKey clientPubKey = null;
            try {
                byte[] clientPubKeyEnc = MiddlewareCrypto.decrypt((byte[])Base64.decode((String)clientPublicKey));
                KeyFactory serverKeyFac = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(clientPubKeyEnc);
                clientPubKey = serverKeyFac.generatePublic(x509KeySpec);
                DHParameterSpec dhParamSpec = ((DHPublicKey)clientPubKey).getParams();
                KeyPairGenerator serverKpairGen = KeyPairGenerator.getInstance("DH");
                serverKpairGen.initialize(dhParamSpec);
                KeyPair serverKpair = serverKpairGen.generateKeyPair();
                byte[] serverPubKeyEnc = serverKpair.getPublic().getEncoded();
                serverPublicKeyEncEncrypted = Base64.encode((byte[])MiddlewareCrypto.encrypt((byte[])serverPubKeyEnc));
                serverKeyAgree = KeyAgreement.getInstance("DH");
                serverKeyAgree.init(serverKpair.getPrivate());
                SessionContext.successfulHandshake();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create Server key pair: " + e.toString());
            }
            try {
                serverKeyAgree.doPhase(clientPubKey, true);
                SecretKey serverSecretKey = serverKeyAgree.generateSecret("DES");
                SessionContext.setSecretKey((SecretKey)serverSecretKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create Key Agreement: " + e.toString());
            }
        }
        catch (Exception e) {
            String hostname = SessionContext.getRemoteHostname();
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "handshake", "TSNMServiceManager_ServerAuthenticationFailed", (Object)hostname);
        }
        return serverPublicKeyEncEncrypted;
    }

    public Status getStatus(String serviceName) {
        Status status = null;
        String methodName = "getStatus";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getStatus");
        }
        if (serviceTable.containsKey(serviceName)) {
            try {
                status = serviceTable.get(serviceName).getStatus();
            }
            catch (Exception e) {
                Object[] inserts = new Object[]{serviceName, e.toString()};
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "getStatus", "TSNMServiceManager_ExcGettingStatus", inserts);
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "getStatus", (Throwable)e);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getStatus");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startup() {
        String methodName = "startup";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "startup");
        }
        Boolean bl = started;
        synchronized (bl) {
            if (started.booleanValue()) {
                return true;
            }
            started = Boolean.TRUE;
        }
        status.setRunStatus(9);
        this.deleteDSFile();
        serviceTable.clear();
        if (rFl == null) {
            msgLogger.text(IRecordType.TYPE_ERR, (Object)this, "startup", "NULL_LOCK");
            return true;
        }
        System.err.println("Starting Device Server");
        daemonThread = new Thread(this);
        daemonThread.start();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "startup");
        }
        return true;
    }

    public synchronized boolean shutdown() {
        status.setRunStatus(11);
        String methodName = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName);
        }
        if (daemonThread != null) {
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "TSNMServiceManager_InterruptingMonitor");
            daemonThread.interrupt();
            try {
                daemonThread.join();
                daemonThread = null;
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "TSNMServiceManagerCli_CaughtException", (Object)e.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            }
        }
        status.setRunStatus(10);
        started = Boolean.FALSE;
        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "TSNMServiceManager_ShuttingDown");
        StringBuffer shutdownMsg = new StringBuffer();
        Date stopDate = new Date();
        shutdownMsg.append(DateFormat.getDateInstance(3).format(stopDate));
        shutdownMsg.append(" ");
        shutdownMsg.append(DateFormat.getTimeInstance(1).format(stopDate));
        shutdownMsg.append("  Stopped Device Server");
        System.err.println(shutdownMsg.toString());
        this.deleteDSFile();
        serviceTable.clear();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName);
        }
        return true;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "DeviceServiceManager";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("TSNMServiceManager_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("TSNMServiceManager_Description");
    }

    public String getDescription() {
        return "Framework";
    }

    public Status getStatus() {
        return status;
    }

    public String dispatch(String methodName, String[] args) {
        return CliDispatcher.dispatch((Object)this, (String)methodName, (String[])args);
    }

    public static DeviceServiceManager getInstance() {
        if (instance == null) {
            instance = new DeviceServiceManager();
        }
        return instance;
    }

    public Object getTargetObject(String targetObjectURI) {
        DeviceServiceManager obj = null;
        if (targetObjectURI.equals("DeviceServiceManager")) {
            obj = this;
        }
        return obj;
    }

    private boolean registerServer() {
        try {
            String baseDir = Variables.getBaseDirectory();
            String propFile = baseDir + File.separator + CONFIG_DIR + File.separator + setupFile;
            FileInputStream fis = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(fis);
            String port = props.getProperty("manager.port");
            String type = props.getProperty("tsnm.type");
            String password = props.getProperty("installationPass");
            System.err.println("Port = " + port + "\n" + "Type = " + type + "\n" + "Password = " + password + "\n");
            if (type == null || port == null || password == null) {
                System.err.println("Incomplete database connection properties");
                return false;
            }
            DBConnPoolDataSource pool = DBConnPoolDataSource.getInstance();
            DBConnection dbc = null;
            Server.ServerCursor serverCursor = null;
            String hostname = InetAddress.getLocalHost().getHostName();
            Server sv = null;
            try {
                dbc = (DBConnection)pool.getPooledConnection();
                Hashtable<ColumnInfo, String> ht = new Hashtable<ColumnInfo, String>();
                ht.put(Server.getColumnInfo((String)"SERVER_TYPE"), Integer.toString(1));
                ht.put(Server.getColumnInfo((String)"SERVER_NAME"), InetAddress.getLocalHost().getHostName());
                serverCursor = Server.getCursor((DBConnection)dbc, ht, null);
                if (!serverCursor.next()) {
                    sv = new Server();
                    sv.setServerId(AutoIdentifier.getIdentifier((int)1, (int)1));
                    sv.setServerName(hostname);
                    sv.setServerToken(0.0);
                    sv.setComputerId(0);
                    sv.setPortNumber(Integer.parseInt(port));
                    sv.setServerType(1);
                    sv.setPassword(password);
                    sv.insert(dbc);
                    dbc.commit();
                }
                serverCursor.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (dbc == null) {
                return false;
            }
            try {
                dbc.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (sv != null) {
                new DBAccess().syncInstallPassword("" + sv.getServerId(), sv.getPassword());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void monitor() {
        long monitorInterval;
        Long miL = null;
        String methodName = "monitor";
        String baseDir = Variables.getBaseDirectory();
        String propBaseFn = baseDir + File.separator + CONFIG_DIR + File.separator;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "monitor");
        }
        try {
            this.readProps(propBaseFn + setupFile, this.setupProps);
            String mi = this.setupProps.getProperty(MONITOR_INTERVAL);
            miL = Long.valueOf(mi);
            monitorInterval = miL * 1000L;
            if (monitorInterval <= 0L) {
                monitorInterval = 60000L;
            }
        }
        catch (Exception e) {
            monitorInterval = 60000L;
        }
        msgLogger.message(IRecordType.TYPE_WARN, (Object)this, "monitor", "TSNMServiceManager_Monitoring", (Object)new Long(monitorInterval / 1000L));
        ServiceReference[] srs = null;
        String serviceName = null;
        while (!Thread.interrupted()) {
            try {
                srs = DeviceServerActivator.getContext().getAllServiceReferences(IService.class.getName(), null);
                if (srs != null) {
                    for (int i = 0; i < srs.length; ++i) {
                        serviceName = (String)srs[i].getProperty("org.eclipse.aperi.webservice.name");
                        if (serviceTable.containsKey(serviceName)) continue;
                        serviceTable.put(serviceName, (IService)DeviceServerActivator._serviceHelper.bindLocal(serviceName));
                    }
                }
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManagerCli_CaughtException", (Object)e.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "monitor", (Throwable)e);
            }
            try {
                Thread.sleep(monitorInterval);
            }
            catch (InterruptedException ie) {
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "monitor");
                }
                return;
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManagerCli_CaughtException", (Object)e.toString());
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "monitor", (Throwable)e);
            }
            Enumeration<String> keys = serviceTable.keys();
            while (keys.hasMoreElements()) {
                serviceName = keys.nextElement();
                IService service = serviceTable.get(serviceName);
                if (service.getStatus().getInstallStatus() != 5 || service.getStatus().getRunStatus() != 8) continue;
                try {
                    service.getStatus();
                }
                catch (RuntimeException e) {
                    msgLogger.exception(IRecordType.TYPE_WARN, (Object)this, "monitor", (Throwable)e);
                }
                Object[] inserts = new Object[]{serviceName, status.getRunStatusAsText()};
                if (status == null) continue;
                if (status.getRunStatus() == 2) {
                    service.getStatus().setRunStatus(2);
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManager_StatusMsg", inserts);
                    continue;
                }
                if (status.getRunStatus() != 10) continue;
                service.getStatus().setRunStatus(10);
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManager_StatusMsg", inserts);
            }
            if (status.getRunStatus() != 10) continue;
            return;
        }
        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "monitor", "TSNMServiceManager_MonitorExits");
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "monitor");
        }
    }

    private void deleteDSFile() {
        String methodName = "deleteDSFile";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "deleteDSFile");
        }
        String dsFileName = CONFIG_DIR + File.separator + DS_FILE;
        System.out.println("dsFileName = " + dsFileName);
        File dsFile = new File(dsFileName);
        if (dsFile.exists()) {
            if (dsFile.delete()) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "deleteDSFile", "TSNMServiceManager_DeletedFile", (Object)dsFileName);
            } else {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, "deleteDSFile", "TSNMServiceManager_CouldNotDeleteFile", (Object)dsFileName);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "deleteDSFile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readProps(String propFn, Properties loadProps) {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "readConnectionProps", (Object)"entered");
        }
        int retCode = 0;
        FileInputStream in = null;
        try {
            in = new FileInputStream(propFn);
            loadProps.load(in);
            if (traceLogger.isLogging()) {
                for (String string : loadProps.keySet()) {
                    String value = loadProps.getProperty(string);
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "readConnectionProps", "SAN DB Connection parm: " + string + " = " + value);
                }
            }
            msgLogger.message(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "readConnectionProps", "TSNMServiceManager_successfulReadingParms", (Object)propFn);
        }
        catch (Exception e) {
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this.getClass().getName(), "readConnectionProps", "TSNMServiceManager_errorReadingParms", (Object)propFn);
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "readConnectionProps", (Throwable)e);
            retCode = -1;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "readConnectionProps", (Throwable)e);
                }
            }
            in = null;
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "readConnectionProps", (Object)"exited");
            }
        }
        return retCode;
    }

    public String[] getListOfServices() {
        ArrayList<String> services = new ArrayList<String>();
        Enumeration<String> e = serviceTable.keys();
        while (e.hasMoreElements()) {
            String serviceName = e.nextElement();
            services.add(serviceName);
        }
        return services.toArray(new String[0]);
    }

    public HashMap getServiceProperties(String serviceName, Locale locale) {
        IService service = serviceTable.get(serviceName);
        if (service == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ID", service.getClass().getName());
        properties.put("Name", service.getLocalizedName(locale));
        properties.put("Available", new Boolean(service.getStatus().getRunStatus() == 8).toString());
        properties.put("DeployedStatus", service.getStatus().getInstallStatusAsText());
        properties.put("RunStatus", (String)service.getStatus());
        properties.put("Status", service.getStatus().getLocalizedStatusAsText(locale));
        properties.put("Version", service.getVersion());
        properties.put("Description", service.getLocalizedDescription(locale));
        return properties;
    }

    public long getStartupTime() {
        return startupTime;
    }

    public long getElapseTime() {
        return System.currentTimeMillis() - startupTime;
    }

    public long getVMSize() {
        return Runtime.getRuntime().totalMemory();
    }

    public int getRoleBitmap() {
        int returnVal = 0;
        if (SessionContext.isUserInRole((String)"itsrmAdmin")) {
            returnVal = 1 | returnVal;
        }
        if (SessionContext.isUserInRole((String)"itsrmViewer")) {
            returnVal = 2 | returnVal;
        }
        return returnVal;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("getListOfServices", new Integer(RoleChecker.SUPERUSER));
        roleMap.put("getServiceProperties", new Integer(RoleChecker.SUPERUSER));
        return roleMap;
    }

    public void refreshRoleCache() throws SQLException {
        Roles.refresh();
    }

    private void setServiceRoleAndLicenseMappings() {
        String methodName = "setServiceRoleAndLicenseMappings";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "setServiceRoleAndLicenseMappings");
        }
        Enumeration<String> keys = serviceTable.keys();
        while (keys.hasMoreElements()) {
            try {
                IService service = serviceTable.get(keys.nextElement());
                Hashtable roleMap = service.getRoleMap();
                if (roleMap == null) continue;
                Enumeration e = roleMap.keys();
                while (e.hasMoreElements()) {
                    String function = (String)e.nextElement();
                    Integer roles = (Integer)roleMap.get(function);
                    RPCSecureJavaProvider.setRoleMapping((String)service.getName(), (String)function, (Integer)roles);
                }
            }
            catch (Throwable t) {
                traceLogger.exception(Level.DEBUG_MIN, (Object)this, "setServiceRoleAndLicenseMappings", t);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "setServiceRoleAndLicenseMappings");
        }
    }

    static {
        instance = null;
        msgLogger = null;
        traceLogger = null;
        startupTime = 0L;
        rFl = null;
        rFc = null;
        rPs = null;
        rFos = null;
        try {
            String baseDir = Variables.getBaseDirectory();
            if (baseDir != null && baseDir.length() > 0) {
                String lockFile = baseDir + File.separator + "tmp" + File.separator + "runLock";
                rFos = new FileOutputStream(lockFile);
                rFc = rFos.getChannel();
                rFl = rFc.tryLock();
                if (rFl == null) {
                    throw new Exception("NULL_LOCK");
                }
                Date now = new Date();
                rPs = new PrintStream(rFos, true);
                rPs.println("DATE=\"" + now.toString() + "\"");
                rPs.println("EPOCH=" + now.getTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

