/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.Logger;

public class BasicLogger
extends Logger {
    static final long serialVersionUID = 4164798310777932546L;

    public BasicLogger() {
    }

    public BasicLogger(String name) {
        super(name);
    }

    public void message(String key) {
        if (this.isLogging()) {
            this.logMessage(key, this.getMessageFile(), null);
        }
    }

    public void message(String key, Object insert1) {
        if (this.isLogging()) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(key, this.getMessageFile(), inserts);
        }
    }

    public void message(String key, Object insert1, Object insert2) {
        if (this.isLogging()) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(key, this.getMessageFile(), inserts);
        }
    }

    public void message(String key, Object[] inserts) {
        if (this.isLogging()) {
            this.logMessage(key, this.getMessageFile(), inserts);
        }
    }

    public void msg(String key, String file) {
        if (this.isLogging()) {
            this.logMessage(key, file, null);
        }
    }

    public void msg(String key, String file, Object insert1) {
        if (this.isLogging()) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(key, file, inserts);
        }
    }

    public void msg(String key, String file, Object insert1, Object insert2) {
        if (this.isLogging()) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(key, file, inserts);
        }
    }

    public void msg(String key, String file, Object[] inserts) {
        if (this.isLogging()) {
            this.logMessage(key, file, inserts);
        }
    }

    public void text(String text) {
        if (this.isLogging()) {
            this.logText(text, null);
        }
    }

    public void text(String text, Object insert1) {
        if (this.isLogging()) {
            Object[] inserts = new Object[]{insert1};
            this.logText(text, inserts);
        }
    }

    public void text(String text, Object insert1, Object insert2) {
        if (this.isLogging()) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(text, inserts);
        }
    }

    public void text(String text, Object[] inserts) {
        if (this.isLogging()) {
            this.logText(text, inserts);
        }
    }

    public void entry() {
        if (this.isLogging()) {
            this.logText("Entry", null);
        }
    }

    public void entry(Object parm1) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{BasicLogger.objToStr(parm1)};
            this.logText("Entry, parm 1 = {0}", parms);
        }
    }

    public void entry(Object parm1, Object parm2) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{BasicLogger.objToStr(parm1), BasicLogger.objToStr(parm2)};
            this.logText("Entry, parm 1 = {0}, parm 2 = {1}", parms);
        }
    }

    public void entry(Object[] parms) {
        if (this.isLogging()) {
            StringBuffer bfr = new StringBuffer("Entry");
            Object[] strs = null;
            if (parms != null) {
                strs = new String[parms.length];
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", parm " + (j + 1) + " = {" + j + "}");
                    strs[j] = BasicLogger.objToStr(parms[j]);
                }
            }
            this.logText(bfr.toString(), strs);
        }
    }

    public void exit() {
        if (this.isLogging()) {
            this.logText("Exit", null);
        }
    }

    public void exit(byte retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Byte(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(short retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Short(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(int retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Integer(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(long retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Long(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(float retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Float(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(double retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Double(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(char retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Character(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(boolean retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exit(Object retValue) {
        if (this.isLogging()) {
            Object[] parms = new Object[]{BasicLogger.objToStr(retValue)};
            this.logText("Exit, return value = {0}", parms);
        }
    }

    public void exception(Throwable throwable) {
        if (this.isLogging()) {
            LogEvent event = new LogEvent(throwable);
            this.logAndWarn(event);
        }
    }

    public void exception(Throwable throwable, String text) {
        if (this.isLogging()) {
            LogEvent event = new LogEvent(throwable, text);
            this.logAndWarn(event);
        }
    }

    private void logMessage(String key, String file, Object[] inserts) {
        LogEvent event = new LogEvent(key, file, inserts);
        this.logAndWarn(event);
    }

    private void logText(String text, Object[] inserts) {
        LogEvent event = new LogEvent(text, inserts);
        this.logAndWarn(event);
    }
}

