/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.CBEGlobalInstanceID;
import com.ibm.log.util.CBEMsgID;
import com.ibm.log.util.ISO8601DateFormat;
import com.ibm.log.util.XMLUtil;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CBE101Formatter
extends Formatter {
    private static final int CBE_1024_CHUNK_SIZE = 1024;
    private final ISO8601DateFormat iso8601DateFormat = new ISO8601DateFormat();
    private boolean forceAsMessage = false;
    private boolean forceAsTrace = false;

    public CBE101Formatter() {
    }

    public CBE101Formatter(String name) {
        super(name);
    }

    public String format(LogEvent event) {
        StringBuffer buff = new StringBuffer();
        if (null != event) {
            Iterator attribs;
            String stackTrace;
            Level traceLevel;
            boolean isMsg = this.treatAsMessage(event);
            int msgIdTypeIndex = 0;
            int msgIdLen = 0;
            String msgIdType = null;
            String msgId = null;
            String[] msgChunks = XMLUtil.escapeXMLChunks(this.getMessage(event), 1024);
            if (isMsg && null != msgChunks && msgChunks.length > 0) {
                msgIdTypeIndex = CBEMsgID.getTypeIndex(msgChunks[0]);
                msgIdLen = CBEMsgID.getIdLen(msgIdTypeIndex);
                msgIdType = CBEMsgID.getIdType(msgIdTypeIndex);
                if (0 != msgIdLen) {
                    msgId = msgChunks[0].substring(0, msgIdLen);
                }
            }
            String correlationId = XMLUtil.escapeXMLString(event.getCorrelationId());
            String sourceFileName = XMLUtil.escapeXMLString(event.getLoggingClass());
            String sourceMethod = XMLUtil.escapeXMLString(event.getLoggingMethod());
            String principal = XMLUtil.escapeXMLString(event.getClient());
            buff.append("<CommonBaseEvent");
            this.appendCBECreationTime(event, buff);
            if (isMsg) {
                buff.append(" extensionName=\"ibmcbe:Message-LogXML\"");
            } else {
                buff.append(" extensionName=\"ibmcbe:Trace-LogXML\"");
            }
            buff.append(" globalInstanceId=\"");
            CBEGlobalInstanceID.appendCBE101GUID(buff);
            buff.append("\"");
            if (msgChunks.length > 0) {
                buff.append(" msg=\"");
                buff.append(msgChunks[0]);
                buff.append("\"");
            }
            this.appendCBESeverity(isMsg, msgId, buff);
            buff.append(" version=\"1.0.1\">");
            if (msgChunks.length > 1) {
                for (int i = 1; i < msgChunks.length; ++i) {
                    String chunkName = "message_" + Integer.toString(i - 1);
                    this.appendCBEExtendedDataElements(chunkName, msgChunks[i], buff);
                }
            }
            if (CBE101Formatter.stringHasValue(correlationId)) {
                this.appendCBEExtendedDataElements("LogXML:CorrelationId", correlationId, buff);
            }
            if (CBE101Formatter.stringHasValue(sourceFileName)) {
                this.appendCBEExtendedDataElements("LogXML:FileName", sourceFileName, buff);
            }
            if (CBE101Formatter.stringHasValue(sourceMethod)) {
                this.appendCBEExtendedDataElements("LogXML:Method", sourceMethod, buff);
            }
            if (CBE101Formatter.stringHasValue(principal)) {
                this.appendCBEExtendedDataElements("LogXML:Principal", principal, buff);
            }
            if (!isMsg && null != (traceLevel = event.getLevel())) {
                this.appendCBEExtendedDataElements("LogXML:Level", traceLevel.getName(), buff);
            }
            if (!isMsg && CBE101Formatter.stringHasValue(stackTrace = event.getStackTrace())) {
                String[] stackChunks = XMLUtil.escapeXMLChunks(stackTrace, 1024);
                this.appendCBEExtendedDataElements("LogXML:Exception", stackChunks, buff);
            }
            if ((attribs = event.getKeysAndValues()) != null) {
                while (attribs.hasNext()) {
                    Map.Entry entry = (Map.Entry)attribs.next();
                    String key = XMLUtil.escapeXMLString((String)entry.getKey());
                    String val = XMLUtil.escapeXMLString((String)entry.getValue());
                    this.appendCBEExtendedDataElements("LogXML:LogAttribs:" + key, val, buff);
                }
            }
            this.appendSourceComponentId(event, isMsg, buff);
            if (isMsg) {
                this.appendMsgDataElement(event, msgId, msgIdType, buff);
            }
            this.appendSituation(isMsg, buff);
            buff.append("</CommonBaseEvent>");
        }
        return buff.toString();
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        if (null == props) {
            props = new Properties();
        }
        props.put("forceAsMessage", new Boolean(this.forceAsMessage).toString());
        props.put("forceAsTrace", new Boolean(this.forceAsTrace).toString());
        return props;
    }

    public void setConfig(Properties cfg) {
        if (null != cfg) {
            super.setConfig(cfg);
            String prop = cfg.getProperty("forceAsMessage");
            if (null != prop) {
                this.setForceAsMessage(new Boolean(prop));
            }
            if (null != (prop = cfg.getProperty("forceAsTrace"))) {
                this.setForceAsTrace(new Boolean(prop));
            }
        }
    }

    public boolean isForceAsMessage() {
        return this.forceAsMessage;
    }

    public void setForceAsMessage(boolean asMsg) {
        this.forceAsMessage = asMsg;
    }

    public boolean isForceAsTrace() {
        return this.forceAsTrace;
    }

    public void setForceAsTrace(boolean asTrc) {
        this.forceAsTrace = asTrc;
    }

    private boolean treatAsMessage(LogEvent event) {
        boolean isMsg = this.forceAsMessage == this.forceAsTrace ? event != null && event.getMessageFile() != null : this.forceAsMessage;
        return isMsg;
    }

    private void appendCBECreationTime(LogEvent event, StringBuffer buff) {
        if (null != event && null != buff) {
            Date date = new Date(event.getTimeStamp());
            buff.append(" creationTime=\"");
            this.iso8601DateFormat.format(date, buff, new FieldPosition(0));
            buff.append("\"");
        }
    }

    private void appendCBESeverity(boolean isMsg, String msgId, StringBuffer buff) {
        if (null != buff) {
            String sev = null;
            if (isMsg && CBE101Formatter.stringHasValue(msgId)) {
                if (msgId.endsWith("I")) {
                    sev = "10";
                } else if (msgId.endsWith("W")) {
                    sev = "30";
                } else if (msgId.endsWith("E")) {
                    sev = "50";
                }
            } else {
                sev = "10";
            }
            if (null != sev) {
                buff.append(" severity=\"");
                buff.append(sev);
                buff.append("\"");
            }
        }
    }

    private void appendCBEExtendedDataElements(String name, String value, StringBuffer buff) {
        if (null != buff && CBE101Formatter.stringHasValue(value)) {
            buff.append("<extendedDataElements name=\"");
            buff.append(name);
            buff.append("\" type=\"string\"><values>");
            buff.append(value);
            buff.append("</values></extendedDataElements>");
        }
    }

    private void appendCBEExtendedDataElements(String name, String[] values, StringBuffer buff) {
        if (null != buff && null != values) {
            buff.append("<extendedDataElements name=\"");
            buff.append(name);
            buff.append("\" type=\"string\">");
            for (int i = 0; i < values.length; ++i) {
                buff.append("<values>");
                buff.append(values[i]);
                buff.append("</values>");
            }
            buff.append("</extendedDataElements>");
        }
    }

    private void appendSourceComponentId(LogEvent event, boolean isMsg, StringBuffer buff) {
        if (null != buff && null != event) {
            String threadName;
            String componentType = "http://www.ibm.com/namespaces/autonomic/Tivoli_componentTypes";
            String prodComponent = XMLUtil.escapeXMLString(event.getProduct());
            String subComponent = XMLUtil.escapeXMLString(event.getComponent());
            String prodInstance = XMLUtil.escapeXMLString(event.getProductInstance());
            String location = XMLUtil.escapeXMLString(event.getServer());
            String serverFmt = event.getServerFormat();
            String locationType = !CBE101Formatter.stringHasValue(serverFmt) || serverFmt.equalsIgnoreCase("OTHER") ? "Unknown" : (serverFmt.equalsIgnoreCase("IP") ? "IPV4" : serverFmt);
            buff.append("<sourceComponentId");
            buff.append(" component=\"");
            buff.append(prodComponent);
            buff.append("\" componentIdType=\"Unknown\" instanceId=\"");
            buff.append(prodInstance);
            buff.append("\" location=\"");
            buff.append(location);
            buff.append("\" locationType=\"");
            buff.append(locationType);
            buff.append("\" subComponent=\"");
            buff.append(subComponent);
            if (!isMsg && CBE101Formatter.stringHasValue(threadName = XMLUtil.escapeXMLString(event.getThreadName()))) {
                buff.append("\" threadId=\"");
                buff.append(threadName);
            }
            buff.append("\" componentType=\"");
            buff.append("http://www.ibm.com/namespaces/autonomic/Tivoli_componentTypes");
            buff.append("\"/>");
        }
    }

    private void appendSituation(boolean isMsg, StringBuffer buff) {
        if (null != buff) {
            buff.append("<situation categoryName=\"ReportSituation\">");
            buff.append("<situationType");
            buff.append(" xsi:type=\"ReportSituation\"");
            buff.append(" reasoningScope=\"INTERNAL\"");
            if (isMsg) {
                buff.append(" reportCategory=\"LOG\"");
            } else {
                buff.append(" reportCategory=\"TRACE\"");
            }
            buff.append("/></situation>");
        }
    }

    private void appendMsgDataElement(LogEvent event, String msgId, String msgIdType, StringBuffer buff) {
        if (null != buff && null != event) {
            String catalogName = XMLUtil.escapeXMLString(event.getMessageFile());
            String catalogKey = XMLUtil.escapeXMLString(event.getMessageKey());
            Object[] catalogTokens = event.getInserts();
            buff.append("<msgDataElement>");
            if (null != catalogTokens) {
                for (int i = 0; i < catalogTokens.length; ++i) {
                    String nextToken = null;
                    if (null != catalogTokens[i]) {
                        nextToken = catalogTokens[i].toString();
                    }
                    buff.append("<msgCatalogTokens value=\"");
                    buff.append(XMLUtil.escapeXMLString(nextToken));
                    buff.append("\"/>");
                }
            }
            if (CBE101Formatter.stringHasValue(msgId) && CBE101Formatter.stringHasValue(msgIdType)) {
                buff.append("<msgId>");
                buff.append(msgId);
                buff.append("</msgId>");
                buff.append("<msgIdType>");
                buff.append(msgIdType);
                buff.append("</msgIdType>");
            }
            if (CBE101Formatter.stringHasValue(catalogKey)) {
                buff.append("<msgCatalogId>");
                buff.append(catalogKey);
                buff.append("</msgCatalogId>");
            }
            if (CBE101Formatter.stringHasValue(catalogName)) {
                buff.append("<msgCatalogType>JAVA</msgCatalogType>");
                buff.append("<msgCatalog>");
                buff.append(catalogName);
                buff.append("</msgCatalog>");
            }
            buff.append("</msgDataElement>");
        }
    }

    private static boolean stringHasValue(String s) {
        return s != null && s.length() > 0;
    }
}

