/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.LogEvent;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogEventListener;
import com.ibm.log.LogEventProducerImpl;
import com.ibm.log.util.ErrorProtocol;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageErrorProtocol;
import java.util.Properties;

public abstract class Handler
extends LogEventProducerImpl
implements LogEventListener {
    protected boolean open = false;
    private ErrorProtocol errorProtocol = new MessageErrorProtocol();
    private LogEventFormatter formatter = new Formatter();
    protected transient Object deviceLock = new Object();
    private String formatterName = null;
    private String errorProtocolName = null;

    public Handler() {
    }

    public Handler(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        if (this.errorProtocolName != null) {
            props.put("errorProtocolName", this.errorProtocolName);
        }
        if (this.formatterName != null) {
            props.put("formatterName", this.formatterName);
        }
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("errorProtocolName");
        if (prop != null) {
            this.errorProtocolName = prop;
        }
        if ((prop = props.getProperty("formatterName")) != null) {
            this.formatterName = prop;
        }
    }

    public ErrorProtocol getErrorProtocol() {
        return this.errorProtocol;
    }

    public void setErrorProtocol(ErrorProtocol protocol) {
        if (protocol != null) {
            this.errorProtocol = protocol;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setErrorProtocol");
            LogUtil.errorMsg(msg);
        }
    }

    public LogEventFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(LogEventFormatter formatter) {
        if (formatter != null) {
            this.formatter = formatter;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setFormatter");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open = false;
        }
    }

    public synchronized void process(LogEvent event) {
        if (this.errorProtocol.isCleanupRequired()) {
            this.errorProtocol.cleanup(this);
        }
        try {
            this.write(event);
        }
        catch (Exception e) {
            this.errorProtocol.error(this, event, e);
        }
        this.log(event);
    }

    public abstract void write(LogEvent var1) throws Exception;
}

