/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.MessageCatalog;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class PDXMLFormatter
extends Formatter {
    static final long serialVersionUID = 1448798864185043580L;
    private boolean singleComponent = false;
    private boolean singleProductId = false;
    private boolean singleProductInstance = false;
    private boolean singleServer = false;
    private boolean isFirstRecord = true;
    private boolean forceAsMessage = false;
    private boolean forceAsTrace = false;
    private static final int MIN_MSG_ID_LEN = 8;
    private static final int MAX_MSG_ID_LEN = 10;
    private static final String timeZone = TimeZone.getDefault().getDisplayName(false, 0);

    public PDXMLFormatter() {
    }

    public PDXMLFormatter(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("singleComponent", new Boolean(this.singleComponent).toString());
        props.put("singleProductId", new Boolean(this.singleProductId).toString());
        props.put("singleProductInstance", new Boolean(this.singleProductInstance).toString());
        props.put("singleServer", new Boolean(this.singleServer).toString());
        props.put("forceAsMessage", new Boolean(this.forceAsMessage).toString());
        props.put("forceAsTrace", new Boolean(this.forceAsTrace).toString());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("singleComponent");
        if (prop != null) {
            this.setSingleComponent(new Boolean(prop));
        }
        if ((prop = props.getProperty("singleProductId")) != null) {
            this.setSingleProductId(new Boolean(prop));
        }
        if ((prop = props.getProperty("singleProductInstance")) != null) {
            this.setSingleProductInstance(new Boolean(prop));
        }
        if ((prop = props.getProperty("singleServer")) != null) {
            this.setSingleServer(new Boolean(prop));
        }
        if ((prop = props.getProperty("forceAsMessage")) != null) {
            this.forceAsMessage = new Boolean(prop);
        }
        if ((prop = props.getProperty("forceAsTrace")) != null) {
            this.forceAsTrace = new Boolean(prop);
        }
    }

    public boolean isSingleComponent() {
        return this.singleComponent;
    }

    public void setSingleComponent(boolean flag) {
        this.singleComponent = flag;
    }

    public boolean isSingleProductId() {
        return this.singleProductId;
    }

    public void setSingleProductId(boolean flag) {
        this.singleProductId = flag;
    }

    public boolean isSingleProductInstance() {
        return this.singleProductInstance;
    }

    public void setSingleProductInstance(boolean flag) {
        this.singleProductInstance = flag;
    }

    public boolean isSingleServer() {
        return this.singleServer;
    }

    public void setSingleServer(boolean flag) {
        this.singleServer = flag;
    }

    public String format(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        if (this.isFirstRecord) {
            this.getProductInfo(bfr, event, this.singleComponent, this.singleProductId, this.singleProductInstance, this.singleServer);
            this.isFirstRecord = false;
        }
        boolean formatAsMsg = this.forceAsMessage == this.forceAsTrace ? event.getMessageFile() != null : this.forceAsMessage;
        String logText = this.getMessage(event);
        Level level = event.getLevel();
        if (formatAsMsg) {
            bfr.append("<Message Id=\"");
            String msgId = event.getMessageId();
            if (msgId == null) {
                msgId = this.getMessageId(logText);
                if (msgId == null) {
                    msgId = "None";
                }
            } else if (msgId.length() == 0) {
                msgId = "None";
            }
            bfr.append(msgId);
            if (level != null) {
                bfr.append("\" Severity=\"");
                bfr.append(this.getLevel(level.getValue()));
            }
            bfr.append("\">\n");
        } else if (level != null) {
            bfr.append("<Trace Level=\"");
            bfr.append(this.getLevel(level.getValue()));
            bfr.append("\">\n");
        } else {
            bfr.append("<Trace>\n");
        }
        bfr.append(" <Time Millis=\"");
        long timeStamp = event.getTimeStamp();
        bfr.append(timeStamp);
        bfr.append("\"> ");
        bfr.append(this.getDate(timeStamp));
        bfr.append(" ");
        bfr.append(this.getTime(timeStamp));
        bfr.append("</Time>\n");
        this.getProductInfo(bfr, event, !this.singleComponent, !this.singleProductId, !this.singleProductInstance, !this.singleServer);
        bfr.append(" <LogText><![CDATA[");
        bfr.append(logText);
        bfr.append("]]></LogText>\n");
        Iterator it = event.getKeysAndValues();
        if (it != null) {
            bfr.append(" <LogAttribs>");
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                bfr.append(" <Key>");
                bfr.append(entry.getKey());
                bfr.append("</Key>");
                bfr.append(" <Value>");
                bfr.append(entry.getValue());
                bfr.append("</Value>\n");
            }
            bfr.append(" </LogAttribs>\n");
        }
        if (formatAsMsg) {
            this.getSource(bfr, event);
            this.getTranslationInfo(bfr, event, event.getMessageFile());
        } else {
            if (!this.getSource(bfr, event)) {
                bfr.append(" <Source FileName=\"None\" Method=\"None\"/>");
            }
            bfr.append(" <Thread>");
            bfr.append(event.getThreadName());
            bfr.append("</Thread>\n");
            String stackTrace = event.getStackTrace();
            if (stackTrace != null) {
                bfr.append(" <Exception><![CDATA[");
                bfr.append(stackTrace);
                bfr.append("]]></Exception>\n");
            }
        }
        if (event.getCorrelationId() != null) {
            bfr.append(" <CorrelationId>");
            bfr.append(event.getCorrelationId());
            bfr.append("</CorrelationId>\n");
        }
        if (event.getClient() != null) {
            bfr.append(" <Principal>");
            bfr.append(event.getClient());
            bfr.append("</Principal>\n");
        }
        if (formatAsMsg) {
            bfr.append("</Message>\n");
        } else {
            bfr.append("</Trace>\n");
        }
        return bfr.toString();
    }

    private void getProductInfo(StringBuffer bfr, LogEvent event, boolean appendComponent, boolean appendProductId, boolean appendProductInstance, boolean appendServer) {
        if (appendServer && event.getServer() != null) {
            bfr.append(" <Server Format=\"");
            bfr.append(event.getServerFormat());
            bfr.append("\">");
            bfr.append(event.getServer());
            bfr.append("</Server>\n");
        }
        if (appendProductId && event.getProduct() != null) {
            bfr.append(" <ProductId>");
            bfr.append(event.getProduct());
            bfr.append("</ProductId>\n");
        }
        if (appendComponent && event.getComponent() != null) {
            bfr.append(" <Component>");
            bfr.append(event.getComponent());
            bfr.append("</Component>\n");
        }
        if (appendProductInstance && event.getProductInstance() != null) {
            bfr.append(" <ProductInstance>");
            bfr.append(event.getProductInstance());
            bfr.append("</ProductInstance>\n");
        }
        this.isFirstRecord = false;
    }

    private void getTranslationInfo(StringBuffer bfr, LogEvent event, String messageFile) {
        bfr.append(" <TranslationInfo Type=\"JAVA\"");
        bfr.append(" Catalog=\"");
        bfr.append(messageFile);
        bfr.append("\" MsgKey=\"");
        bfr.append(event.getMessageKey());
        bfr.append("\">");
        Object[] inserts = event.getInserts();
        if (inserts != null) {
            for (int i = 0; i < inserts.length; ++i) {
                bfr.append("<Param><![CDATA[");
                if (inserts[i] != null) {
                    bfr.append(inserts[i].toString());
                }
                bfr.append("]]></Param>");
            }
        }
        bfr.append("</TranslationInfo>\n");
    }

    private boolean getSource(StringBuffer bfr, LogEvent event) {
        boolean source = true;
        if (event.getLoggingClass() != null) {
            bfr.append(" <Source FileName=\"");
            bfr.append(event.getLoggingClass());
            bfr.append("\" Method=\"");
            bfr.append(event.getLoggingMethod());
            bfr.append("\"/>\n");
        } else {
            source = false;
        }
        return source;
    }

    public String getHeader() {
        this.isFirstRecord = true;
        return null;
    }

    public String getTrailer() {
        return null;
    }

    public String getMessageId(String msg) {
        String noId = null;
        String SEVERITIES = "IWEADF";
        if (msg == null || msg.length() < 8) {
            return noId;
        }
        char[] messageID = new char[10];
        boolean UPPER = true;
        int LOWER = 2;
        int DIGIT = 4;
        int[] charClass = new int[10];
        boolean foundEnd = false;
        for (int i = 0; i < msg.length() && i < 10 && !foundEnd; ++i) {
            char c = msg.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                messageID[i] = c;
                charClass[i] = 1;
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                messageID[i] = c;
                charClass[i] = 2;
                continue;
            }
            if (c >= '0' && c <= '9') {
                messageID[i] = c;
                charClass[i] = 4;
                continue;
            }
            foundEnd = true;
        }
        if (messageID[0] < 'A' || messageID[0] > 'Z') {
            return noId;
        }
        if (charClass[1] != 1 || charClass[2] != 1) {
            return noId;
        }
        if (charClass[3] == 4 && (charClass[4] != 4 || charClass[5] != 4)) {
            return noId;
        }
        if (charClass[4] == 4 && charClass[5] != 4) {
            return noId;
        }
        if (charClass[6] != 4) {
            return noId;
        }
        if (charClass[4] != 4 && charClass[7] != 4) {
            return noId;
        }
        if (charClass[5] != 4 && charClass[8] != 4) {
            return noId;
        }
        if (charClass[7] != 4) {
            if ("IWEADF".indexOf(messageID[7]) != -1) {
                return new String(messageID, 0, 8);
            }
            return noId;
        }
        if (charClass[8] != 4) {
            if ("IWEADF".indexOf(messageID[8]) != -1) {
                return new String(messageID, 0, 9);
            }
            return noId;
        }
        if ("IWEADF".indexOf(messageID[9]) != -1) {
            return new String(messageID, 0, 10);
        }
        return noId;
    }

    private String getLevel(int val) {
        switch (val) {
            case 7000: {
                return "ERROR";
            }
            case 6000: {
                return "ERROR";
            }
            case 5000: {
                return "WARN";
            }
            case 4000: {
                return "INFO";
            }
            case 3000: {
                return "MIN";
            }
            case 2000: {
                return "MID";
            }
            case 1000: {
                return "MAX";
            }
        }
        return "OTHER";
    }

    public String cacheMessageId(LogEvent event) {
        String msgId = event.getMessageId();
        if (msgId != null) {
            return msgId;
        }
        String key = event.getMessageKey();
        String messageFile = event.getMessageFile();
        if (key != null && messageFile != null) {
            String msgIdString = null;
            MessageCatalog cat = this.getMessageCatalog(messageFile);
            msgIdString = cat.getUnformattedMessage(key);
            if (msgIdString != null) {
                msgId = this.getMessageId(msgIdString);
            }
        }
        if (msgId == null) {
            event.setMessageId("");
        } else {
            event.setMessageId(msgId);
        }
        return msgId;
    }
}

