/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.FileHandler;
import com.ibm.log.LogEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

public class SerialFileHandler
extends FileHandler {
    static final long serialVersionUID = -5708565483533134148L;
    private transient File outputFile = null;
    private transient FileDescriptor outputFileDesc = null;
    private transient ObjectOutputStream objectOutput = null;

    public SerialFileHandler() {
        this.setMaxFiles(1);
    }

    public SerialFileHandler(String name) {
        super(name);
        this.setMaxFiles(1);
    }

    public SerialFileHandler(String name, String file) {
        super(name, file);
        this.setMaxFiles(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile() throws Exception {
        long fileSize = -1L;
        long maxFileSize = this.getMaxFileSize() * 1024L;
        int maxFiles = this.getMaxFiles();
        Object object = this.deviceLock;
        synchronized (object) {
            boolean full;
            if (maxFiles > 1 && this.outputFile != null) {
                this.outputFileDesc.sync();
                fileSize = this.outputFile.length();
            }
            boolean bl = full = maxFiles != 1 && fileSize >= maxFileSize;
            if (!this.open || full) {
                this.close();
                this.makePath();
                if (full) {
                    Vector dirList = this.getDirList();
                    dirList = this.deleteExtraFiles(dirList);
                    this.renameFiles(dirList);
                }
                String workingPath = this.getWorkingName();
                FileOutputStream fos = new FileOutputStream(workingPath, this.isAppending());
                this.objectOutput = new ObjectOutputStream(fos);
                this.setOutputStream(this.objectOutput);
                this.outputFile = new File(workingPath);
                this.outputFileDesc = fos.getFD();
                this.open = true;
            }
        }
    }

    public void open() throws Exception, AccessControlException {
        SecurityManager sm;
        String filePath = this.getWorkingName();
        if (filePath == null) {
            this.setFileNameAndDir("log.txt", "");
        }
        if ((sm = System.getSecurityManager()) == null) {
            this.openFile();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        SerialFileHandler.this.openFile();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputFile = null;
            this.objectOutput = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent event) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open();
            this.objectOutput.writeObject(event);
            this.objectOutput.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector readEvents() throws ClassNotFoundException, FileNotFoundException, IOException, StreamCorruptedException {
        ObjectInputStream in = null;
        String fileName = null;
        Vector<LogEvent> events = new Vector<LogEvent>();
        Object object = this.deviceLock;
        synchronized (object) {
            boolean done;
            this.close();
            Vector dirList = this.getDirList();
            for (int j = 0; j < dirList.size(); ++j) {
                fileName = this.getWorkingDir() + dirList.elementAt(j);
                in = new ObjectInputStream(new FileInputStream(fileName));
                done = false;
                while (!done) {
                    try {
                        events.addElement((LogEvent)in.readObject());
                    }
                    catch (EOFException e) {
                        done = true;
                    }
                }
                in.close();
            }
            in = new ObjectInputStream(new FileInputStream(this.getWorkingName()));
            done = false;
            while (!done) {
                try {
                    events.addElement((LogEvent)in.readObject());
                }
                catch (EOFException e) {
                    done = true;
                }
            }
            in.close();
        }
        return events;
    }

    public Vector readSerializedEvents() throws Exception, AccessControlException {
        Vector events;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            events = this.readEvents();
        } else {
            try {
                events = (Vector)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return SerialFileHandler.this.readEvents();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return events;
    }
}

