/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.ISO8601DateFormat;
import java.util.Date;

public class TivTraceFormatter
extends Formatter {
    public static final char RECORD_SEPARATOR = '\u001e';
    public static final char FIELD_SEPARATOR = '\u001f';
    public static final String SUBFIELD_SEPARATOR = " - ";
    private static ISO8601DateFormat dateFmt = new ISO8601DateFormat();

    public TivTraceFormatter(String name) {
        super(name);
    }

    public TivTraceFormatter() {
    }

    public String format(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        String attrib = null;
        bfr.append('\u001e');
        Date dateTime = new Date(event.getTimeStamp());
        bfr.append("[" + dateFmt.format(dateTime) + "]");
        bfr.append(SUBFIELD_SEPARATOR);
        bfr.append(this.getLevelStr(event.getLevel().getValue()));
        Level level = event.getLevel();
        bfr.append(SUBFIELD_SEPARATOR);
        bfr.append(this.getShortServerName(event.getServer()));
        bfr.append(SUBFIELD_SEPARATOR);
        attrib = event.getThreadName();
        bfr.append(attrib == null ? "" : attrib);
        bfr.append(SUBFIELD_SEPARATOR);
        attrib = event.getLoggingClass();
        bfr.append(attrib == null ? "" : attrib);
        bfr.append(".");
        attrib = event.getLoggingMethod();
        bfr.append(attrib == null ? "" : attrib);
        bfr.append(SUBFIELD_SEPARATOR);
        attrib = event.getMessageId();
        bfr.append(attrib == null ? "" : attrib);
        bfr.append(this.getText(event));
        bfr.append(this.lineSep);
        return bfr.toString();
    }

    private String getShortServerName(String longHost) {
        int at = longHost.indexOf(".");
        return longHost.substring(0, at == -1 ? longHost.length() : at);
    }

    protected String getLevelStr(int val) {
        switch (val) {
            case 7000: {
                return "ERROR";
            }
            case 6000: {
                return "ERROR";
            }
            case 5000: {
                return "WARN ";
            }
            case 4000: {
                return "INFO ";
            }
            case 3000: {
                return " MIN ";
            }
            case 2000: {
                return " MID ";
            }
            case 1000: {
                return " MAX ";
            }
        }
        return "OTHER";
    }

    protected String getText(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        bfr.append(this.getMessage(event));
        String stackTrace = event.getStackTrace();
        if (stackTrace != null) {
            String textOrKey = event.getText();
            if (textOrKey != null) {
                bfr.append(this.lineSep);
                bfr.append("  ");
            }
            bfr.append(stackTrace);
        }
        return bfr.toString();
    }
}

