/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import java.util.StringTokenizer;

public class Type {
    public static final long NONE = 0L;
    public static final long ALL = -1L;
    public static final long INFO = 1L;
    public static final long WARN = 2L;
    public static final long ERROR = 4L;
    public static final long FATAL = 8L;
    public static final long API = 16L;
    public static final long CALLBACK = 32L;
    public static final long ENTRY = 64L;
    public static final long EXIT = 128L;
    public static final long MISC = 256L;
    public static final long CREATE = 512L;
    public static final long DELETE = 1024L;
    public static final long PRIVATE = 2048L;
    public static final long PUBLIC = 4096L;
    public static final long STATIC = 8192L;
    public static final long SVC = 16384L;
    public static final long PERF = 32768L;
    public static final long DEFAULT = 65535L;

    public static long longValue(String types) {
        long result = 0L;
        StringTokenizer st = new StringTokenizer(types);
        while (st.hasMoreElements()) {
            String type = st.nextToken();
            if (type.equals("ALL")) {
                result |= 0xFFFFFFFFFFFFFFFFL;
            }
            if (type.equals("DEFAULT")) {
                result |= 0xFFFFL;
            } else if (type.equals("API")) {
                result |= 0x10L;
            } else if (type.equals("CALLBACK")) {
                result |= 0x20L;
            } else if (type.equals("CREATE")) {
                result |= 0x200L;
            } else if (type.equals("DELETE")) {
                result |= 0x400L;
            } else if (type.equals("ENTRY")) {
                result |= 0x40L;
            } else if (type.equals("ERROR")) {
                result |= 4L;
            } else if (type.equals("EXIT")) {
                result |= 0x80L;
            } else if (type.equals("FATAL")) {
                result |= 8L;
            }
            if (type.equals("INFO")) {
                result |= 1L;
                continue;
            }
            if (type.equals("MISC")) {
                result |= 0x100L;
                continue;
            }
            if (type.equals("PERF")) {
                result |= 0x8000L;
                continue;
            }
            if (type.equals("PRIVATE")) {
                result |= 0x800L;
                continue;
            }
            if (type.equals("PUBLIC")) {
                result |= 0x1000L;
                continue;
            }
            if (type.equals("STATIC")) {
                result |= 0x2000L;
                continue;
            }
            if (type.equals("SVC")) {
                result |= 0x4000L;
                continue;
            }
            if (!type.equals("WARN")) continue;
            result |= 2L;
        }
        return result;
    }

    public static String toString(long types) {
        StringBuffer bfr = new StringBuffer();
        if (types == -1L) {
            bfr.append("ALL");
        } else if (types == 0L) {
            bfr.append("NONE");
        } else {
            if ((types & 0x10L) != 0L) {
                bfr.append("API ");
            }
            if ((types & 0x20L) != 0L) {
                bfr.append("CALLBACK ");
            }
            if ((types & 0x200L) != 0L) {
                bfr.append("CREATE ");
            }
            if ((types & 0x400L) != 0L) {
                bfr.append("DELETE ");
            }
            if ((types & 0x40L) != 0L) {
                bfr.append("ENTRY ");
            }
            if ((types & 4L) != 0L) {
                bfr.append("ERROR ");
            }
            if ((types & 0x80L) != 0L) {
                bfr.append("EXIT ");
            }
            if ((types & 8L) != 0L) {
                bfr.append("FATAL ");
            }
            if ((types & 1L) != 0L) {
                bfr.append("INFO ");
            }
            if ((types & 0x100L) != 0L) {
                bfr.append("MISC ");
            }
            if ((types & 0x8000L) != 0L) {
                bfr.append("PERF ");
            }
            if ((types & 0x800L) != 0L) {
                bfr.append("PRIVATE ");
            }
            if ((types & 0x1000L) != 0L) {
                bfr.append("PUBLIC ");
            }
            if ((types & 0x2000L) != 0L) {
                bfr.append("STATIC ");
            }
            if ((types & 0x4000L) != 0L) {
                bfr.append("SVC ");
            }
            if ((types & 2L) != 0L) {
                bfr.append("WARN ");
            }
        }
        return bfr.toString().trim();
    }
}

