/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Filter;
import com.ibm.log.LogEvent;
import com.ibm.log.Type;
import java.util.Properties;

public abstract class TypeFilter
extends Filter {
    private long mask = -1L;

    public TypeFilter() {
    }

    public TypeFilter(String name) {
        super(name);
    }

    public TypeFilter(String name, long mask) {
        super(name);
        this.setMask(mask);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("mask", Type.toString(this.getMask()));
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("mask");
        if (prop != null) {
            this.setMask(Type.longValue(prop));
        }
    }

    public long getMask() {
        return this.mask;
    }

    public void setMask(long mask) {
        this.mask = mask;
    }

    public boolean isLoggable(LogEvent event) {
        boolean loggable = false;
        if (event != null) {
            loggable = !event.isTypeValid() ? true : this.isLoggable(event.getType());
        }
        return loggable;
    }

    public abstract boolean isLoggable(long var1);

    public String toString() {
        String result = super.toString();
        return result + ", mask=" + Type.toString(this.getMask());
    }
}

