/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.AnyTypeFilter;
import com.ibm.log.LogEvent;
import com.ibm.log.Logger;
import com.ibm.log.TypeFilter;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class TypeLogger
extends Logger {
    static final long serialVersionUID = 7894404770313464896L;
    private String filterName = null;
    private TypeFilter typeFilter = new AnyTypeFilter();

    public TypeLogger() {
    }

    public TypeLogger(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        if (this.filterName != null) {
            props.put("filterName", this.filterName);
        }
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("filterName");
        if (prop != null) {
            this.filterName = prop;
        }
    }

    public TypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        if (typeFilter != null) {
            this.typeFilter = typeFilter;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setTypeFilter");
            LogUtil.errorMsg(msg);
        }
    }

    protected boolean isLoggable(long type) {
        boolean loggable = false;
        if (this.isLogging()) {
            loggable = this.getTypeFilter().isLoggable(type);
        }
        return loggable;
    }

    public void message(long type, String key) {
        if (this.isLoggable(type)) {
            this.logMessage(type, key, this.getMessageFile(), null);
        }
    }

    public void message(long type, String key, Object insert1) {
        if (this.isLoggable(type)) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(type, key, this.getMessageFile(), inserts);
        }
    }

    public void message(long type, String key, Object insert1, Object insert2) {
        if (this.isLoggable(type)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(type, key, this.getMessageFile(), inserts);
        }
    }

    public void message(long type, String key, Object[] inserts) {
        if (this.isLoggable(type)) {
            this.logMessage(type, key, this.getMessageFile(), inserts);
        }
    }

    public void msg(long type, String key, String file) {
        if (this.isLoggable(type)) {
            this.logMessage(type, key, file, null);
        }
    }

    public void msg(long type, String key, String file, Object insert1) {
        if (this.isLoggable(type)) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(type, key, file, inserts);
        }
    }

    public void msg(long type, String key, String file, Object insert1, Object insert2) {
        if (this.isLoggable(type)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(type, key, file, inserts);
        }
    }

    public void msg(long type, String key, String file, Object[] inserts) {
        if (this.isLoggable(type)) {
            this.logMessage(type, key, file, inserts);
        }
    }

    public void text(long type, String text) {
        if (this.isLoggable(type)) {
            this.logText(type, text, null);
        }
    }

    public void text(long type, String text, Object insert1) {
        if (this.isLoggable(type)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(type, text, inserts);
        }
    }

    public void text(long type, String text, Object insert1, Object insert2) {
        if (this.isLoggable(type)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(type, text, inserts);
        }
    }

    public void text(long type, String text, Object[] inserts) {
        if (this.isLoggable(type)) {
            this.logText(type, text, inserts);
        }
    }

    public void entry(long type) {
        if (this.isLoggable(type)) {
            this.logText(type, "Entry", null);
        }
    }

    public void entry(long type, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{TypeLogger.objToStr(parm1)};
            this.logText(type, "Entry, parm 1 = {0}", parms);
        }
    }

    public void entry(long type, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{TypeLogger.objToStr(parm1), TypeLogger.objToStr(parm2)};
            this.logText(type, "Entry, parm 1 = {0}, parm 2 = {1}", parms);
        }
    }

    public void entry(long type, Object[] parms) {
        if (this.isLoggable(type)) {
            StringBuffer bfr = new StringBuffer("Entry");
            Object[] strs = null;
            if (parms != null) {
                strs = new String[parms.length];
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", parm " + (j + 1) + " = {" + j + "}");
                    strs[j] = TypeLogger.objToStr(parms[j]);
                }
            }
            this.logText(type, bfr.toString(), strs);
        }
    }

    public void exit(long type) {
        if (this.isLoggable(type)) {
            this.logText(type, "Exit", null);
        }
    }

    public void exit(long type, byte retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, short retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Short(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, int retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, long retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Long(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, float retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Float(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, double retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Double(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, char retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Character(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, boolean retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long type, Object retValue) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{TypeLogger.objToStr(retValue)};
            this.logText(type, "Exit, return value = {0}", parms);
        }
    }

    public void exception(long type, Throwable throwable) {
        if (this.isLoggable(type)) {
            LogEvent event = new LogEvent(type, throwable);
            this.logAndWarn(event);
        }
    }

    public void exception(long type, Throwable throwable, String text) {
        if (this.isLoggable(type)) {
            LogEvent event = new LogEvent(type, throwable, text);
            this.logAndWarn(event);
        }
    }

    protected void logMessage(long type, String key, String file, Object[] inserts) {
        LogEvent event = new LogEvent(type, key, file, inserts);
        this.logAndWarn(event);
    }

    protected void logText(long type, String text, Object[] inserts) {
        LogEvent event = new LogEvent(type, text, inserts);
        this.logAndWarn(event);
    }
}

