/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import com.ibm.log.cmd.Channel;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class LogCmd {
    public static final String OPTION_PORT = "-o";
    protected Channel channel = null;
    protected InputStream cmdIn;
    protected int port = 9992;
    protected OutputStream cmdErr;
    protected OutputStream cmdOut;
    protected String[] args;

    public static void main(String[] args) {
        int rc = 1;
        LogCmd logCmd = new LogCmd(args, System.in, System.out, System.err);
        try {
            rc = logCmd.execute();
        }
        catch (ConnectException e) {
            String thePort = Integer.toString(logCmd.port);
            LogUtil.errorMsg(LogUtil.getLogMsg("ERR_CMD_SERVER_CONNECT_FAIL", thePort));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(rc);
    }

    public LogCmd(String[] args, InputStream cmdIn, OutputStream cmdOut, OutputStream cmdErr) {
        this.args = args;
        this.cmdIn = cmdIn;
        this.cmdOut = cmdOut;
        this.cmdErr = cmdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException, NumberFormatException {
        int rc = 1;
        try {
            String serverCmd = this.processLocalOptions(this.args);
            Socket socket = null;
            try {
                InetAddress loopback = InetAddress.getByName(null);
                socket = new Socket(loopback, this.port);
            }
            catch (UnknownHostException e) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_LOCALHOST_CMD_SOCKET"));
                int n = rc;
                if (this.channel != null) {
                    this.channel.close();
                }
                return n;
            }
            this.channel = new Channel(socket);
            this.channel.open();
            this.channel.write("Cmd:");
            this.channel.write(serverCmd);
            rc = this.completeCommand();
        }
        finally {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        return rc;
    }

    protected String processLocalOptions(String[] args) throws NumberFormatException {
        int argIndex = 0;
        boolean done = false;
        boolean ignore = false;
        String serverArgs = "";
        while (argIndex < args.length && !done) {
            String arg = args[argIndex];
            if (arg.startsWith(OPTION_PORT)) {
                String portNumber = arg.length() > OPTION_PORT.length() ? arg.substring(OPTION_PORT.length()) : args[++argIndex];
                this.port = Integer.parseInt(portNumber);
                ++argIndex;
                continue;
            }
            if (arg.equals("-h")) {
                ignore = true;
                serverArgs = "help";
                ++argIndex;
                continue;
            }
            done = true;
        }
        while (argIndex < args.length && !ignore) {
            serverArgs = serverArgs + args[argIndex++] + " ";
        }
        if (serverArgs.trim().equals("")) {
            serverArgs = "help";
        }
        return serverArgs;
    }

    protected int completeCommand() throws IOException, NumberFormatException {
        boolean done = false;
        int rc = 1;
        while (!done) {
            byte[] buffer;
            String msg = this.channel.read();
            if (msg.equals("Stdout:")) {
                buffer = this.channel.read().getBytes();
                this.cmdOut.write(buffer);
                continue;
            }
            if (msg.equals("Stderr:")) {
                buffer = this.channel.read().getBytes();
                this.cmdErr.write(buffer);
                continue;
            }
            if (!msg.equals("RC:")) continue;
            done = true;
            String returnCode = this.channel.read();
            rc = Integer.parseInt(returnCode);
        }
        return rc;
    }
}

