/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.util.LogUtil;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class DataStoreConfig
extends Properties {
    static final long serialVersionUID = 5459450638190200411L;
    private boolean loadedFromDataStore = false;
    private DataStoreConfig parent = null;
    private Vector children = null;

    public DataStoreConfig() {
    }

    public DataStoreConfig(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            this.setProperty(key, value);
        }
    }

    public DataStoreConfig getParent() {
        return this.parent;
    }

    public void setParent(DataStoreConfig parent) {
        this.parent = parent;
        this.defaults = parent;
    }

    public void addChild(DataStoreConfig child) {
        if (child != null) {
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(child)) {
                this.children.add(child);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addChild");
            LogUtil.errorMsg(msg);
        }
    }

    public void removeChild(DataStoreConfig child) {
        if (child != null) {
            if (this.children != null && this.children.contains(child)) {
                this.children.remove(child);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".removeChild");
            LogUtil.errorMsg(msg);
        }
    }

    public Iterator getChildren() {
        Iterator it = this.children == null ? new Vector().iterator() : this.children.iterator();
        return it;
    }

    public boolean isLoadedFromDataStore() {
        return this.loadedFromDataStore;
    }

    public void setLoadedFromDataStore(boolean flag) {
        this.loadedFromDataStore = flag;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer bfr = new StringBuffer();
        bfr.append("    Configuration:\r\n");
        bfr.append(lineSep);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            bfr.append("      " + key + ":  " + this.getProperty(key));
            bfr.append(lineSep);
        }
        DataStoreConfig parent = this.getParent();
        if (parent != null) {
            bfr.append("      Parent:  " + parent.getProperty("name"));
            bfr.append(lineSep);
        }
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            DataStoreConfig child = (DataStoreConfig)it.next();
            bfr.append("      Child:  " + child.getProperty("name"));
            bfr.append(lineSep);
        }
        bfr.append("      Loaded from DataStore::  " + this.isLoadedFromDataStore());
        bfr.append(lineSep);
        return bfr.toString();
    }
}

