/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.DataStoreSupport;
import com.ibm.log.util.LogException;
import com.ibm.log.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyDataStore
extends DataStoreSupport {
    protected Properties props;
    protected String propFileName;
    protected BufferedInputStream is;

    public PropertyDataStore(String name) throws IOException, LogException, AccessControlException {
        this.propFileName = name;
        this.props = this.loadProperties(name);
        this.restoreConfig();
    }

    public PropertyDataStore(InputStream stream) throws IOException, LogException {
        this.propFileName = "[java.io.InputStream]";
        this.props = this.loadPropertiesFromStream(stream);
        this.restoreConfig();
    }

    protected Properties loadProperties(String name) throws IOException, AccessControlException {
        InputStream iStream;
        ClassLoader cl = LogUtil.getClassLoaderForResource(name);
        if (cl == null) {
            iStream = this.getClass().getResourceAsStream(name);
        } else {
            if (name != null && name.startsWith("/")) {
                try {
                    name = name.substring(1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            iStream = cl.getResourceAsStream(name);
        }
        if (iStream == null) {
            String msg = LogUtil.getLogMsg("ERR_FILE_NOT_FOUND", this.propFileName);
            LogUtil.errorMsg(msg);
        }
        return this.loadPropertiesFromStream(iStream);
    }

    protected Properties loadPropertiesFromStream(InputStream stream) throws IOException {
        Properties properties = new Properties();
        this.is = new BufferedInputStream(stream);
        properties.load(this.is);
        this.is.close();
        return properties;
    }

    public void restoreConfig() throws LogException {
        boolean error = false;
        String errorString = "";
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String fullKey = ((String)e.nextElement()).trim();
            if (fullKey.startsWith("#") || fullKey.startsWith("!")) continue;
            String value = this.props.getProperty(fullKey);
            this.restoreProp(fullKey, value);
        }
        this.initialized = true;
    }

    protected void restoreProp(String fullKey, String value) throws LogException {
        boolean error = false;
        String errorString = "";
        int dot = fullKey.lastIndexOf(46);
        if (dot == -1) {
            error = true;
            errorString = errorString + System.getProperty("line.separator") + fullKey + "=" + value;
        } else {
            String name = fullKey.substring(0, dot);
            String key = fullKey.substring(dot + 1);
            if (name.equals("") || key.equals("")) {
                error = true;
                errorString = errorString + System.getProperty("line.separator") + fullKey + "=" + value;
            } else {
                DataStoreConfig config = this.getConfig(name);
                config.setProperty(key, value);
                config.setLoadedFromDataStore(true);
            }
        }
        if (error) {
            String msg = LogUtil.getLogMsg("ERR_DATA_STORE", this.propFileName) + errorString;
            throw new LogException(msg);
        }
    }

    public void saveConfig(boolean saveAll) throws Exception {
        String msg = LogUtil.getLogMsg("WARN_CANNOT_SAVE_CFG");
        LogUtil.errorMsg(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substitute(String symbol, String actualValue) throws LogException {
        if (symbol == null || actualValue == null) {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".substitute");
            LogUtil.errorMsg(msg);
            return;
        }
        String literal = "$(" + symbol + ")";
        Properties properties = this.props;
        synchronized (properties) {
            Enumeration<Object> e = this.props.keys();
            while (e != null && e.hasMoreElements()) {
                String nextKey = (String)e.nextElement();
                String nextVal = this.props.getProperty(nextKey);
                if (nextVal.indexOf(literal) == -1) continue;
                String replaced = LogUtil.replace(nextVal, literal, actualValue);
                this.props.setProperty(nextKey, replaced);
                this.restoreProp(nextKey, replaced);
            }
        }
    }
}

