/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.PropertyFileDataStore;
import com.ibm.log.util.LogException;
import com.ibm.log.util.LogUtil;
import java.io.IOException;

public class ReloadableFileDataStore
extends PropertyFileDataStore {
    public ReloadableFileDataStore(String name) throws IOException, LogException {
        super(name);
    }

    public void reloadFromFile() throws IOException, LogException {
        this.props = this.loadProperties(this.propFileName);
        this.restoreConfig();
    }

    protected void restoreProp(String fullKey, String value) throws LogException {
        boolean error = false;
        String errorString = "";
        int dot = fullKey.lastIndexOf(46);
        if (dot == -1) {
            error = true;
            errorString = errorString + System.getProperty("line.separator") + fullKey + "=" + value;
        } else {
            String name = fullKey.substring(0, dot);
            String key = fullKey.substring(dot + 1);
            if (name.equals("") || key.equals("")) {
                error = true;
                errorString = errorString + System.getProperty("line.separator") + fullKey + "=" + value;
            } else {
                DataStoreConfig config = this.getConfig(name);
                config.setProperty(key, value);
                config.setLoadedFromDataStore(true);
                this.updateConfig(config);
            }
        }
        if (error) {
            String msg = LogUtil.getLogMsg("ERR_DATA_STORE", this.propFileName) + errorString;
            throw new LogException(msg);
        }
    }
}

