/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.util.MessageCatalog;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogUtil {
    public static final String LOG_MSG_CAT = "com.ibm.log.util.Msgs";
    private static final String MISSING_MSG_CAT = "The Logging Toolkit message file, com.ibm.log.util.Msgs, was not found.  No toolkit messages can be displayed.";
    private static MessageCatalog msgs = null;
    private static Hashtable localeToCodePage;
    private static PrintWriter defaultErrWriter;
    private static PrintWriter currentErrWriter;
    private static ClassLoader defaultResourceLoader;
    private static HashMap resourceLoaders;
    private static Object resourceLoaderMapLock;

    public static Object[] checkNullObjects(Object[] inserts) {
        String nullMsg = null;
        Object[] modifiedInserts = null;
        if (inserts != null) {
            for (int j = 0; j < inserts.length; ++j) {
                if (inserts[j] != null) continue;
                if (nullMsg == null) {
                    nullMsg = LogUtil.getLogMsg("NULL_OBJECT");
                }
                if (modifiedInserts == null) {
                    modifiedInserts = new Object[inserts.length];
                    for (int i = 0; i < inserts.length; ++i) {
                        modifiedInserts[i] = inserts[i];
                    }
                }
                modifiedInserts[j] = nullMsg;
            }
        }
        if (modifiedInserts == null) {
            return inserts;
        }
        return modifiedInserts;
    }

    public static Object createObject(String name) {
        Class<?> objClass = null;
        Object object = null;
        if (name != null) {
            ClassLoader cl = LogUtil.getClassLoaderForResource(name);
            if (cl == null) {
                cl = LogUtil.class.getClassLoader();
            }
            try {
                objClass = cl != null ? cl.loadClass(name) : Class.forName(name);
                object = objClass.newInstance();
            }
            catch (Exception e) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_OBJ_CREATE", name));
                e.printStackTrace();
            }
        }
        return object;
    }

    public static void errorMsg(String msg) {
        if (currentErrWriter == null) {
            System.err.println(msg);
        } else {
            currentErrWriter.println(msg);
        }
    }

    public static void errorStack(Throwable t) {
        if (currentErrWriter == null) {
            t.printStackTrace(System.err);
        } else {
            t.printStackTrace(currentErrWriter);
        }
    }

    public static String getConsoleCodePage() {
        String codePage = null;
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            Locale loc = Locale.getDefault();
            String lang = loc.getLanguage();
            String country = loc.getCountry();
            codePage = (String)localeToCodePage.get(lang + "_" + country);
            if (codePage == null) {
                codePage = (String)localeToCodePage.get(lang);
            }
        }
        return codePage;
    }

    public static String getLogMsg(String key) {
        return LogUtil.getLogMsg(key, null);
    }

    public static String getLogMsg(String key, Object insert1) {
        Object[] inserts = new Object[]{insert1};
        return LogUtil.getLogMsg(key, inserts);
    }

    public static String getLogMsg(String key, Object insert1, Object insert2) {
        Object[] inserts = new Object[]{insert1, insert2};
        return LogUtil.getLogMsg(key, inserts);
    }

    public static String getLogMsg(String key, Object[] inserts) {
        String msg = "";
        if (msgs != null) {
            msg = msgs.getMessage(key, inserts);
        }
        return msg;
    }

    public static String left(String input, int length) {
        return LogUtil.left(input, length, " ");
    }

    public static String left(String input, int length, String pad) {
        String output = input;
        if (input != null) {
            if (input.length() < length) {
                while (output.length() < length) {
                    output = output + pad;
                }
            } else if (input.length() > length) {
                output = input.substring(0, length);
            }
        }
        return output;
    }

    public static Vector arrayToVector(Object[] array) {
        Vector<String> v = null;
        if (array != null) {
            v = new Vector<String>();
            for (int i = 0; i < array.length; ++i) {
                v.addElement(array[i].toString());
            }
        }
        return v;
    }

    public static Vector stringToVector(String source) {
        Vector<String> v = null;
        if (source != null) {
            v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(source);
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken().trim());
            }
        }
        return v;
    }

    public static String vectorToString(Vector source) {
        String s = null;
        StringBuffer bfr = null;
        if (source != null) {
            Enumeration e = source.elements();
            bfr = new StringBuffer();
            while (e.hasMoreElements()) {
                bfr.append(e.nextElement());
                bfr.append(" ");
            }
            s = bfr.toString().trim();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassLoaderForResource(ClassLoader cl, String resName) {
        if (cl == null || resName == null) {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.setClassLoaderForResource");
            LogUtil.errorMsg(msg);
            return;
        }
        Object object = resourceLoaderMapLock;
        synchronized (object) {
            if (resourceLoaders == null) {
                resourceLoaders = new HashMap();
            }
            resourceLoaders.put(resName, cl);
        }
    }

    public static ClassLoader getClassLoaderForResource(String resName) {
        if (resName == null) {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.getClassLoaderForResource");
            LogUtil.errorMsg(msg);
            return null;
        }
        ClassLoader loader = null;
        if (resourceLoaders != null) {
            loader = (ClassLoader)resourceLoaders.get(resName);
        }
        if (loader == null) {
            loader = defaultResourceLoader;
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClassLoaderForResource(String resName) {
        if (resName == null) {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.removeClassLoaderForResource");
            LogUtil.errorMsg(msg);
            return;
        }
        Object object = resourceLoaderMapLock;
        synchronized (object) {
            if (resourceLoaders != null) {
                resourceLoaders.remove(resName);
            }
        }
    }

    public static ClassLoader getDefaultResourceClassLoader() {
        return defaultResourceLoader;
    }

    public static void setDefaultResourceClassLoader(ClassLoader cl) {
        if (cl == null) {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", "com.ibm.log.util.LogUtil.setDefaultResourceClassLoader");
            LogUtil.errorMsg(msg);
        } else {
            defaultResourceLoader = cl;
        }
    }

    public static String replace(String original, String oldSeq, String newSeq) {
        if (original == null || oldSeq == null || newSeq == null) {
            return original;
        }
        int i = original.indexOf(oldSeq);
        if (i == -1) {
            return original;
        }
        String before = original.substring(0, i) + newSeq;
        String after = original.substring(i + oldSeq.length(), original.length());
        return before + LogUtil.replace(after, oldSeq, newSeq);
    }

    public static void setErrWriter(PrintWriter appErrWriter) {
        currentErrWriter = appErrWriter != null ? appErrWriter : defaultErrWriter;
    }

    public static void setErrLocale(Locale appErrLocale) {
        if (appErrLocale != null) {
            msgs.setLocale(appErrLocale);
        }
    }

    static {
        try {
            ResourceBundle test = ResourceBundle.getBundle(LOG_MSG_CAT);
            msgs = new MessageCatalog(LOG_MSG_CAT);
        }
        catch (MissingResourceException e) {
            String lineSep = System.getProperty("line.separator");
            LogUtil.errorMsg(lineSep + MISSING_MSG_CAT + lineSep);
        }
        localeToCodePage = new Hashtable();
        defaultErrWriter = null;
        currentErrWriter = null;
        localeToCodePage.put("cs", "Cp852");
        localeToCodePage.put("da", "Cp850");
        localeToCodePage.put("en", "Cp850");
        localeToCodePage.put("de", "Cp850");
        localeToCodePage.put("es", "Cp850");
        localeToCodePage.put("fi", "Cp850");
        localeToCodePage.put("fr", "Cp850");
        localeToCodePage.put("hu", "Cp852");
        localeToCodePage.put("it", "Cp850");
        localeToCodePage.put("nl", "Cp949");
        localeToCodePage.put("no", "Cp850");
        localeToCodePage.put("pl", "Cp852");
        localeToCodePage.put("pt", "Cp850");
        localeToCodePage.put("ru", "Cp866");
        localeToCodePage.put("sl", "Cp852");
        localeToCodePage.put("sv", "Cp850");
        localeToCodePage.put("tr", "Cp857");
        try {
            String codePage = LogUtil.getConsoleCodePage();
            OutputStreamWriter osw = codePage != null ? new OutputStreamWriter((OutputStream)System.err, codePage) : new OutputStreamWriter(System.err);
            currentErrWriter = defaultErrWriter = new PrintWriter((Writer)osw, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultResourceLoader = null;
        resourceLoaders = null;
        resourceLoaderMapLock = new Object();
    }
}

