/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.LogNode;
import com.ibm.log.util.ErrorProtocol;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class MessageErrorProtocol
extends LogNode
implements ErrorProtocol {
    private boolean showStackTrace = false;
    private long minRepeatTimeSec = 0L;
    private long timeoutMillis = 0L;
    static final long serialVersionUID = -8638012215696764324L;

    public MessageErrorProtocol() {
    }

    public MessageErrorProtocol(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("showStackTrace", new Boolean(this.showStackTrace));
        props.put("minRepeatTime", Long.toString(this.minRepeatTimeSec));
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("showStackTrace");
        if (prop != null) {
            this.showStackTrace = new Boolean(prop);
        }
        if ((prop = props.getProperty("minRepeatTime")) != null) {
            this.minRepeatTimeSec = Long.parseLong(prop);
        }
    }

    public void error(Handler handler, LogEvent event) {
        this.error(handler, event, null);
    }

    public void error(Handler handler, LogEvent event, Throwable t) {
        if (this.minRepeatTimeSec > 0L) {
            long eventTimeMillis = event.getTimeStamp();
            if (this.timeoutMillis == 0L || eventTimeMillis > this.timeoutMillis) {
                this.timeoutMillis = eventTimeMillis + this.minRepeatTimeSec * 1000L;
            } else {
                return;
            }
        }
        String msg = LogUtil.getLogMsg("ERR_WRITE_MSG", handler.getName());
        if (t != null) {
            String throwableMsg = t.getMessage();
            msg = throwableMsg != null ? msg + System.getProperty("line.separator") + throwableMsg : msg + System.getProperty("line.separator") + t.getClass().getName();
        }
        LogUtil.errorMsg(msg);
        if (t != null && this.showStackTrace) {
            LogUtil.errorStack(t);
        }
    }

    public void cleanup(Handler handler) {
    }

    public boolean isCleanupRequired() {
        return false;
    }
}

