/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.disk.discovery.TopLevelDiscoveryProcess;
import org.eclipse.aperi.disk.discovery.TopLevelProcess;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.tape.api.ITapeCollectionService;
import org.eclipse.aperi.tape.collection.ProbeGenericTapeLibraryProcess;
import org.eclipse.aperi.tape.collection.ProbeTapeLibraryProcess;
import org.eclipse.aperi.tape.collection.TapeProbeDispatcher;
import org.eclipse.aperi.util.osgi.ServiceHelper;

public class TapeCollectionService
implements ITapeCollectionService {
    ServiceHelper cServiceHelper;
    protected static String className = TapeCollectionService.class.getName();
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;

    public TapeCollectionService(ServiceHelper pServiceHelper) {
        this.cServiceHelper = pServiceHelper;
        IDiscoverRouterService pRouter = (IDiscoverRouterService)this.cServiceHelper.bindLocal(IDiscoverRouterService.class);
        pRouter.addProcess("collectStorageSubsystemsFromCIMOM", (IDiscoverProcess)new TopLevelDiscoveryProcess("collectStorageSubsystemsFromCIMOM", false));
        pRouter.addProcess("dispatchDiscoveryProcess", (IDiscoverProcess)new TopLevelProcess("dispatchDiscoveryProcess", true));
        pRouter.addProcess("collectDataFromTapeLibrary", (IDiscoverProcess)new TapeProbeDispatcher("collectDataFromTapeLibrary", false));
        pRouter.addProcess("collectDataFromSingleTapeLibrary", (IDiscoverProcess)new ProbeTapeLibraryProcess("collectDataFromSingleTapeLibrary", true));
        pRouter.addProcess("probeTapeLibraryProcess", (IDiscoverProcess)new ProbeTapeLibraryProcess("probe/collect generic Tape Library", true));
        ProbeGenericTapeLibraryProcess.addLegacyDiscoverProcess(pRouter);
    }

    public AsyncResult discoverTapeLibraries(String[] pCimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "discoverTapeLibraries";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (pCimomIDs != null && pCimomIDs.length == 0) {
            throw new MissingParameterException(1, new SRMMessage("HWNTM0002E", new String[]{"pCimomIDs"}));
        }
        Hashtable<String, Object> mParams = new Hashtable<String, Object>();
        AsyncResult mReturn = new AsyncResult(0, -1);
        mParams.put("CIMOMID_PARAM", pCimomIDs);
        mParams.put("Type", "ToplevelLibrary");
        String mJob = this.getDiscoverProxy().discover("dispatchDiscoveryProcess", mParams);
        mReturn = this.getDiscoverProxy().getJobStatus(mJob);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return mReturn;
    }

    public AsyncResult probeTapeLibraries(String[] pTapeLibIDs, Integer pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.probeTapeLibraries(pTapeLibIDs, (int)pCollectionType);
    }

    public AsyncResult probeTapeLibraries(String[] pTapeLibIDs, int pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "probeTapeLibraries";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)new Integer(pCollectionType));
        }
        if (pTapeLibIDs != null && pTapeLibIDs.length == 0) {
            throw new MissingParameterException(1, new SRMMessage("HWNTM0002E", new String[]{"pTapeLibIDs"}));
        }
        if (pCollectionType != 2 && pCollectionType != 3) {
            throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid collection type: " + new Integer(pCollectionType)}));
        }
        AsyncResult mReturn = new AsyncResult(0, -1);
        Properties mParams = new Properties();
        mParams.put("TAPELIBRARY", pTapeLibIDs);
        mParams.put("COLLTYPE", new Integer(pCollectionType));
        String mJob = this.getDiscoverProxy().discover("collectDataFromTapeLibrary", (Hashtable)mParams);
        mReturn = this.getDiscoverProxy().getJobStatus(mJob);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return mReturn;
    }

    protected IDiscover getDiscoverProxy() {
        return (IDiscover)this.cServiceHelper.bindLocal("DiscoverService");
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }
}

