/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Discover;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.tape.TapeReportingService;

public class TapeProbeDispatcher
extends DiscoverProcess {
    public TapeProbeDispatcher(String pDescription, boolean pIsMainProcess) {
        super(pDescription, pIsMainProcess, new String[]{"TAPELIBRARY", "COLLTYPE"}, new String[]{String[].class.getName(), Integer.class.getName()});
    }

    public Result process(Request pRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)pRequest, (Object)((Object)this), (String)"process", (Object[])new Object[]{pRequest, pParameters});
        ILogger mJobLogger = pRequest.getJobLogger();
        String[] mTapeLibraries = (String[])pParameters.get("TAPELIBRARY");
        Integer mCollectionType = (Integer)pParameters.get("COLLTYPE");
        int rc = 0;
        for (int i = 0; i < mTapeLibraries.length; ++i) {
            Hashtable<String, Object> mParams = new Hashtable<String, Object>();
            mParams.put("TAPELIBRARY", mTapeLibraries[i]);
            mParams.put("COLLTYPE", mCollectionType);
            TapeReportingService mTapeReportingService = new TapeReportingService();
            HashMap mlibID = mTapeReportingService.getTapeLibraryAttributes(new String[]{mTapeLibraries[i]}, new String[]{"TAPE_LIBRARY_ID", "CREATION_CLASS_NAME_ID", "NAME", "NAME_FORMAT"})[0];
            mParams.put("DEVICEID", ((Integer)mlibID.get("TAPE_LIBRARY_ID")).toString());
            CIMOMSelector.TapeLibraryConnectionData mCimomInfo = null;
            try {
                mCimomInfo = CIMOMSelector.getSelector().getCimomForTapeLibrary(((Integer)mlibID.get("TAPE_LIBRARY_ID")).intValue());
                mParams.put("CIMOM", new String[]{mCimomInfo.getCimom().getServiceUrl(), mCimomInfo.getCimNamespace(), mCimomInfo.getCimom().getUserId(), mCimomInfo.getCimom().getPassword()});
            }
            catch (CIMOMSelector.NoCimomAvailableException e) {
                mLTH.traceWarning("CIMOM not available for tape lib " + mTapeLibraries[i]);
                if (Configuration.debug) {
                    System.err.println("CIMOM not available for tape lib " + mTapeLibraries[i]);
                }
                if (mJobLogger != null) {
                    mJobLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)((Object)((Object)this)).getClass().getName(), "process", (Throwable)e);
                }
                rc = 1;
                continue;
            }
            HashMap<String, Object[]> mDispatchParams = new HashMap<String, Object[]>();
            mDispatchParams.put("Request", new Object[]{"collectDataFromSingleTapeLibrary", mParams});
            this.getDiscoverRouterService().perform(Discover.frontEndProcessHandler, mDispatchParams, Integer.toString(pRequest.getId()));
            mLTH.traceInfo("frontEndProcessHandler called with: " + mDispatchParams);
        }
        Result mResult = new Result(rc);
        mLTH.exit((Object)mResult);
        return mResult;
    }
}

