/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.LogFileHandler;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.SRMVersion;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.tape.TapeCollectionService;
import org.eclipse.aperi.tape.TapeMonitor;
import org.eclipse.aperi.tape.TapeReportingService;
import org.eclipse.aperi.tape.api.ITapeManagerService;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class TapeManagerService
implements ITapeManagerService,
IService,
ICliDispatcher,
MessageListener {
    public Status cStatus = new Status(5, 6);
    protected ServiceHelper cServiceHelper;
    static TapeReportingService cRepOps = null;
    static TapeCollectionService cCollOps = null;
    static TapeMonitor cMon = null;
    private static Factory factory;
    private static TopicSubscriber subscriber;
    protected static String className;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    private DiskEventQueue cEventQueue;

    public TapeManagerService(ServiceHelper pServiceHelper) {
        cRepOps = new TapeReportingService();
        cCollOps = new TapeCollectionService(pServiceHelper);
    }

    public String[] getTapeLibraries(HashMap attributes) throws ServerException, InvalidParameterException {
        return cRepOps.getTapeLibraries(attributes);
    }

    public String[] getTapeLibraries() throws ServerException, InvalidParameterException {
        return cRepOps.getTapeLibraries();
    }

    public AsyncResult discoverCIMOMs(String[] DAs, Boolean localSubnet) {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.discoverCIMOMs(DAs, localSubnet);
    }

    public AsyncResult discoverCIMOMs(String[] DAs, boolean localSubnet) {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.discoverCIMOMs(DAs, localSubnet);
    }

    public CIMOM[] getCIMOMs() {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.getCIMOMsWithoutPW();
    }

    public String[] getCIMOMIDs() {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.getCIMOMIDs();
    }

    public void modifyCIMOMs(CIMOM[] cimoms) {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        cm.modifyCIMOMs(cimoms);
    }

    public String[] addCIMOMs(CIMOM[] cimoms) {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.addCIMOMs(cimoms);
    }

    public void deleteCIMOMs(String[] cimomIDs) {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        cm.deleteCIMOMs(cimomIDs);
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cimoms) {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.testCIMOMConnection(cimoms);
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cimoms, CIMObjectPath device) throws ServerException {
        CIMOMManager cm = CIMOMManager.getCIMOMManager();
        return cm.testCIMOMConnection(cimoms, device);
    }

    public AsyncResult getJobStatus(String pJobId) {
        return DiscoverUtils.cancelJob((String)pJobId);
    }

    public AsyncResult waitForJobToComplete(String pJobId) {
        return DiscoverUtils.waitForJobToComplete((String)pJobId);
    }

    public void cancelJob(String pJobId) {
        DiscoverUtils.cancelJob((String)pJobId);
    }

    public SRMVersion getAPIVersion() {
        return new SRMVersion();
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "TapeManagerService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("TapeManagerService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("TapeManagerService_Description");
    }

    public boolean startup() {
        String methodName;
        block6: {
            methodName = "startup";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            this.cStatus.setInstallStatus(5);
            this.cStatus.setRunStatus(9);
            this.cEventQueue = new DiskEventQueue();
            cMon = new TapeMonitor(this.cEventQueue);
            cMon.start();
            try {
                factory = FactoryFactory.createFactory((int)2, null);
                subscriber = factory.createSubscriber(CIMIndicationEvent.class.getName(), null, null, (MessageListener)this);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Successfully subscribed for CIMIndicationEvents");
                }
            }
            catch (Exception e) {
                if (msgLogger.isLogging()) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e, "Subscription for CIMIndicationEvents failed");
                }
                if (!traceLogger.isLogging()) break block6;
                traceLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e, "Subscription for CIMIndicationEvents failed");
            }
        }
        this.cStatus.setRunStatus(8);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public boolean shutdown() {
        this.cStatus.setRunStatus(11);
        if (cMon != null) {
            cMon.shutdown();
            this.cEventQueue.shutdown();
            cMon = null;
        }
        this.cStatus.setRunStatus(10);
        return true;
    }

    public String getDescription() {
        return "Performs discovery and data collection for tape resources";
    }

    public Status getStatus() {
        return this.cStatus;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("getTapeLibraries", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("getTapeLibraryAttributes", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("getComponents", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("getComponentAttributes", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("getComponentLocation", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("getComponentPorts", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("discoverTapeLibraries", new Integer(RoleChecker.TAPE_VIEWER));
        roleMap.put("probeTapeLibraries", new Integer(RoleChecker.TAPE_VIEWER));
        return roleMap;
    }

    public String dispatch(String method, String[] args) {
        return CliDispatcher.dispatch((Object)this, (String)method, (String[])args);
    }

    public AsyncResult discoverTapeLibraries(String[] pCimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return cCollOps.discoverTapeLibraries(pCimomIDs);
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] pCimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.discoverDevicesFromCIMOM(pCimomIDs);
    }

    public AsyncResult probeTapeLibraries(String[] pTapeLibIDs, Integer pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return cCollOps.probeTapeLibraries(pTapeLibIDs, pCollectionType);
    }

    public AsyncResult probeTapeLibraries(String[] pTapeLibIDs, int pCollectionType) throws ServerException, InvalidParameterException, MissingParameterException {
        return cCollOps.probeTapeLibraries(pTapeLibIDs, pCollectionType);
    }

    public HashMap[] getTapeLibraryAttributes(String[] pTapeLibIDs, String[] pAttributes) throws ServerException, InvalidParameterException {
        return cRepOps.getTapeLibraryAttributes(pTapeLibIDs, pAttributes);
    }

    public String[] getComponents(int pComponentType, String pTapeLibID, HashMap pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponents(pComponentType, pTapeLibID, pAttributes);
    }

    public HashMap[] getComponentAttributes(int pComponentType, String[] pComponentIDs, String[] pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentAttributes(pComponentType, pComponentIDs, pAttributes);
    }

    public String[] getComponentPorts(int pComponentType, String[] pComponentIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentPorts(pComponentType, pComponentIDs);
    }

    public String[] getComponentLocation(int pComponentType, String[] pComponentIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentLocation(pComponentType, pComponentIDs);
    }

    public String help() {
        String ret = "Commands accepted by the Tape Manager CLI:\n\n";
        ret = ret + "  startDiscovery <URL>: Start discovery of tape library at the given CIMOM URL\n";
        ret = ret + "  listTapeLibraries: Lists previously discovered tape libraries\n";
        ret = ret + "  attrsOfTapeLibrary <number>: Lists attribute of selected tape library\n";
        ret = ret + "  startProbe <number>: Start basic probe of selected tape library\n";
        ret = ret + "  startDetailedProbe <number>: Start detailed probe of selected tape library\n";
        return ret;
    }

    public String listTapeLibraries() {
        String ret = "";
        String[] libs = this.getTapeLibraries();
        for (int i = 0; i < libs.length; ++i) {
            ret = ret + libs[i] + "\n";
        }
        return ret;
    }

    public String attrsOfTapeLibrary(int nr) {
        String[] libs = this.getTapeLibraries();
        if (nr < 1 || nr > libs.length) {
            return "Error, argument must be between 1 and " + libs.length;
        }
        HashMap hmAttrs = this.getTapeLibraryAttributes(new String[]{libs[nr - 1]}, null)[0];
        return hmAttrs.toString();
    }

    public String startDiscovery(String cimomURL) {
        AsyncResult mResult = this.discoverTapeLibraries(new String[]{cimomURL});
        return "Discovery of tape library started, job ID: " + mResult.getJobId();
    }

    public String startProbe(int nr) {
        String[] libs = this.getTapeLibraries();
        if (nr < 1 || nr > libs.length) {
            return "Error, argument must be between 1 and " + libs.length;
        }
        AsyncResult mResult = this.probeTapeLibraries(new String[]{libs[nr - 1]}, 2);
        return "Basic probe of tape library started, job ID: " + mResult.getJobId();
    }

    public String startDetailedProbe(int nr) {
        String[] libs = this.getTapeLibraries();
        if (nr < 1 || nr > libs.length) {
            return "Error, argument must be between 1 and " + libs.length;
        }
        AsyncResult mResult = this.probeTapeLibraries(new String[]{libs[nr - 1]}, 3);
        return "Detailed probe of tape library started, job ID: " + mResult.getJobId();
    }

    public void onMessage(Message pMsg) {
        String methodName;
        block11: {
            methodName = "onMessage";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (pMsg instanceof ObjectMessage) {
                try {
                    Serializable obj = ((ObjectMessage)pMsg).getObject();
                    if (obj instanceof CIMIndicationEvent) {
                        CIMIndicationEvent cie = (CIMIndicationEvent)obj;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Received CIMIndication: " + cie.getCIMInstance());
                        }
                        if (Configuration.debug) {
                            System.out.println("TapeManagerService received indication, putting on queue");
                        }
                        this.cEventQueue.add(cie);
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Received unexpected indication of type " + obj.getClass().getName());
                    }
                }
                catch (JMSException pEx) {
                    if (msgLogger.isLogging()) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)pEx);
                    }
                    if (!traceLogger.isLogging()) break block11;
                    traceLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)pEx);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public ReadLogResponse getLog(String pName, byte pDirection, LogFilePos position, int pLinesDesired) throws RemoteException {
        String methodName = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        ReadLogResponse rlr = new ReadLogResponse();
        rlr = LogFileHandler.getLog((String)pName, (byte)pDirection, (LogFilePos)position, (int)pLinesDesired);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rlr;
    }

    public ReadLogResponse getLog(String pName, byte pDirection, LogFilePos position, String pSearch, int pLinesDesired) throws RemoteException {
        String methodName = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        ReadLogResponse rlr = new ReadLogResponse();
        rlr = LogFileHandler.getLog((String)pName, (byte)pDirection, (LogFilePos)position, (String)pSearch, (int)pLinesDesired);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rlr;
    }

    public ReadLogResponse getLog(int pAgentID, String pName, byte pDirection, LogFilePos position, int pLinesDesired) throws RemoteException {
        String methodName = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        ReadLogResponse rlr = new ReadLogResponse();
        try {
            rlr = LogFileHandler.getLog((int)pAgentID, (String)pName, (byte)pDirection, (LogFilePos)position, (int)pLinesDesired);
        }
        catch (Exception pEx) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Throwable)pEx);
            }
            rlr = null;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rlr;
    }

    public ReadLogResponse getLog(int pAgentID, String pName, byte pDirection, LogFilePos position, String pSearch, int pLinesDesired) throws RemoteException {
        String methodName = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        ReadLogResponse rlr = new ReadLogResponse();
        try {
            rlr = LogFileHandler.getLog((int)pAgentID, (String)pName, (byte)pDirection, (LogFilePos)position, (String)pSearch, (int)pLinesDesired);
        }
        catch (Exception pEx) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Throwable)pEx);
            }
            rlr = null;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rlr;
    }

    static {
        className = TapeManagerService.class.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }
}

