/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.AlertDefinition;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.monitor.dataservernotification.Notifier;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.tape.TapeActivator;
import org.eclipse.aperi.tape.TapeManagerConstants;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class TapeMonitor
extends Thread
implements TapeManagerConstants {
    private static IConfigService configServiceProxy = null;
    private AlertDefinition cAlertDef = null;
    private int[] PERSEV2OPSTAT = new int[]{0, 1, 2, 3, 3, 5, 6, 7};
    private String[] PERSEV2STRING = new String[]{"Unknown", "Other", "Information", "Degraded/Warning", "Minor", "Major", "Critical", "Fatal/NonRecoverable"};
    protected static String className = TapeMonitor.class.getName();
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    private DiskEventQueue cEventQueue;
    private boolean cShutdown;
    private int cTapeAlertNotificationLevel = 0;
    private static HashMap ibmExtDescMap = new HashMap();

    public TapeMonitor(DiskEventQueue pQ) {
        super("TapeMonitor");
        String mVal;
        this.cEventQueue = pQ;
        IConfigService bConfigService = this.getConfigServiceProxy();
        if (bConfigService != null && (mVal = bConfigService.getProperty("TapeAlertNotificationLevel", "TapeManager")) != null) {
            this.cTapeAlertNotificationLevel = Integer.parseInt(mVal);
        }
    }

    public void run() {
        String methodName = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        while (!this.cShutdown) {
            try {
                CIMIndicationEvent bIndication = this.cEventQueue.remove();
                if (bIndication == null) continue;
                this.processIndication(bIndication);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processIndication(CIMIndicationEvent pCie) {
        block37: {
            methodName = "processIndication";
            if (TapeMonitor.traceLogger.isLogging()) {
                TapeMonitor.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)TapeMonitor.className, methodName);
            }
            ci = pCie.getCIMInstance();
            mSysName = this.getStringProperty(ci, "SystemName", "UnknownSystem");
            if (Configuration.debug) {
                System.out.println("TapeMonitor: Received indication! SystemName: " + mSysName);
            }
            if ((mLib = mSysName.equals("UnknownSystem") == false ? this.getLibForName(mSysName) : null) != null) {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_ENTRY, (Object)TapeMonitor.className, methodName, "Found tape library for " + mSysName);
                }
            } else {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_WARN, (Object)TapeMonitor.className, methodName, "No tape library found for SystemName \"" + mSysName + "\", ignoring");
                }
                return;
            }
            perSev = this.getUInt16Property(ci, "PerceivedSeverity", new UnsignedInt16(0)).intValue();
            if (perSev >= 8) {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_ERR, (Object)TapeMonitor.className, methodName, "Invalid value of PerceivedSeverity: " + perSev + ", can't update status");
                }
                this.sendToDataServer(pCie, mLib, perSev, null);
                return;
            }
            newOpStat = this.PERSEV2OPSTAT[perSev];
            mEventID = this.getStringProperty(ci, "EventID", "");
            if (mEventID.equals("408")) {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_INFO, (Object)TapeMonitor.className, methodName, "Identified indication as test trap, not updating status");
                }
                if (Configuration.debug) {
                    System.out.println("TapeMonitor: Identified indication as test trap, not updating status");
                }
                this.sendToDataServer(pCie, mLib, perSev, null);
                return;
            }
            aeFormat = this.getUInt16Property(ci, "AlertingElementFormat", new UnsignedInt16(0));
            if (aeFormat.intValue() != 2) {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_WARN, (Object)TapeMonitor.className, methodName, "AlertingManagedElement not in CIMObjectPath format, can't update status");
                }
                this.sendToDataServer(pCie, mLib, perSev, null);
                return;
            }
            strCop = this.getStringProperty(ci, "AlertingManagedElement", "");
            cop = null;
            try {
                cop = this.parseToCOP(strCop);
            }
            catch (Exception e) {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)TapeMonitor.className, methodName, (Throwable)e, "Exception from parseToCOP");
                }
                this.sendToDataServer(pCie, mLib, perSev, null);
                return;
            }
            if (cop == null) {
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_ERR, (Object)TapeMonitor.className, methodName, "Error while parsing AlertingManagedElement as CIMObjectPath, can't update status");
                }
                this.sendToDataServer(pCie, mLib, perSev, null);
                return;
            }
            ciAE = new CIMInstance(cop);
            if (TapeMonitor.traceLogger.isLogging()) {
                TapeMonitor.traceLogger.text(IRecordType.TYPE_ERR, (Object)TapeMonitor.className, methodName, "Found CIMInstance for AlertingManagedElement:\n" + ciAE);
            }
            mConn = ServiceUtils.getConnection();
            affElDispName = "";
            try {
                affElDispName = this.updateElementOpStatus(mConn, ciAE, newOpStat, mLib);
                if (TapeMonitor.traceLogger.isLogging()) {
                    TapeMonitor.traceLogger.text(IRecordType.TYPE_INFO, (Object)TapeMonitor.className, methodName, "updateElementOpStatus returned: " + affElDispName);
                }
                ** if (mConn == null) goto lbl-1000
            }
            catch (SQLException pEx) {
                try {
                    if (TapeMonitor.traceLogger.isLogging()) {
                        TapeMonitor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)TapeMonitor.className, methodName, (Throwable)pEx, "Exception in updateElementOpStatus");
                    }
                    if (mConn == null) break block37;
                }
                catch (Throwable var16_19) {
                    if (mConn != null) {
                        try {
                            mConn.commit();
                            mConn.close();
                        }
                        catch (SQLException pEx) {
                            if (TapeMonitor.traceLogger.isLogging()) {
                                TapeMonitor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)TapeMonitor.className, methodName, (Throwable)pEx);
                            }
                            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                        }
                    }
                    throw var16_19;
                }
                try {
                    mConn.commit();
                    mConn.close();
                }
                catch (SQLException pEx) {
                    if (TapeMonitor.traceLogger.isLogging()) {
                        TapeMonitor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)TapeMonitor.className, methodName, (Throwable)pEx);
                    }
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    mConn.commit();
                    mConn.close();
                }
                catch (SQLException pEx) {
                    if (TapeMonitor.traceLogger.isLogging()) {
                        TapeMonitor.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)TapeMonitor.className, methodName, (Throwable)pEx);
                    }
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        this.sendToDataServer(pCie, mLib, perSev, affElDispName);
        if (TapeMonitor.traceLogger.isLogging()) {
            TapeMonitor.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)TapeMonitor.className, methodName);
        }
    }

    private String getStringProperty(CIMInstance pCi, String pProp, String pDefault) {
        CIMValue cv;
        CIMProperty cp = pCi.getProperty(pProp);
        String val = cp != null ? ((cv = cp.getValue()) != null ? (String)cv.getValue() : pDefault) : pDefault;
        return val;
    }

    private UnsignedInt16 getUInt16Property(CIMInstance pCi, String pProp, UnsignedInt16 pDefault) {
        CIMValue cv;
        CIMProperty cp = pCi.getProperty(pProp);
        UnsignedInt16 val = cp != null ? ((cv = cp.getValue()) != null ? (UnsignedInt16)cp.getValue().getValue() : pDefault) : pDefault;
        return val;
    }

    private String updateElementOpStatus(DBConnection pDbConn, CIMInstance ciAE, int pNewOpStat, TapeLibrary pLib) throws SQLException {
        String methodName = "updateElementOpStatus";
        String dispName = "";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        boolean result = false;
        String cn = ciAE.getClassName();
        short consStat = Short.parseShort(DBConstants.getValueFromKey((String)"Operational2ConsolidatedStatus", (String)Integer.toString(pNewOpStat)));
        Vector<String> opVec = new Vector<String>();
        opVec.add(new Integer(pNewOpStat).toString());
        String opBitVal = DBConstants.convertOperationalstatusArrayToBitValue(opVec);
        int opStat = Integer.parseInt(opBitVal);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, methodName, "Class name of AlertingManagedElement: " + cn);
        }
        if (cn.equalsIgnoreCase("IBMTSSML3584_TapeDrive") || cn.equalsIgnoreCase("CIM_MediaAccessDevice")) {
            TapeDrive mDrive = null;
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            String devId = this.getStringProperty(ciAE, "DeviceID", "unknown");
            if (!devId.equals("unknown")) {
                mWhereClause.put(TapeDrive.getColumnInfo((String)"TAPE_LIBRARY_ID"), new Integer(pLib.getTapeLibraryId()).toString());
                mWhereClause.put(TapeDrive.getColumnInfo((String)"DEVICE_ID"), devId);
                TapeDrive.TapeDriveCursor mCursor = TapeDrive.getCursor((DBConnection)pDbConn, mWhereClause, null);
                if (mCursor.next()) {
                    mDrive = mCursor.getObject();
                }
                mCursor.close();
                pDbConn.commit();
            }
            if (mDrive != null) {
                if (opStat > mDrive.getOperationalStatus()) {
                    mDrive.setOperationalStatus(opStat);
                    mDrive.setConsolidatedStatus(consStat);
                    result = mDrive.update(pDbConn) > 0;
                }
                dispName = mDrive.getDisplayName();
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "No matching drive found in database for devId: " + devId + ", libId: " + pLib.getTapeLibraryId());
            }
        } else if (cn.equalsIgnoreCase("IBMTSSML3584_ChangerDevice") || cn.equalsIgnoreCase("CIM_ChangerDevice")) {
            TapeMediaChanger mChanger = null;
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            String devId = this.getStringProperty(ciAE, "DeviceID", "unknown");
            if (!devId.equals("unknown")) {
                mWhereClause.put(TapeMediaChanger.getColumnInfo((String)"SYSTEM_NAMES_ID"), new Integer(pLib.getTapeLibraryId()).toString());
                mWhereClause.put(TapeMediaChanger.getColumnInfo((String)"DEVICE_ID"), devId);
                TapeMediaChanger.TapeMediaChangerCursor mCursor = TapeMediaChanger.getCursor((DBConnection)pDbConn, mWhereClause, null);
                if (mCursor.next()) {
                    mChanger = mCursor.getObject();
                }
                mCursor.close();
                pDbConn.commit();
            }
            if (mChanger != null) {
                if (opStat > mChanger.getOperationalStatus()) {
                    mChanger.setOperationalStatus(opStat);
                    mChanger.setConsolidatedStatus(consStat);
                    result = mChanger.update(pDbConn) > 0;
                }
                dispName = mChanger.getDisplayName();
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "No matching media changer found in database for devId: " + devId + ", libId: " + pLib.getTapeLibraryId());
            }
        } else if (cn.equalsIgnoreCase("IBMTSSML3584_TapeLibrary") || cn.equalsIgnoreCase("CIM_ComputerSystem")) {
            if (opStat > pLib.getOperationalStatus()) {
                pLib.setOperationalStatus(opStat);
                pLib.setConsolidatedStatus(consStat);
                result = pLib.update(pDbConn) > 0;
            }
            dispName = pLib.getDisplayName();
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Alert came from unknown element \"" + cn + "\"");
            }
            return dispName;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, result);
        }
        return dispName;
    }

    private CIMObjectPath parseToCOP(String strCop) {
        String[] splitStr = strCop.split(":", 2);
        if (splitStr.length < 2) {
            return null;
        }
        String ns = splitStr[0];
        strCop = splitStr[1];
        splitStr = strCop.split("\\.", 2);
        String cn = splitStr[0];
        strCop = splitStr[1];
        splitStr = strCop.split(",");
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        for (int i = 0; i < splitStr.length; ++i) {
            String[] prop = splitStr[i].split("=");
            CIMProperty cp = new CIMProperty(prop[0]);
            cp.setValue(new CIMValue((Object)prop[1].replaceAll("^\"|\"$", ""), new CIMDataType(8)));
            keys.add(cp);
        }
        CIMObjectPath cop = new CIMObjectPath(cn, ns);
        if (cop != null) {
            cop.setKeys(keys);
        }
        return cop;
    }

    private void sendToDataServer(CIMIndicationEvent pCie, TapeLibrary pLib, int pPerSev, String pElName) {
        String methodName = "updateElementOpStatus";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        boolean result = true;
        if (pPerSev >= this.cTapeAlertNotificationLevel) {
            int libId;
            CIMInstance ci = pCie.getCIMInstance();
            String cause = this.getStringProperty(ci, "ProbableCauseDescription", "Cause unknown");
            ArrayList<String> al = new ArrayList<String>();
            al.add(cause + "\n");
            if (pElName != null && pElName.length() > 0) {
                al.add("Affected Element: " + pElName);
            }
            if (pPerSev >= 0 && pPerSev <= 7) {
                al.add("Perceived Severity: " + pPerSev + " (" + this.PERSEV2STRING[pPerSev] + ")");
            } else {
                al.add("Perceived Severity: " + pPerSev);
            }
            String mEventID = this.getStringProperty(ci, "EventID", "not specified");
            al.add("Event ID: " + mEventID + "\n");
            CIMProperty xProp = ci.getProperty("ExtraInfoDescriptions");
            CIMProperty xPropVals = ci.getProperty("ExtraInfoValues");
            int sortFrom = -1;
            int sortTo = -1;
            if (xProp != null && xPropVals != null) {
                sortFrom = al.size();
                Vector xPropVec = (Vector)xProp.getValue().getValue();
                Vector xPropValsVec = (Vector)xPropVals.getValue().getValue();
                Enumeration eProp = xPropVec.elements();
                Enumeration ePropVals = xPropValsVec.elements();
                while (eProp.hasMoreElements()) {
                    String prop = (String)eProp.nextElement();
                    if (!ePropVals.hasMoreElements()) continue;
                    String val = (String)ePropVals.nextElement();
                    String desc = (String)ibmExtDescMap.get(prop);
                    if (desc != null) {
                        if (prop.equals("ibm3584MIBObjectsTA") && val.equals("0")) {
                            al.add(desc + ": None");
                            continue;
                        }
                        al.add(desc + ": " + val);
                        continue;
                    }
                    al.add(prop + ": " + val);
                }
                sortTo = al.size();
            }
            Object[] parms = al.toArray(new String[0]);
            if (sortFrom > -1 && sortTo > -1) {
                Arrays.sort(parms, sortFrom, sortTo);
            }
            int n = libId = pLib != null ? pLib.getTapeLibraryId() : -1;
            if (this.cAlertDef == null) {
                this.cAlertDef = new AlertDefinition();
                this.cAlertDef.aldAlertID = this.getAlertDefID();
            }
            Alert alert = new Alert(-1, libId, 134, this.cAlertDef, (String[])parms, 0, (int[][])null, null);
            Notifier notif = new Notifier();
            result = notif.sendAlert(alert);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Alert " + (result ? "successfully " : "couldn't be ") + "sent to Data Server");
            }
            if (Configuration.debug) {
                System.out.println("Alert " + (result ? "successfully " : "couldn't be ") + "sent to Data Server");
            }
        } else {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "PerceivedSeverity of indication lower than TapeAlertNotificationLevel (" + pPerSev + " < " + this.cTapeAlertNotificationLevel + "), " + "not sending to data server");
            }
            if (Configuration.debug) {
                System.out.println("PerceivedSeverity of indication lower than TapeAlertNotificationLevel (" + pPerSev + " < " + this.cTapeAlertNotificationLevel + "), " + "not sending to data server");
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAlertDefID() {
        String methodName = "getAlertDefID";
        int alDefID = -1;
        org.eclipse.aperi.infrastructure.database.objects.AlertDefinition mAlDefTable = null;
        DBConnection mConn = ServiceUtils.getConnection();
        AlertDefinition.AlertDefinitionCursor mCursor = null;
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
        mWhereClause.put(org.eclipse.aperi.infrastructure.database.objects.AlertDefinition.getColumnInfo((String)"CONDITION"), new Integer(109).toString());
        mCursor = org.eclipse.aperi.infrastructure.database.objects.AlertDefinition.getCursor((DBConnection)mConn, mWhereClause, null);
        if (mCursor.next()) {
            mAlDefTable = mCursor.getAttributes();
            alDefID = mAlDefTable.getAlertId();
        }
        mCursor.close();
        mConn.commit();
        if (mConn == null) return alDefID;
        try {
            mConn.close();
            return alDefID;
        }
        catch (SQLException pEx) {
            if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
        }
        catch (SQLException pEx) {
            int n;
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                }
                n = alDefID;
                if (mConn == null) return n;
            }
            catch (Throwable throwable) {
                if (mConn == null) throw throwable;
                try {
                    mConn.close();
                    throw throwable;
                }
                catch (SQLException pEx2) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                }
            }
            try {
                mConn.close();
                return n;
            }
            catch (SQLException pEx3) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx3);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TapeLibrary getLibForName(String pSysName) {
        TapeLibrary tapeLibrary;
        String methodName = "getLibForName";
        DBConnection mConn = ServiceUtils.getConnection();
        TapeLibrary.TapeLibraryCursor mCursor = null;
        TapeFrame.TapeFrameCursor mFrameCursor = null;
        try {
            try {
                TapeLibrary lib = null;
                Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                mWhereClause.put(TapeLibrary.getColumnInfo((String)"NAME"), pSysName);
                mCursor = TapeLibrary.getCursor((DBConnection)mConn, mWhereClause, null);
                if (mCursor.next()) {
                    lib = mCursor.getObject();
                }
                if (lib == null) {
                    String[] pieces = pSysName.split(" ");
                    String mSerial = pieces[pieces.length - 1].replaceFirst("^\\+", "");
                    if (Configuration.debug) {
                        System.out.println("Library not found for SystemName " + pSysName);
                        System.out.println("Trying to locate via Frame for serial " + mSerial);
                    }
                    TapeFrame frame = null;
                    mWhereClause.clear();
                    mWhereClause.put(TapeFrame.getColumnInfo((String)"SERIAL_NUMBER"), mSerial);
                    mFrameCursor = TapeFrame.getCursor((DBConnection)mConn, mWhereClause, null);
                    if (mFrameCursor.next()) {
                        frame = mFrameCursor.getAttributes();
                    }
                    if (frame != null) {
                        mWhereClause.clear();
                        mWhereClause.put(TapeLibrary.getColumnInfo((String)"TAPE_LIBRARY_ID"), new Integer(frame.getTapeLibraryId()).toString());
                        mCursor = TapeLibrary.getCursor((DBConnection)mConn, mWhereClause, null);
                        if (mCursor.next()) {
                            lib = mCursor.getObject();
                        }
                    }
                    if (Configuration.debug) {
                        System.out.println("Library " + (lib != null ? "" : "not") + " found via Frame");
                    }
                }
                tapeLibrary = lib;
                Object var12_13 = null;
                if (mConn == null) return tapeLibrary;
            }
            catch (SQLException pEx) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                }
                TapeLibrary tapeLibrary2 = null;
                Object var12_14 = null;
                if (mConn == null) return tapeLibrary2;
                try {
                    if (mCursor != null) {
                        mCursor.close();
                    }
                    if (mFrameCursor != null) {
                        mFrameCursor.close();
                    }
                    mConn.commit();
                    mConn.close();
                    return tapeLibrary2;
                }
                catch (SQLException pEx2) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                    }
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (mConn == null) throw throwable;
            try {}
            catch (SQLException pEx2) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                }
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
            }
            if (mCursor != null) {
                mCursor.close();
            }
            if (mFrameCursor != null) {
                mFrameCursor.close();
            }
            mConn.commit();
            mConn.close();
            throw throwable;
        }
        try {}
        catch (SQLException pEx2) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
            }
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
        }
        if (mCursor != null) {
            mCursor.close();
        }
        if (mFrameCursor != null) {
            mFrameCursor.close();
        }
        mConn.commit();
        mConn.close();
        return tapeLibrary;
    }

    public void shutdown() {
        String methodName = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (Configuration.debug) {
            System.out.println("TapeMonitor shutting down");
        }
        this.cShutdown = true;
        this.cEventQueue.add(null);
        Thread mThread = Thread.currentThread();
        if (mThread != null) {
            try {
                mThread.interrupt();
                mThread.join(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mThread = null;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)TapeActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
        ibmExtDescMap.put("ibm3584MIBGroupDrvSN", "Drive Serial Number");
        ibmExtDescMap.put("ibm3584MIBGroupEA", "Element Address");
        ibmExtDescMap.put("ibm3584MIBGroupFFFD", "Failing Frame, Failing Drive");
        ibmExtDescMap.put("ibm3584MIBGroupFSC", "Fault Symptom Code");
        ibmExtDescMap.put("ibm3584MIBGroupHECHECQ", "Hardware Error Code");
        ibmExtDescMap.put("ibm3584MIBGroupLL", "Logical Library");
        ibmExtDescMap.put("ibm3584MIBGroupSCD", "Drive Single Character Display");
        ibmExtDescMap.put("ibm3584MIBGroupSKASCASCQ", "Sense Key, ASC, ASCQ");
        ibmExtDescMap.put("ibm3584MIBGroupURC", "URC");
        ibmExtDescMap.put("ibm3584MIBGroupVOLSER", "Cartridge Volume Serial Number");
        ibmExtDescMap.put("ibm3584MIBObjectsTA", "TapeAlert Flag");
    }
}

