/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Node;
import org.eclipse.aperi.infrastructure.database.objects.TapeCartridge;
import org.eclipse.aperi.infrastructure.database.objects.TapeDrive;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeIoport;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaChanger;
import org.eclipse.aperi.infrastructure.database.objects.TapeMediaLocation;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.tape.api.ITapeReportingService;

public class TapeReportingService
implements ITapeReportingService {
    private static final int GET_KEYS = 0;
    private static final int GET_ATTRS = 1;
    protected static String className = TapeReportingService.class.getName();
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;
    private String[] SECBREACH2STRING = new String[]{"Unknown", "Other", "Unknown", "No Breach", "Breach Attempted", "Breach Successful"};
    private String[] MEDIATYPE2STRING = new String[]{"Unknown", "Other", "Tape", "QIC", "AIT", "DFT", "DAT", "Eight MM Tape", "Nineteen MM Tape", "DLT", "Half Inch MO", "Cartridge Disk", "Jaz Disk", "Zip disk", "SyQuest Disk", "Winchester Disk", "CDROM", "CDROMXA", "CDI", "CD Recordable", "Worm", "Magneto-Optical", "DVD", "DVDRWPlus", "DVDRAM", "DVDROM", "DVD Video", "DIVX", "Floppy Diskette", "Harddisk", "Memory Card", "Hardcopy", "Clikdisk", "CDRW", "CDDA", "CD Plus", "DVD Recordable", "DVDRW", "DVD Audio", "DVD5", "DVD9", "DVD10", "DVD18", "MO Rewritable", "MO Write Once", "MO LIMDOW", "Phase Change WO", "Phase Change Rewritable", "Phase Change Dual Rewritable", "Ablative Write Once", "Near Field", "Mini Qic", "Travan", "Eight MM Metal", "Eight MM Advanced", "NCTP", "LTO Ultrium", "LTO Accelis", "Tape 9 Track", "Tape 18 Track", "Take 36 Track", "Tape 36 Track", "Magstar 3590", "Magstar MP", "D2Tape", "DST Small", "DST Medium"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getTapeLibraries(HashMap pAttributes) throws ServerException, InvalidParameterException {
        String[] stringArray;
        DBConnection mConn;
        String methodName;
        block22: {
            methodName = "getTapeLibraries";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            LinkedList<String> mReturn = new LinkedList<String>();
            mConn = ServiceUtils.getConnection();
            TapeLibrary.TapeLibraryCursor mCursor = null;
            try {
                try {
                    Hashtable mWhereClause = null;
                    if (pAttributes != null) {
                        mWhereClause = this.createWhereClauseMap(TapeLibrary.class, pAttributes);
                    }
                    mCursor = TapeLibrary.getCursor((DBConnection)mConn, mWhereClause, null);
                    while (mCursor.next()) {
                        TapeLibrary mCurrInst = mCursor.getAttributes();
                        mReturn.add(mCurrInst.getName() + "-multikey-" + mCurrInst.getNameFormat());
                    }
                    stringArray = mReturn.toArray(new String[0]);
                    Object var9_9 = null;
                    if (mCursor == null) break block22;
                }
                catch (SQLException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (mCursor != null) {
                    try {
                        mCursor.close();
                    }
                    catch (SQLException pEx2) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                    }
                }
                if (mConn != null) {
                    try {
                        mConn.commit();
                        mConn.close();
                    }
                    catch (SQLException pEx3) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx3);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                throw throwable;
            }
            try {}
            catch (SQLException pEx2) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
            }
            mCursor.close();
        }
        if (mConn != null) {
            try {}
            catch (SQLException pEx3) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx3);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
            }
            mConn.commit();
            mConn.close();
        }
        if (!traceLogger.isLogging()) return stringArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return stringArray;
    }

    public String[] getTapeLibraries() throws ServerException, InvalidParameterException {
        return this.getTapeLibraries(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getTapeLibraryAttributes(String[] pTapeLibIDs, String[] pAttributes) throws ServerException, InvalidParameterException {
        HashMap[] i2222;
        DBConnection mConn;
        String methodName;
        block25: {
            methodName = "getTapeLibraryAttributes";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (pTapeLibIDs == null || pTapeLibIDs.length == 0) {
                pTapeLibIDs = this.getTapeLibraries();
            }
            HashMap[] mTLArray = new HashMap[pTapeLibIDs.length];
            mConn = ServiceUtils.getConnection();
            TapeLibrary.TapeLibraryCursor mCursor = null;
            try {
                try {
                    for (int i2222 = 0; i2222 < pTapeLibIDs.length; ++i2222) {
                        HashMap<String, String> mKey = new HashMap<String, String>();
                        String[] keys = pTapeLibIDs[i2222].split("-multikey-");
                        mKey.put("NAME", keys[0]);
                        if (keys.length > 1) {
                            mKey.put("NAME_FORMAT", keys[1]);
                        }
                        Hashtable mWhereClause = this.createWhereClauseMap(TapeLibrary.class, mKey);
                        HashMap mTapeLib = null;
                        mCursor = TapeLibrary.getCursor((DBConnection)mConn, (Hashtable)mWhereClause, null);
                        while (mCursor.next()) {
                            TapeLibrary mCurrInst = mCursor.getAttributes();
                            mTapeLib = this.getAttributes(mCurrInst, pAttributes);
                        }
                        mCursor.close();
                        mCursor = null;
                        if (mTapeLib == null) {
                            throw new InvalidParameterException(1, new SRMMessage("HWNTM1519E", new String[]{pTapeLibIDs[i2222]}));
                        }
                        mTLArray[i2222] = mTapeLib;
                    }
                    i2222 = mTLArray;
                    Object var14_15 = null;
                    if (mCursor == null) break block25;
                }
                catch (SQLException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (mCursor != null) {
                    try {
                        mCursor.close();
                    }
                    catch (SQLException pEx2) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                    }
                }
                if (mConn != null) {
                    try {
                        mConn.commit();
                        mConn.close();
                    }
                    catch (SQLException pEx3) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx3);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                throw throwable;
            }
            try {}
            catch (SQLException pEx2) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
            }
            mCursor.close();
        }
        if (mConn != null) {
            try {}
            catch (SQLException pEx3) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx3);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx3.getMessage()}));
            }
            mConn.commit();
            mConn.close();
        }
        if (!traceLogger.isLogging()) return i2222;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return i2222;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponents(int pComponentType, String pTapeLibID, HashMap pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        String methodName;
        block27: {
            methodName = "getComponents";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            DBConnection mConn = ServiceUtils.getConnection();
            try {
                try {
                    List mReturn;
                    if (pTapeLibID != null) {
                        int libId;
                        if (pAttributes == null) {
                            pAttributes = new HashMap();
                        }
                        if ((libId = this.getTapeLibID(mConn, pTapeLibID)) >= 0) {
                            pAttributes.put("TAPE_LIBRARY_ID", new Integer(libId).toString());
                        } else {
                            if (!traceLogger.isLogging()) throw new InvalidParameterException(2, new SRMMessage("HWNTM1519E", new String[]{pTapeLibID}));
                            traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Couldn't find tape library for " + pTapeLibID);
                            throw new InvalidParameterException(2, new SRMMessage("HWNTM1519E", new String[]{pTapeLibID}));
                        }
                    }
                    Hashtable mWhereClause = null;
                    Class compClass = this.getClassForCompType(pComponentType);
                    if (pAttributes != null) {
                        mWhereClause = this.createWhereClauseMap(compClass, pAttributes);
                    }
                    switch (pComponentType) {
                        case 1: {
                            mReturn = this.getDrivesKeysAttrs(mConn, mWhereClause, 0, null);
                            break;
                        }
                        case 2: {
                            mReturn = this.getChangersKeysAttrs(mConn, mWhereClause, 0, null);
                            break;
                        }
                        case 3: {
                            mReturn = this.getIoPortsKeysAttrs(mConn, mWhereClause, 0, null);
                            break;
                        }
                        case 4: {
                            mReturn = this.getCartridgesKeysAttrs(mConn, mWhereClause, 0, null);
                            break;
                        }
                        case 5: {
                            mReturn = this.getFramesKeysAttrs(mConn, mWhereClause, 0, null);
                            break;
                        }
                        case 6: {
                            mReturn = this.getLocationsKeysAttrs(mConn, mWhereClause, 0, null);
                            break;
                        }
                        default: {
                            throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
                        }
                    }
                    stringArray = mReturn.toArray(new String[0]);
                    Object var11_12 = null;
                    if (mConn == null) break block27;
                }
                catch (SQLException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (mConn != null) {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pEx2) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                throw throwable;
            }
            try {}
            catch (SQLException pEx2) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx2);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx2.getMessage()}));
            }
            mConn.close();
        }
        if (!traceLogger.isLogging()) return stringArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getComponentAttributes(int pComponentType, String[] pComponentIDs, String[] pAttributes) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] i2;
        String methodName;
        block36: {
            methodName = "getComponentAttributes";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (pComponentIDs == null || pComponentIDs.length == 0) {
                if (pComponentType != 7) {
                    pComponentIDs = this.getComponents(pComponentType, null, null);
                } else {
                    String[] drivePorts = this.getComponentPorts(1, null);
                    String[] changerPorts = this.getComponentPorts(1, null);
                    pComponentIDs = new String[drivePorts.length + changerPorts.length];
                    System.arraycopy(drivePorts, 0, pComponentIDs, 0, drivePorts.length);
                    System.arraycopy(changerPorts, 0, pComponentIDs, drivePorts.length, changerPorts.length);
                }
            }
            HashMap[] mCompArray = new HashMap[pComponentIDs.length];
            DBConnection mConn = ServiceUtils.getConnection();
            Class mClass = this.getClassForCompType(pComponentType);
            try {
                try {
                    for (int i2 = 0; i2 < pComponentIDs.length; ++i2) {
                        Hashtable mWhereClause;
                        String[] keys;
                        HashMap<String, String> mKey = new HashMap<String, String>();
                        if (pComponentType == 1 || pComponentType == 2 || pComponentType == 3) {
                            keys = pComponentIDs[i2].split("-multikey-");
                            mKey.put((String)mClass.getField("TAPE_LIBRARY_ID").get(null), keys[0]);
                            mKey.put((String)mClass.getField("DEVICE_ID").get(null), keys[1]);
                            mWhereClause = this.createWhereClauseMap(this.getClassForCompType(pComponentType), mKey);
                        } else if (pComponentType == 5 || pComponentType == 4 || pComponentType == 6) {
                            mKey.put((String)mClass.getField("TAG").get(null), pComponentIDs[i2]);
                            mWhereClause = this.createWhereClauseMap(this.getClassForCompType(pComponentType), mKey);
                        } else {
                            if (pComponentType != 7) {
                                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
                            }
                            keys = pComponentIDs[i2].split("-multikey-");
                            mKey.put((String)mClass.getField("NAME").get(null), keys[0]);
                            mKey.put((String)mClass.getField("NAME_FORMAT").get(null), keys[1]);
                            mWhereClause = this.createWhereClauseMap(this.getClassForCompType(pComponentType), mKey);
                        }
                        HashMap mCompAttrs = null;
                        switch (pComponentType) {
                            case 1: {
                                mCompAttrs = (HashMap)this.getDrivesKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            case 2: {
                                mCompAttrs = (HashMap)this.getChangersKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            case 3: {
                                mCompAttrs = (HashMap)this.getIoPortsKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            case 4: {
                                mCompAttrs = (HashMap)this.getCartridgesKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            case 5: {
                                mCompAttrs = (HashMap)this.getFramesKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            case 6: {
                                mCompAttrs = (HashMap)this.getLocationsKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            case 7: {
                                mCompAttrs = (HashMap)this.getPortsKeysAttrs(mConn, mWhereClause, 1, pAttributes).get(0);
                                break;
                            }
                            default: {
                                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
                            }
                        }
                        if (mCompAttrs == null) {
                            throw new InvalidParameterException(1, new SRMMessage("HWNTM1519E", new String[]{pComponentIDs[i2]}));
                        }
                        mCompArray[i2] = mCompAttrs;
                    }
                    i2 = mCompArray;
                    Object var13_16 = null;
                    if (mConn == null) break block36;
                }
                catch (SQLException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
                catch (IllegalAccessException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
                catch (NoSuchFieldException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (mConn != null) {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pEx) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                throw throwable;
            }
            try {}
            catch (SQLException pEx) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
            }
            mConn.close();
        }
        if (!traceLogger.isLogging()) return i2;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return i2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponentPorts(int pComponentType, String[] pComponentIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] i2;
        String methodName;
        block25: {
            methodName = "getComponentPorts";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (pComponentType != 1 && pComponentType != 2) {
                if (!traceLogger.isLogging()) throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
                traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Invalid component type: " + pComponentType);
                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
            }
            if (pComponentIDs == null || pComponentIDs.length == 0) {
                pComponentIDs = this.getComponents(pComponentType, null, null);
            }
            DBConnection mConn = ServiceUtils.getConnection();
            LinkedList mReturn = new LinkedList();
            Class mClass = this.getClassForCompType(pComponentType);
            try {
                try {
                    for (int i2 = 0; i2 < pComponentIDs.length; ++i2) {
                        HashMap<String, String> mKey = new HashMap<String, String>();
                        mKey.clear();
                        String[] keys = pComponentIDs[i2].split("-multikey-");
                        mKey.put((String)mClass.getField("TAPE_LIBRARY_ID").get(null), keys[0]);
                        mKey.put((String)mClass.getField("DEVICE_ID").get(null), keys[1]);
                        Hashtable mWhereClause = this.createWhereClauseMap(this.getClassForCompType(pComponentType), mKey);
                        String nodeId = null;
                        switch (pComponentType) {
                            case 1: {
                                HashMap mCompAttrs = (HashMap)this.getDrivesKeysAttrs(mConn, mWhereClause, 1, new String[]{"NODE_ID"}).get(0);
                                nodeId = ((Integer)mCompAttrs.get("NODE_ID")).toString();
                                break;
                            }
                            case 2: {
                                HashMap mCompAttrs = (HashMap)this.getChangersKeysAttrs(mConn, mWhereClause, 1, new String[]{"NODE_ID"}).get(0);
                                nodeId = ((Integer)mCompAttrs.get("NODE_ID")).toString();
                                break;
                            }
                        }
                        mKey.clear();
                        mKey.put("NODE_ID", nodeId);
                        mWhereClause = this.createWhereClauseMap(Node.class, mKey);
                        mReturn.addAll(this.getPortsKeysAttrs(mConn, mWhereClause, 0, null));
                    }
                    i2 = mReturn.toArray(new String[0]);
                    Object var14_17 = null;
                    if (mConn == null) break block25;
                }
                catch (SQLException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
                catch (IllegalAccessException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
                catch (NoSuchFieldException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (mConn != null) {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pEx) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                throw throwable;
            }
            try {}
            catch (SQLException pEx) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
            }
            mConn.close();
        }
        if (!traceLogger.isLogging()) return i2;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return i2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getComponentLocation(int pComponentType, String[] pComponentIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        String methodName;
        block32: {
            methodName = "getComponentLocation";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (pComponentType == 5 || pComponentType == 6 || pComponentType == 7) {
                if (!traceLogger.isLogging()) throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
                traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "Invalid component type: " + pComponentType);
                throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
            }
            if ((pComponentIDs == null || pComponentIDs.length == 0) && pComponentType != 8) {
                pComponentIDs = this.getComponents(pComponentType, null, null);
            }
            DBConnection mConn = ServiceUtils.getConnection();
            LinkedList mReturn = new LinkedList();
            Class mClass = this.getClassForCompType(pComponentType);
            try {
                try {
                    HashMap<String, String> mKey = new HashMap<String, String>();
                    if (pComponentType == 8) {
                        mKey.put("LOCATION_TYPE", "2");
                        Hashtable mWhereClause = this.createWhereClauseMap(TapeMediaLocation.class, mKey);
                        mReturn.addAll(this.getLocationsKeysAttrs(mConn, mWhereClause, 0, null));
                    } else {
                        for (int i = 0; i < pComponentIDs.length; ++i) {
                            Hashtable mWhereClause;
                            mKey.clear();
                            if (pComponentType == 1 || pComponentType == 2 || pComponentType == 3) {
                                String[] keys = pComponentIDs[i].split("-multikey-");
                                mKey.put((String)mClass.getField("TAPE_LIBRARY_ID").get(null), keys[0]);
                                mKey.put((String)mClass.getField("DEVICE_ID").get(null), keys[1]);
                                mWhereClause = this.createWhereClauseMap(this.getClassForCompType(pComponentType), mKey);
                            } else {
                                if (pComponentType != 5 && pComponentType != 4 && pComponentType != 6) {
                                    throw new InvalidParameterException(1, new SRMMessage("HWNTM0003E", new String[]{"Invalid component type: " + new Integer(pComponentType)}));
                                }
                                mKey.put((String)mClass.getField("TAG").get(null), pComponentIDs[i]);
                                mWhereClause = this.createWhereClauseMap(this.getClassForCompType(pComponentType), mKey);
                            }
                            String locId = null;
                            switch (pComponentType) {
                                case 1: {
                                    HashMap mCompAttrs = (HashMap)this.getDrivesKeysAttrs(mConn, mWhereClause, 1, new String[]{"LOCATION_ID"}).get(0);
                                    locId = ((Integer)mCompAttrs.get("LOCATION_ID")).toString();
                                    break;
                                }
                                case 2: {
                                    HashMap mCompAttrs = (HashMap)this.getChangersKeysAttrs(mConn, mWhereClause, 1, new String[]{"LOCATION_ID"}).get(0);
                                    locId = ((Integer)mCompAttrs.get("LOCATION_ID")).toString();
                                    break;
                                }
                                case 4: {
                                    HashMap mCompAttrs = (HashMap)this.getCartridgesKeysAttrs(mConn, mWhereClause, 1, new String[]{"LOCATION_ID"}).get(0);
                                    locId = ((Integer)mCompAttrs.get("LOCATION_ID")).toString();
                                    break;
                                }
                                case 3: {
                                    HashMap mCompAttrs = (HashMap)this.getIoPortsKeysAttrs(mConn, mWhereClause, 1, new String[]{"LOCATION_ID"}).get(0);
                                    locId = ((Integer)mCompAttrs.get("LOCATION_ID")).toString();
                                    break;
                                }
                            }
                            mKey.clear();
                            mKey.put("LOCATION_ID", locId);
                            mWhereClause = this.createWhereClauseMap(TapeMediaLocation.class, mKey);
                            mReturn.addAll(this.getLocationsKeysAttrs(mConn, mWhereClause, 0, null));
                        }
                    }
                    stringArray = mReturn.toArray(new String[0]);
                    Object var13_17 = null;
                    if (mConn == null) break block32;
                }
                catch (SQLException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
                catch (IllegalAccessException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
                catch (NoSuchFieldException pEx) {
                    if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                    throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                }
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (mConn != null) {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pEx) {
                        if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                        throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                    }
                }
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                throw throwable;
            }
            try {}
            catch (SQLException pEx) {
                if (!traceLogger.isLogging()) throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
                throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
            }
            mConn.close();
        }
        if (!traceLogger.isLogging()) return stringArray;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return stringArray;
    }

    private Hashtable createWhereClauseMap(Class pClass, HashMap pAttributes) {
        Hashtable mReturn = new Hashtable();
        for (String mKey : pAttributes.keySet()) {
            mReturn.put(this.getColumnInfo(pClass, mKey), pAttributes.get(mKey));
        }
        return mReturn;
    }

    private ColumnInfo getColumnInfo(Class pClass, String pKey) {
        String methodName = "getColumnInfo";
        try {
            Method mGCIMethod = pClass.getMethod("getColumnInfo", String.class);
            return (ColumnInfo)mGCIMethod.invoke(null, pKey);
        }
        catch (Exception pEx) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
            }
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
        }
    }

    private HashMap getAttributes(Object pCurrInst, String[] pAttributes) {
        String methodName = "getAttributes";
        HashMap<String, Object> mReturn = new HashMap<String, Object>();
        try {
            Method[] mMethods = pCurrInst.getClass().getMethods();
            if (pAttributes != null) {
                for (int i = 0; i < pAttributes.length; ++i) {
                    Method mMethod = this.findGetter(mMethods, pAttributes[i]);
                    if (mMethod == null) {
                        throw new InvalidParameterException(2, new SRMMessage("HWNTM1520E", new String[]{pAttributes[i]}));
                    }
                    Object mTest = mMethod.invoke(pCurrInst, new Object[0]);
                    mReturn.put(pAttributes[i], mMethod.invoke(pCurrInst, new Object[0]));
                    this.postProcessColumnValue(mReturn, pAttributes[i]);
                }
            } else {
                Method gcm = pCurrInst.getClass().getMethod("getColumns", new Class[0]);
                for (String attr : ((Hashtable)gcm.invoke(pCurrInst, new Object[0])).keySet()) {
                    Method mMethod = this.findGetter(mMethods, attr);
                    if (mMethod != null) {
                        Object mTest = mMethod.invoke(pCurrInst, new Object[0]);
                        mReturn.put(attr, mMethod.invoke(pCurrInst, new Object[0]));
                        this.postProcessColumnValue(mReturn, attr);
                        continue;
                    }
                    throw new InvalidParameterException(2, new SRMMessage("HWNTM1520E", new String[]{attr}));
                }
            }
            return mReturn;
        }
        catch (Exception pEx) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pEx);
            }
            throw new ServerException(new SRMMessage("HWNTM1503E", new String[]{pEx.getMessage()}));
        }
    }

    private void postProcessColumnValue(HashMap pReturn, String pAttr) {
        if (pAttr.equalsIgnoreCase("SECURITY_BREACH")) {
            short sb = (Short)pReturn.get(pAttr);
            String str = sb < this.SECBREACH2STRING.length ? this.SECBREACH2STRING[sb] : "Unknown";
            pReturn.put(pAttr, str);
        } else if (pAttr.equalsIgnoreCase("MEDIA_TYPE")) {
            short mt = (Short)pReturn.get(pAttr);
            String str = mt < this.MEDIATYPE2STRING.length ? this.MEDIATYPE2STRING[mt] : "Unknown";
            pReturn.put(pAttr, str);
        } else if (pReturn.get(pAttr) == null) {
            pReturn.put(pAttr, "");
        }
    }

    private Method findGetter(Method[] pMethods, String pMethodName) {
        String pName = pMethodName.replaceAll("_", "");
        for (int mLoop = 0; mLoop < pMethods.length; ++mLoop) {
            if (pName.matches(".*[Ii][Dd]$")) {
                String dmName = pName.replaceAll("[Ii][Dd]$", "");
                if (pMethods[mLoop].getName().equalsIgnoreCase("get" + dmName)) {
                    return pMethods[mLoop];
                }
            }
            if (!pMethods[mLoop].getName().equalsIgnoreCase("get" + pName)) continue;
            return pMethods[mLoop];
        }
        return null;
    }

    private Class getClassForCompType(int pComponentType) {
        switch (pComponentType) {
            case 1: {
                return TapeDrive.class;
            }
            case 2: {
                return TapeMediaChanger.class;
            }
            case 3: {
                return TapeIoport.class;
            }
            case 4: {
                return TapeCartridge.class;
            }
            case 5: {
                return TapeFrame.class;
            }
            case 6: {
                return TapeMediaLocation.class;
            }
            case 7: {
                return Node.class;
            }
        }
        return null;
    }

    private List getLocationsKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        TapeMediaLocation.TapeMediaLocationCursor mCursor = TapeMediaLocation.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            TapeMediaLocation mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getTag());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private List getFramesKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        TapeFrame.TapeFrameCursor mCursor = TapeFrame.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            TapeFrame mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getTag());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private List getCartridgesKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        TapeCartridge.TapeCartridgeCursor mCursor = TapeCartridge.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            TapeCartridge mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getTag());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private List getIoPortsKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        TapeIoport.TapeIoportCursor mCursor = TapeIoport.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            TapeIoport mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getTapeLibraryId() + "-multikey-" + mCurrInst.getDeviceId());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private List getChangersKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        TapeMediaChanger.TapeMediaChangerCursor mCursor = TapeMediaChanger.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            TapeMediaChanger mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getTapeLibraryId() + "-multikey-" + mCurrInst.getDeviceId());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private List getDrivesKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        TapeDrive.TapeDriveCursor mCursor = TapeDrive.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            TapeDrive mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getTapeLibraryId() + "-multikey-" + mCurrInst.getDeviceId());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private List getPortsKeysAttrs(DBConnection pConn, Hashtable pWhereClause, int pGetType, String[] pAttrs) throws SQLException {
        Node.NodeCursor mCursor = Node.getCursor((DBConnection)pConn, (Hashtable)pWhereClause, null);
        LinkedList<Object> mReturn = new LinkedList<Object>();
        while (mCursor.next()) {
            Node mCurrInst = mCursor.getAttributes();
            if (pGetType == 0) {
                mReturn.add(mCurrInst.getName() + "-multikey-" + mCurrInst.getNameFormat());
                continue;
            }
            if (pGetType != 1) continue;
            mReturn.add(this.getAttributes(mCurrInst, pAttrs));
        }
        mCursor.close();
        pConn.commit();
        if (mReturn.size() == 0 && pGetType == 1) {
            mReturn.add(null);
        }
        return mReturn;
    }

    private int getTapeLibID(DBConnection pConn, String pTapeLibID) throws SQLException {
        HashMap<String, String> mKey = new HashMap<String, String>();
        String[] keys = pTapeLibID.split("-multikey-");
        mKey.put("NAME", keys[0]);
        if (keys.length > 1) {
            mKey.put("NAME_FORMAT", keys[1]);
        }
        Hashtable mWhereClause = this.createWhereClauseMap(TapeLibrary.class, mKey);
        int libId = -1;
        TapeLibrary.TapeLibraryCursor mCursor = TapeLibrary.getCursor((DBConnection)pConn, (Hashtable)mWhereClause, null);
        while (mCursor.next()) {
            TapeLibrary mCurrInst = mCursor.getAttributes();
            libId = mCurrInst.getTapeLibraryId();
        }
        mCursor.close();
        pConn.commit();
        return libId;
    }

    public static String getNameFromKey(String pLibKey) {
        String[] keys = pLibKey.split("-multikey-");
        return keys[0];
    }

    public static short getNameFormatFromKey(String pLibKey) {
        String[] keys = pLibKey.split("-multikey-");
        if (keys.length > 1) {
            return Short.parseShort(keys[1]);
        }
        TapeReportingService repSvc = new TapeReportingService();
        HashMap attrMap = repSvc.getTapeLibraryAttributes(new String[]{keys[0]}, new String[]{"NAME_FORMAT"})[0];
        return (Short)attrMap.get("NAME_FORMAT");
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }
}

