/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.osgi;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceHelper
implements IDisposable {
    protected BundleContext cBundleContext;
    protected Map<String, ServiceReference> cServiceRefs;
    protected Map<String, Object> cOSGiServiceCache;
    public static final String WEB_SERVICE_NAME = "org.eclipse.aperi.webservice.name";

    public ServiceHelper(BundleContext pBundleContext) {
        if (pBundleContext == null) {
            throw new NullPointerException(BundleContext.class.getName());
        }
        this.cBundleContext = pBundleContext;
        this.cOSGiServiceCache = new Hashtable<String, Object>();
        this.cServiceRefs = new Hashtable<String, ServiceReference>();
    }

    public Object bindLocal(String pServiceName) {
        Object mService;
        block5: {
            mService = this.cOSGiServiceCache.get(pServiceName);
            if (mService == null) {
                try {
                    ServiceReference[] srs = this.cBundleContext.getAllServiceReferences(null, "(org.eclipse.aperi.webservice.name=" + pServiceName + ")");
                    if (srs == null) break block5;
                    for (int i = 0; i < srs.length; ++i) {
                        ServiceReference mServiceReference = srs[i];
                        String name = (String)mServiceReference.getProperty(WEB_SERVICE_NAME);
                        if (name == null || !name.equals(pServiceName) || (mService = this.cBundleContext.getService(mServiceReference)) == null) continue;
                        this.cOSGiServiceCache.put(pServiceName, mService);
                        this.cServiceRefs.put(pServiceName, mServiceReference);
                        break;
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (mService == null) {
            System.err.println("Failed to contact service " + pServiceName);
        }
        return mService;
    }

    public Object bindLocal(Class pServiceInterface) {
        String mServiceInterfaceName = pServiceInterface.getName();
        return this.bindLocalOSGiService(mServiceInterfaceName);
    }

    public Object bindLocalOSGiService(String pServiceInterfaceName) {
        ServiceReference mServiceReference;
        Object mService = this.cOSGiServiceCache.get(pServiceInterfaceName);
        if (mService == null && (mServiceReference = this.cBundleContext.getServiceReference(pServiceInterfaceName)) != null && (mService = this.cBundleContext.getService(mServiceReference)) != null) {
            this.cOSGiServiceCache.put(pServiceInterfaceName, mService);
            this.cServiceRefs.put(pServiceInterfaceName, mServiceReference);
        }
        return mService;
    }

    public void dispose() {
        this.cOSGiServiceCache.clear();
        this.cOSGiServiceCache = null;
        Set<String> mServiceRefs = this.cServiceRefs.keySet();
        for (String bServiceName : mServiceRefs) {
            this.cBundleContext.ungetService(this.cServiceRefs.remove(bServiceName));
        }
        this.cServiceRefs = null;
    }
}

