/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageCatalog;

public class EnhancedFormatter
extends Formatter {
    static final long serialVersionUID = -5325854698659692150L;
    protected static final String SPACE = "  ";
    protected transient String date = null;
    protected transient String time = null;
    protected transient String className = null;
    protected transient String methodName = null;
    protected transient String org = null;
    protected transient String product = null;
    protected transient String comp = null;
    protected transient String client = null;
    protected transient String server = null;
    protected transient String threadName = null;

    public EnhancedFormatter() {
    }

    public EnhancedFormatter(String name) {
        super(name);
    }

    public String format(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        this.initTitles();
        long timeStamp = event.getTimeStamp();
        bfr.append(this.date + SPACE + this.getDate(timeStamp) + SPACE + this.getTime(timeStamp) + this.lineSep);
        String item = event.getLoggingClass();
        if (item != null) {
            bfr.append(this.className + SPACE + item + this.lineSep);
        }
        if ((item = event.getLoggingMethod()) != null) {
            bfr.append(this.methodName + SPACE + item + this.lineSep);
        }
        if ((item = event.getOrganization()) != null && !item.equals("")) {
            bfr.append(this.org + SPACE + item + this.lineSep);
        }
        if ((item = event.getProduct()) != null && !item.equals("")) {
            bfr.append(this.product + SPACE + item + this.lineSep);
        }
        if ((item = event.getComponent()) != null && !item.equals("")) {
            bfr.append(this.comp + SPACE + item + this.lineSep);
        }
        if ((item = event.getServer()) != null && !item.equals("")) {
            bfr.append(this.server + SPACE + item + this.lineSep);
        }
        if ((item = event.getClient()) != null && !item.equals("")) {
            bfr.append(this.client + SPACE + item + this.lineSep);
        }
        bfr.append(SPACE + this.getText(event));
        return bfr.toString();
    }

    protected void initTitles() {
        if (this.date == null) {
            MessageCatalog cat = new MessageCatalog("com.ibm.log.util.Msgs", this.getLocale());
            this.date = cat.getMessage("DATE");
            this.time = cat.getMessage("TIME");
            this.className = cat.getMessage("LOGGING_CLASS");
            this.methodName = cat.getMessage("METHOD_NAME");
            this.org = cat.getMessage("ORGANIZATION");
            this.product = cat.getMessage("PRODUCT");
            this.comp = cat.getMessage("COMPONENT");
            this.client = cat.getMessage("CLIENT");
            this.server = cat.getMessage("SERVER");
            this.threadName = cat.getMessage("THREAD_NAME");
            if (this.date.equals(".")) {
                this.date = "Date:";
                this.time = "Time:";
                this.className = "Class:";
                this.methodName = "Method:";
                this.org = "Organization:";
                this.product = "Product:";
                this.comp = "Component:";
                this.client = "Client:";
                this.server = "Server:";
                this.threadName = "Thread Name:";
            }
            int max = this.date.length();
            if (this.time.length() > max) {
                max = this.time.length();
            }
            if (this.className.length() > max) {
                max = this.className.length();
            }
            if (this.methodName.length() > max) {
                max = this.methodName.length();
            }
            if (this.org.length() > max) {
                max = this.org.length();
            }
            if (this.product.length() > max) {
                max = this.product.length();
            }
            if (this.comp.length() > max) {
                max = this.comp.length();
            }
            if (this.client.length() > max) {
                max = this.client.length();
            }
            if (this.server.length() > max) {
                max = this.server.length();
            }
            if (this.threadName.length() > max) {
                max = this.threadName.length();
            }
            this.date = LogUtil.left(this.date, max);
            this.time = LogUtil.left(this.time, max);
            this.className = LogUtil.left(this.className, max);
            this.methodName = LogUtil.left(this.methodName, max);
            this.org = LogUtil.left(this.org, max);
            this.product = LogUtil.left(this.product, max);
            this.comp = LogUtil.left(this.comp, max);
            this.client = LogUtil.left(this.client, max);
            this.server = LogUtil.left(this.server, max);
            this.threadName = LogUtil.left(this.threadName, max);
        }
    }
}

