/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.StreamHandler;
import com.ibm.log.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class FileHandler
extends StreamHandler {
    static final long serialVersionUID = 8245488785648540818L;
    public static final String DEFAULT_FILE_NAME = "log.txt";
    public static final String FILE_PERM_RWD = "read,write,delete";
    public static final String SYSTEM_FILE_ENCODING = "SYSTEM.FILE.ENCODING";
    protected static final int DEFAULT_FILES = 3;
    protected static final int DEFAULT_FILE_SIZE = 1024;
    protected static final int FILE_SIZE_UNKNOWN = -1;
    protected static final String DEFAULT_ENCODING = "UTF8";
    private boolean appending = true;
    protected transient long fileSize = -1L;
    private int maxFiles = 3;
    private long maxFileSize = 0x100000L;
    private String encoding = "UTF8";
    private String fileDir = "";
    private String fileName = "log.txt";
    private FileNameParts fileParts = new FileNameParts();
    private File actualFile = new File("log.txt");

    public FileHandler() {
    }

    public FileHandler(String name) {
        super(name);
    }

    public FileHandler(String name, String file) throws AccessControlException {
        super(name);
        this.setFileName(file);
    }

    public FileHandler(String name, String file, String encoding) throws AccessControlException {
        this(name, file);
        this.setEncoding(encoding);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("fileName", this.fileName);
        if (!this.fileDir.equals("")) {
            props.put("fileDir", this.fileDir);
        }
        props.put("encoding", this.getEncoding());
        props.put("maxFiles", new Integer(this.getMaxFiles()).toString());
        props.put("maxFileBytes", new Long(this.getMaxFileBytes()).toString());
        props.put("appending", new Boolean(this.appending).toString());
        return props;
    }

    public void setConfig(Properties props) throws AccessControlException {
        super.setConfig(props);
        String newFileName = this.fileName;
        String newFileDir = this.fileDir;
        boolean changePath = false;
        String prop = props.getProperty("fileName");
        if (prop != null) {
            newFileName = prop;
            changePath = true;
        }
        if ((prop = props.getProperty("fileDir")) != null) {
            newFileDir = prop;
            changePath = true;
        }
        if (changePath) {
            this.setFileNameAndDir(newFileName, newFileDir);
        }
        if ((prop = props.getProperty("encoding")) != null) {
            this.setEncoding(prop);
        }
        if ((prop = props.getProperty("maxFiles")) != null) {
            this.setMaxFiles(new Integer(prop));
        }
        if ((prop = props.getProperty("maxFileSize")) != null) {
            this.setMaxFileSize(new Long(prop));
        }
        if ((prop = props.getProperty("maxFileBytes")) != null) {
            this.setMaxFileBytes(new Long(prop));
        }
        if ((prop = props.getProperty("appending")) != null) {
            this.setAppending(new Boolean(prop));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) throws AccessControlException {
        if (name != null) {
            this.setFileNameAndDir(name, this.fileDir);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setFileName");
            LogUtil.errorMsg(msg);
        }
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileDir(String dir) throws AccessControlException {
        if (dir != null) {
            this.setFileNameAndDir(this.fileName, dir);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setFileName");
            LogUtil.errorMsg(msg);
        }
    }

    public void setFileNameAndDir(String name, String dir) throws AccessControlException {
        if (name != null) {
            this.close();
            FileNameParts newFPs = this.buildWorkingFileParts(name, dir);
            String path = newFPs.getWorkingName();
            if (newFPs == null || path == null) {
                Object[] parms = new String[]{this.getName(), name, dir};
                String msg = LogUtil.getLogMsg("ERR_BAD_FILENAME", parms);
                LogUtil.errorMsg(msg);
                return;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new FilePermission(path, FILE_PERM_RWD));
            }
            if (dir != null) {
                this.fileDir = dir;
            }
            this.fileName = name;
            this.fileParts = newFPs;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setFileNameAndDir");
            LogUtil.errorMsg(msg);
        }
        this.actualFile = new File(this.fileParts.getWorkingName());
    }

    protected FileNameParts buildWorkingFileParts(String name, String dir) {
        String tempName;
        int dot;
        String workingName = name;
        String workingDir = null;
        String workingBase = null;
        String workingExt = null;
        if (!dir.equals("")) {
            String tempDir = dir.replace('/', File.separatorChar);
            if (!tempDir.endsWith(File.separator)) {
                tempDir = tempDir + File.separator;
            }
            workingName = tempDir + workingName;
        }
        workingName = workingName.replace('/', File.separatorChar);
        File file = new File(workingName = new File(workingName).getAbsolutePath());
        workingDir = file.getParent();
        if (workingDir != null && !workingDir.endsWith(File.separator)) {
            workingDir = workingDir + File.separator;
        }
        if ((dot = (tempName = file.getName()).lastIndexOf(46)) == -1) {
            workingBase = tempName;
            workingExt = null;
        } else {
            workingBase = tempName.substring(0, dot);
            workingExt = tempName.substring(dot);
        }
        FileNameParts fp = new FileNameParts();
        fp.setWorkingName(workingName);
        fp.setDirectory(workingDir);
        fp.setBaseName(workingBase);
        fp.setExtension(workingExt);
        return fp;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (SYSTEM_FILE_ENCODING.equals(encoding) && null == (encoding = System.getProperty("file.encoding"))) {
            encoding = DEFAULT_ENCODING;
        }
        if (encoding != null) {
            this.close();
            this.encoding = encoding;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setEncoding");
            LogUtil.errorMsg(msg);
        }
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int files) {
        if (files >= 0) {
            this.maxFiles = files;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(files), this.getClass().getName() + ".setMaxFiles");
            LogUtil.errorMsg(msg);
        }
    }

    public long getMaxFileSize() {
        return this.maxFileSize / 1024L;
    }

    public long getMaxFileBytes() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long size) {
        if (size > 0L) {
            this.maxFileSize = size * 1024L;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Long(size), this.getClass().getName() + ".setMaxFileSize");
            LogUtil.errorMsg(msg);
        }
    }

    public void setMaxFileBytes(long size) {
        if (size > 0L) {
            this.maxFileSize = size;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Long(size), this.getClass().getName() + ".setMaxFileBytes");
            LogUtil.errorMsg(msg);
        }
    }

    public boolean isAppending() {
        return this.appending;
    }

    public void setAppending(boolean flag) {
        this.close();
        this.appending = flag;
    }

    protected final boolean makePath() {
        File path;
        String filePath = this.fileParts.getWorkingName();
        File file = new File(filePath = filePath.replace('/', File.separatorChar));
        String pathName = file.getParent();
        if (pathName != null && !(path = new File(pathName)).exists()) {
            path.mkdirs();
        }
        return true;
    }

    protected final String getWorkingName() {
        return this.fileParts.getWorkingName();
    }

    protected final String getWorkingDir() {
        return this.fileParts.getDirectory();
    }

    protected final String getWorkingBase() {
        return this.fileParts.getBaseName();
    }

    protected final String getWorkingExt() {
        return this.fileParts.getExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile(boolean full) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.close();
            this.makePath();
            if (full) {
                Vector dirList = this.getDirList();
                dirList = this.deleteExtraFiles(dirList);
                this.renameFiles(dirList);
            }
            String workingName = this.fileParts.getWorkingName();
            this.actualFile = new File(workingName);
            this.fileSize = this.actualFile.length();
            FileOutputStream fos = new FileOutputStream(workingName, this.isAppending());
            this.setOutputStream(fos);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.getEncoding());
            this.bWriter = new BufferedWriter(osw);
            this.open = true;
        }
    }

    public void open() throws Exception, AccessControlException {
        boolean full;
        boolean logExists = false;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            if (this.actualFile == null) {
                this.actualFile = new File(this.fileParts.getWorkingName());
            }
            logExists = this.actualFile.exists();
            if (this.fileSize == -1L) {
                this.fileSize = this.actualFile.length();
            }
        } else {
            try {
                Boolean existsResult = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new Boolean(FileHandler.this.actualFile.exists());
                    }
                });
                logExists = existsResult;
                if (this.fileSize == -1L) {
                    Long sizeResult = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            long sz = FileHandler.this.actualFile != null ? FileHandler.this.actualFile.length() : 0L;
                            return new Long(sz);
                        }
                    });
                    this.fileSize = sizeResult;
                }
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        boolean bl = full = this.getMaxFiles() != 1 && this.fileSize >= this.maxFileSize;
        if (!this.open || full || !logExists) {
            String filePath = this.fileParts.getWorkingName();
            if (filePath == null) {
                this.setFileNameAndDir(DEFAULT_FILE_NAME, "");
            }
            if (sm == null) {
                this.openFile(full);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            FileHandler.this.openFile(full);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            this.writeHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent event) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open();
            String msg = this.getFormatter().format(event);
            this.bWriter.write(msg, 0, msg.length());
            if (addLineSep) {
                this.bWriter.write(lineSeparator, 0, lineSeparatorLength);
            }
            this.bWriter.flush();
            this.fileSize += (long)msg.length();
        }
    }

    protected void writeHeader() throws Exception {
        String header = this.getFormatter().getHeader();
        if (header != null) {
            this.bWriter.write(header, 0, header.length());
            this.bWriter.flush();
            this.fileSize += (long)header.length();
        }
    }

    protected final Vector getDirList() {
        LogFilenameFilter filter = new LogFilenameFilter();
        Vector<String> dirVector = new Vector<String>();
        File userDir = new File(this.fileParts.getDirectory());
        String[] dirList = userDir.list(filter);
        if (dirList != null) {
            for (int i = 0; i < dirList.length; ++i) {
                dirVector.addElement(dirList[i]);
            }
        }
        return this.sortFiles(dirVector);
    }

    protected final void renameFiles(Vector files) {
        File newFile;
        File oldFile;
        String newLogName;
        String workingName = this.fileParts.getWorkingName();
        String dir = this.fileParts.getDirectory();
        String workingBase = this.fileParts.getBaseName();
        String workingExt = this.fileParts.getExtension();
        String oldLogName = null;
        int logNumber = files.size() + 1;
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            oldLogName = dir + (String)e.nextElement();
            newLogName = workingExt == null ? dir + workingBase + logNumber : dir + workingBase + logNumber + workingExt;
            oldFile = new File(oldLogName);
            newFile = new File(newLogName);
            oldFile.renameTo(newFile);
            --logNumber;
        }
        newLogName = workingExt == null ? dir + workingBase + "1" : dir + workingBase + "1" + workingExt;
        oldFile = new File(workingName);
        newFile = new File(newLogName);
        oldFile.renameTo(newFile);
    }

    protected final Vector sortFiles(Vector files) {
        String workingBase = this.fileParts.getBaseName();
        String workingExt = this.fileParts.getExtension();
        int workingBaseLength = workingBase.length();
        for (int i = 0; i < files.size(); ++i) {
            String temp1 = (String)files.elementAt(i);
            for (int j = i + 1; j < files.size(); ++j) {
                int logNumber2;
                int logNumber1;
                String temp2 = (String)files.elementAt(j);
                if (workingExt == null) {
                    logNumber1 = Integer.parseInt(temp1.substring(workingBaseLength));
                    logNumber2 = Integer.parseInt(temp2.substring(workingBaseLength));
                } else {
                    logNumber1 = Integer.parseInt(temp1.substring(workingBaseLength, temp1.lastIndexOf(workingExt)));
                    logNumber2 = Integer.parseInt(temp2.substring(workingBaseLength, temp2.lastIndexOf(workingExt)));
                }
                if (logNumber1 >= logNumber2) continue;
                files.setElementAt(temp2, i);
                files.setElementAt(temp1, j);
                temp1 = temp2;
            }
        }
        return files;
    }

    protected final Vector deleteExtraFiles(Vector files) {
        String path = this.fileParts.getDirectory();
        int maxFiles = this.getMaxFiles();
        if (maxFiles > 0) {
            --maxFiles;
            while (files.size() >= maxFiles) {
                File deadFile = new File(path + (String)files.firstElement());
                deadFile.delete();
                files.removeElement(files.firstElement());
            }
        }
        return files;
    }

    private void deleteIfFileExists() {
        String workingName = this.fileParts.getWorkingName();
        String workingDir = this.fileParts.getDirectory();
        if (workingName != null) {
            File file;
            Enumeration e = this.getDirList().elements();
            while (e.hasMoreElements()) {
                file = new File(workingDir, (String)e.nextElement());
                if (!file.exists() || file.delete()) continue;
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_DELETE_FILE", file.getName()));
            }
            file = new File(workingName);
            if (file.exists() && !file.delete()) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_DELETE_FILE", file.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() throws AccessControlException {
        Object object = this.deviceLock;
        synchronized (object) {
            this.close();
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                this.deleteIfFileExists();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        FileHandler.this.deleteIfFileExists();
                        return null;
                    }
                });
            }
        }
    }

    public String toString() {
        String result = super.toString();
        return result + ", file=" + this.getWorkingName() + ", files=" + this.getMaxFiles() + ", fileSize=" + this.getMaxFileSize();
    }

    class LogFilenameFilter
    implements FilenameFilter {
        LogFilenameFilter() {
        }

        public boolean accept(File dir1, String name) {
            String workingBase = FileHandler.this.fileParts.getBaseName();
            String workingExt = FileHandler.this.fileParts.getExtension();
            boolean match = false;
            int maxFiles = FileHandler.this.getMaxFiles();
            try {
                int logNumber;
                int workingBaseLength = workingBase.length();
                if (workingExt == null) {
                    int logNumber2;
                    if (name.startsWith(workingBase) && (logNumber2 = Integer.parseInt(name.substring(workingBaseLength))) >= 1 && (maxFiles == 0 || logNumber2 < maxFiles)) {
                        match = true;
                    }
                } else if (name.startsWith(workingBase) && name.endsWith(workingExt) && (logNumber = Integer.parseInt(name.substring(workingBaseLength, name.lastIndexOf(workingExt)))) >= 1 && (maxFiles == 0 || logNumber < maxFiles)) {
                    match = true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return match;
        }
    }

    public final class FileNameParts {
        private String directory = null;
        private String baseName = null;
        private String extension = null;
        private String workingName = null;

        public String getDirectory() {
            return this.directory;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getWorkingName() {
            return this.workingName;
        }

        public void setDirectory(String dir) {
            this.directory = dir;
        }

        public void setBaseName(String base) {
            this.baseName = base;
        }

        public void setExtension(String ext) {
            this.extension = ext;
        }

        public void setWorkingName(String name) {
            this.workingName = name;
        }
    }
}

